/*
 * Decompiled with CFR 0.152.
 */
package android.app.smartspace;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class SmartspaceConfig
implements Parcelable {
    private final int mSmartspaceTargetCount;
    private final String mUiSurface;
    private String mPackageName;
    private final Bundle mExtras;
    public static final Parcelable.Creator<SmartspaceConfig> CREATOR = new Parcelable.Creator<SmartspaceConfig>(){

        @Override
        public SmartspaceConfig createFromParcel(Parcel parcel) {
            return new SmartspaceConfig(parcel);
        }

        public SmartspaceConfig[] newArray(int size) {
            return new SmartspaceConfig[size];
        }
    };

    private SmartspaceConfig(String uiSurface, int numPredictedTargets, String packageName, Bundle extras) {
        this.mUiSurface = uiSurface;
        this.mSmartspaceTargetCount = numPredictedTargets;
        this.mPackageName = packageName;
        this.mExtras = extras;
    }

    private SmartspaceConfig(Parcel parcel) {
        this.mUiSurface = parcel.readString();
        this.mSmartspaceTargetCount = parcel.readInt();
        this.mPackageName = parcel.readString();
        this.mExtras = parcel.readBundle();
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public int getSmartspaceTargetCount() {
        return this.mSmartspaceTargetCount;
    }

    public String getUiSurface() {
        return this.mUiSurface;
    }

    @SuppressLint(value={"NullableCollection"})
    public Bundle getExtras() {
        return this.mExtras;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mUiSurface);
        dest.writeInt(this.mSmartspaceTargetCount);
        dest.writeString(this.mPackageName);
        dest.writeBundle(this.mExtras);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmartspaceConfig that = (SmartspaceConfig)o;
        return this.mSmartspaceTargetCount == that.mSmartspaceTargetCount && Objects.equals(this.mUiSurface, that.mUiSurface) && Objects.equals(this.mPackageName, that.mPackageName) && Objects.equals(this.mExtras, that.mExtras);
    }

    public int hashCode() {
        return Objects.hash(this.mSmartspaceTargetCount, this.mUiSurface, this.mPackageName, this.mExtras);
    }

    @SystemApi
    public static class Builder {
        private int mSmartspaceTargetCount = 5;
        private final String mUiSurface;
        private final String mPackageName;
        private Bundle mExtras = Bundle.EMPTY;

        @SystemApi
        public Builder(Context context, String uiSurface) {
            this.mPackageName = context.getPackageName();
            this.mUiSurface = uiSurface;
        }

        public Builder setSmartspaceTargetCount(int smartspaceTargetCount) {
            this.mSmartspaceTargetCount = smartspaceTargetCount;
            return this;
        }

        public Builder setExtras(@SuppressLint(value={"NullableCollection"}) Bundle extras) {
            this.mExtras = extras;
            return this;
        }

        public SmartspaceConfig build() {
            return new SmartspaceConfig(this.mUiSurface, this.mSmartspaceTargetCount, this.mPackageName, this.mExtras);
        }
    }
}

