/*
 * Decompiled with CFR 0.152.
 */
package android.app.sdksandbox;

import android.app.sdksandbox.IRemoteSdkCallback;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ISdkSandboxManager
extends IInterface {
    public static final String DESCRIPTOR = "android.app.sdksandbox.ISdkSandboxManager";

    public void loadSdk(String var1, String var2, Bundle var3, IRemoteSdkCallback var4) throws RemoteException;

    public void requestSurfacePackage(IBinder var1, IBinder var2, int var3, Bundle var4) throws RemoteException;

    public void sendData(int var1, Bundle var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISdkSandboxManager {
        static final int TRANSACTION_loadSdk = 1;
        static final int TRANSACTION_requestSurfacePackage = 2;
        static final int TRANSACTION_sendData = 3;

        public Stub() {
            this.attachInterface(this, ISdkSandboxManager.DESCRIPTOR);
        }

        public static ISdkSandboxManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISdkSandboxManager.DESCRIPTOR);
            if (iin != null && iin instanceof ISdkSandboxManager) {
                return (ISdkSandboxManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISdkSandboxManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    IRemoteSdkCallback _arg3 = IRemoteSdkCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.loadSdk(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    IBinder _arg0 = data.readStrongBinder();
                    IBinder _arg1 = data.readStrongBinder();
                    int _arg2 = data.readInt();
                    Bundle _arg3 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestSurfacePackage(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.sendData(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements ISdkSandboxManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISdkSandboxManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void loadSdk(String callingPackage, String name, Bundle params, IRemoteSdkCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISdkSandboxManager.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(name);
                    _data.writeTypedObject(params, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestSurfacePackage(IBinder codeToken, IBinder hostToken, int displayId, Bundle params) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISdkSandboxManager.DESCRIPTOR);
                    _data.writeStrongBinder(codeToken);
                    _data.writeStrongBinder(hostToken);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(params, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendData(int id2, Bundle params) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISdkSandboxManager.DESCRIPTOR);
                    _data.writeInt(id2);
                    _data.writeTypedObject(params, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISdkSandboxManager {
        @Override
        public void loadSdk(String callingPackage, String name, Bundle params, IRemoteSdkCallback callback) throws RemoteException {
        }

        @Override
        public void requestSurfacePackage(IBinder codeToken, IBinder hostToken, int displayId, Bundle params) throws RemoteException {
        }

        @Override
        public void sendData(int id2, Bundle params) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

