/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.app.appsearch.AppSearchSchema;
import android.app.appsearch.GenericDocument;
import android.app.appsearch.PackageIdentifier;
import android.app.appsearch.SetSchemaRequest;
import android.app.appsearch.VisibilityPermissionDocument;
import android.os.Bundle;
import android.util.ArraySet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class VisibilityDocument
extends GenericDocument {
    public static final String SCHEMA_TYPE = "VisibilityType";
    public static final String NAMESPACE = "";
    private static final String NOT_DISPLAYED_BY_SYSTEM_PROPERTY = "notPlatformSurfaceable";
    private static final String PACKAGE_NAME_PROPERTY = "packageName";
    private static final String SHA_256_CERT_PROPERTY = "sha256Cert";
    private static final String PERMISSION_PROPERTY = "permission";
    public static final int SCHEMA_VERSION_DOC_PER_PACKAGE = 0;
    public static final int SCHEMA_VERSION_DOC_PER_SCHEMA = 1;
    public static final int SCHEMA_VERSION_NESTED_PERMISSION_SCHEMA = 2;
    public static final int SCHEMA_VERSION_LATEST = 2;
    public static final AppSearchSchema SCHEMA = new AppSearchSchema.Builder("VisibilityType").addProperty(new AppSearchSchema.BooleanPropertyConfig.Builder("notPlatformSurfaceable").setCardinality(2).build()).addProperty(new AppSearchSchema.StringPropertyConfig.Builder("packageName").setCardinality(1).build()).addProperty(new AppSearchSchema.BytesPropertyConfig.Builder("sha256Cert").setCardinality(1).build()).addProperty(new AppSearchSchema.DocumentPropertyConfig.Builder("permission", "VisibilityPermissionType").setCardinality(1).build()).build();

    public VisibilityDocument(GenericDocument genericDocument) {
        super(genericDocument);
    }

    public VisibilityDocument(Bundle bundle) {
        super(bundle);
    }

    public boolean isNotDisplayedBySystem() {
        return this.getPropertyBoolean(NOT_DISPLAYED_BY_SYSTEM_PROPERTY);
    }

    public String[] getPackageNames() {
        return this.getPropertyStringArray(PACKAGE_NAME_PROPERTY);
    }

    public byte[][] getSha256Certs() {
        return this.getPropertyBytesArray(SHA_256_CERT_PROPERTY);
    }

    public Set<Set<Integer>> getVisibleToPermissions() {
        GenericDocument[] permissionDocuments = this.getPropertyDocumentArray(PERMISSION_PROPERTY);
        if (permissionDocuments == null) {
            return Collections.emptySet();
        }
        ArraySet<Set<Integer>> visibleToPermissions = new ArraySet<Set<Integer>>(permissionDocuments.length);
        for (GenericDocument permissionDocument : permissionDocuments) {
            visibleToPermissions.add(new VisibilityPermissionDocument(permissionDocument).getAllRequiredPermissions());
        }
        return visibleToPermissions;
    }

    public static List<VisibilityDocument> toVisibilityDocuments(SetSchemaRequest setSchemaRequest) {
        Set<AppSearchSchema> searchSchemas = setSchemaRequest.getSchemas();
        Set<String> schemasNotDisplayedBySystem = setSchemaRequest.getSchemasNotDisplayedBySystem();
        Map<String, Set<PackageIdentifier>> schemasVisibleToPackages = setSchemaRequest.getSchemasVisibleToPackages();
        Map<String, Set<Set<Integer>>> schemasVisibleToPermissions = setSchemaRequest.getRequiredPermissionsForSchemaTypeVisibility();
        ArrayList<VisibilityDocument> visibilityDocuments = new ArrayList<VisibilityDocument>(searchSchemas.size());
        for (AppSearchSchema searchSchema : searchSchemas) {
            String schemaType = searchSchema.getSchemaType();
            Builder documentBuilder = new Builder(searchSchema.getSchemaType());
            documentBuilder.setNotDisplayedBySystem(schemasNotDisplayedBySystem.contains(schemaType));
            if (schemasVisibleToPackages.containsKey(schemaType)) {
                documentBuilder.addVisibleToPackages(schemasVisibleToPackages.get(schemaType));
            }
            if (schemasVisibleToPermissions.containsKey(schemaType)) {
                documentBuilder.setVisibleToPermissions(schemasVisibleToPermissions.get(schemaType));
            }
            visibilityDocuments.add(documentBuilder.build());
        }
        return visibilityDocuments;
    }

    public static class Builder
    extends GenericDocument.Builder<Builder> {
        private final Set<PackageIdentifier> mPackageIdentifiers = new ArraySet<PackageIdentifier>();

        public Builder(String id2) {
            super(VisibilityDocument.NAMESPACE, id2, VisibilityDocument.SCHEMA_TYPE);
        }

        public Builder setNotDisplayedBySystem(boolean notDisplayedBySystem) {
            return (Builder)this.setPropertyBoolean(VisibilityDocument.NOT_DISPLAYED_BY_SYSTEM_PROPERTY, notDisplayedBySystem);
        }

        public Builder addVisibleToPackages(Set<PackageIdentifier> packageIdentifiers) {
            Objects.requireNonNull(packageIdentifiers);
            this.mPackageIdentifiers.addAll(packageIdentifiers);
            return this;
        }

        public Builder addVisibleToPackage(PackageIdentifier packageIdentifier) {
            Objects.requireNonNull(packageIdentifier);
            this.mPackageIdentifiers.add(packageIdentifier);
            return this;
        }

        public Builder setVisibleToPermissions(Set<Set<Integer>> visibleToPermissions) {
            Objects.requireNonNull(visibleToPermissions);
            GenericDocument[] permissionDocuments = new VisibilityPermissionDocument[visibleToPermissions.size()];
            int i = 0;
            for (Set<Integer> allRequiredPermissions : visibleToPermissions) {
                permissionDocuments[i++] = new VisibilityPermissionDocument.Builder(VisibilityDocument.NAMESPACE, String.valueOf(i)).setVisibleToAllRequiredPermissions(allRequiredPermissions).build();
            }
            this.setPropertyDocument(VisibilityDocument.PERMISSION_PROPERTY, permissionDocuments);
            return this;
        }

        @Override
        public VisibilityDocument build() {
            String[] packageNames = new String[this.mPackageIdentifiers.size()];
            byte[][] sha256Certs = new byte[this.mPackageIdentifiers.size()][32];
            int i = 0;
            for (PackageIdentifier packageIdentifier : this.mPackageIdentifiers) {
                packageNames[i] = packageIdentifier.getPackageName();
                sha256Certs[i] = packageIdentifier.getSha256Certificate();
                ++i;
            }
            this.setPropertyString(VisibilityDocument.PACKAGE_NAME_PROPERTY, packageNames);
            this.setPropertyBytes(VisibilityDocument.SHA_256_CERT_PROPERTY, sha256Certs);
            return new VisibilityDocument(super.build());
        }
    }
}

