/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.SuppressLint;
import android.app.appsearch.AppSearchSchema;
import android.app.appsearch.Migrator;
import android.app.appsearch.PackageIdentifier;
import android.app.appsearch.internal.util.Preconditions;
import android.util.ArrayMap;
import android.util.ArraySet;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SetSchemaRequest {
    public static final int READ_SMS = 1;
    public static final int READ_CALENDAR = 2;
    public static final int READ_CONTACTS = 3;
    public static final int READ_EXTERNAL_STORAGE = 4;
    public static final int READ_HOME_APP_SEARCH_DATA = 5;
    public static final int READ_ASSISTANT_APP_SEARCH_DATA = 6;
    private final Set<AppSearchSchema> mSchemas;
    private final Set<String> mSchemasNotDisplayedBySystem;
    private final Map<String, Set<PackageIdentifier>> mSchemasVisibleToPackages;
    private final Map<String, Set<Set<Integer>>> mSchemasVisibleToPermissions;
    private final Map<String, Migrator> mMigrators;
    private final boolean mForceOverride;
    private final int mVersion;

    SetSchemaRequest(Set<AppSearchSchema> schemas, Set<String> schemasNotDisplayedBySystem, Map<String, Set<PackageIdentifier>> schemasVisibleToPackages, Map<String, Set<Set<Integer>>> schemasVisibleToPermissions, Map<String, Migrator> migrators, boolean forceOverride, int version) {
        this.mSchemas = Objects.requireNonNull(schemas);
        this.mSchemasNotDisplayedBySystem = Objects.requireNonNull(schemasNotDisplayedBySystem);
        this.mSchemasVisibleToPackages = Objects.requireNonNull(schemasVisibleToPackages);
        this.mSchemasVisibleToPermissions = Objects.requireNonNull(schemasVisibleToPermissions);
        this.mMigrators = Objects.requireNonNull(migrators);
        this.mForceOverride = forceOverride;
        this.mVersion = version;
    }

    public Set<AppSearchSchema> getSchemas() {
        return Collections.unmodifiableSet(this.mSchemas);
    }

    public Set<String> getSchemasNotDisplayedBySystem() {
        return Collections.unmodifiableSet(this.mSchemasNotDisplayedBySystem);
    }

    public Map<String, Set<PackageIdentifier>> getSchemasVisibleToPackages() {
        ArrayMap<String, Set<PackageIdentifier>> copy = new ArrayMap<String, Set<PackageIdentifier>>();
        for (Map.Entry<String, Set<PackageIdentifier>> entry : this.mSchemasVisibleToPackages.entrySet()) {
            copy.put(entry.getKey(), new ArraySet(entry.getValue()));
        }
        return copy;
    }

    public Map<String, Set<Set<Integer>>> getRequiredPermissionsForSchemaTypeVisibility() {
        return SetSchemaRequest.deepCopy(this.mSchemasVisibleToPermissions);
    }

    public Map<String, Migrator> getMigrators() {
        return Collections.unmodifiableMap(this.mMigrators);
    }

    public Map<String, Set<PackageIdentifier>> getSchemasVisibleToPackagesInternal() {
        return this.mSchemasVisibleToPackages;
    }

    public boolean isForceOverride() {
        return this.mForceOverride;
    }

    public int getVersion() {
        return this.mVersion;
    }

    static ArrayMap<String, Set<Set<Integer>>> deepCopy(Map<String, Set<Set<Integer>>> original) {
        ArrayMap<String, Set<Set<Integer>>> copy = new ArrayMap<String, Set<Set<Integer>>>(original.size());
        for (Map.Entry<String, Set<Set<Integer>>> entry : original.entrySet()) {
            ArraySet<ArraySet<Integer>> valueCopy = new ArraySet<ArraySet<Integer>>();
            for (Set<Integer> innerValue : entry.getValue()) {
                valueCopy.add(new ArraySet<Integer>(innerValue));
            }
            copy.put(entry.getKey(), valueCopy);
        }
        return copy;
    }

    public static class Builder {
        private static final int DEFAULT_VERSION = 1;
        private ArraySet<AppSearchSchema> mSchemas = new ArraySet();
        private ArraySet<String> mSchemasNotDisplayedBySystem = new ArraySet();
        private ArrayMap<String, Set<PackageIdentifier>> mSchemasVisibleToPackages = new ArrayMap();
        private ArrayMap<String, Set<Set<Integer>>> mSchemasVisibleToPermissions = new ArrayMap();
        private ArrayMap<String, Migrator> mMigrators = new ArrayMap();
        private boolean mForceOverride = false;
        private int mVersion = 1;
        private boolean mBuilt = false;

        public Builder addSchemas(AppSearchSchema ... schemas) {
            Objects.requireNonNull(schemas);
            this.resetIfBuilt();
            return this.addSchemas(Arrays.asList(schemas));
        }

        public Builder addSchemas(Collection<AppSearchSchema> schemas) {
            Objects.requireNonNull(schemas);
            this.resetIfBuilt();
            this.mSchemas.addAll(schemas);
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setSchemaTypeDisplayedBySystem(String schemaType, boolean displayed) {
            Objects.requireNonNull(schemaType);
            this.resetIfBuilt();
            if (displayed) {
                this.mSchemasNotDisplayedBySystem.remove(schemaType);
            } else {
                this.mSchemasNotDisplayedBySystem.add(schemaType);
            }
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addRequiredPermissionsForSchemaTypeVisibility(String schemaType, Set<Integer> permissions) {
            Objects.requireNonNull(schemaType);
            Objects.requireNonNull(permissions);
            for (int permission2 : permissions) {
                Preconditions.checkArgumentInRange(permission2, 1, 6, "permission");
            }
            this.resetIfBuilt();
            Set<Set<Integer>> visibleToPermissions = this.mSchemasVisibleToPermissions.get(schemaType);
            if (visibleToPermissions == null) {
                visibleToPermissions = new ArraySet<Set<Integer>>();
                this.mSchemasVisibleToPermissions.put(schemaType, visibleToPermissions);
            }
            visibleToPermissions.add(permissions);
            return this;
        }

        public Builder clearRequiredPermissionsForSchemaTypeVisibility(String schemaType) {
            Objects.requireNonNull(schemaType);
            this.resetIfBuilt();
            this.mSchemasVisibleToPermissions.remove(schemaType);
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setSchemaTypeVisibilityForPackage(String schemaType, boolean visible, PackageIdentifier packageIdentifier) {
            Objects.requireNonNull(schemaType);
            Objects.requireNonNull(packageIdentifier);
            this.resetIfBuilt();
            Set<PackageIdentifier> packageIdentifiers = this.mSchemasVisibleToPackages.get(schemaType);
            if (visible) {
                if (packageIdentifiers == null) {
                    packageIdentifiers = new ArraySet<PackageIdentifier>();
                }
                packageIdentifiers.add(packageIdentifier);
                this.mSchemasVisibleToPackages.put(schemaType, packageIdentifiers);
            } else {
                if (packageIdentifiers == null) {
                    return this;
                }
                packageIdentifiers.remove(packageIdentifier);
                if (packageIdentifiers.isEmpty()) {
                    this.mSchemasVisibleToPackages.remove(schemaType);
                }
            }
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setMigrator(String schemaType, Migrator migrator) {
            Objects.requireNonNull(schemaType);
            Objects.requireNonNull(migrator);
            this.resetIfBuilt();
            this.mMigrators.put(schemaType, migrator);
            return this;
        }

        public Builder setMigrators(Map<String, Migrator> migrators) {
            Objects.requireNonNull(migrators);
            this.resetIfBuilt();
            this.mMigrators.putAll(migrators);
            return this;
        }

        public Builder setForceOverride(boolean forceOverride) {
            this.resetIfBuilt();
            this.mForceOverride = forceOverride;
            return this;
        }

        public Builder setVersion(int version) {
            Preconditions.checkArgument(version >= 1, "Version must be a positive number.");
            this.resetIfBuilt();
            this.mVersion = version;
            return this;
        }

        public SetSchemaRequest build() {
            ArraySet<String> referencedSchemas = new ArraySet<String>(this.mSchemasNotDisplayedBySystem);
            referencedSchemas.addAll(this.mSchemasVisibleToPackages.keySet());
            referencedSchemas.addAll(this.mSchemasVisibleToPermissions.keySet());
            for (AppSearchSchema schema : this.mSchemas) {
                referencedSchemas.remove(schema.getSchemaType());
            }
            if (!referencedSchemas.isEmpty()) {
                throw new IllegalArgumentException("Schema types " + referencedSchemas + " referenced, but were not added.");
            }
            if (this.mSchemas.isEmpty() && this.mVersion != 1) {
                throw new IllegalArgumentException("Cannot set version to the request if schema is empty.");
            }
            this.mBuilt = true;
            return new SetSchemaRequest(this.mSchemas, this.mSchemasNotDisplayedBySystem, this.mSchemasVisibleToPackages, this.mSchemasVisibleToPermissions, this.mMigrators, this.mForceOverride, this.mVersion);
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                ArrayMap schemasVisibleToPackages = new ArrayMap(this.mSchemasVisibleToPackages.size());
                for (Map.Entry<String, Set<PackageIdentifier>> entry : this.mSchemasVisibleToPackages.entrySet()) {
                    schemasVisibleToPackages.put(entry.getKey(), new ArraySet(entry.getValue()));
                }
                this.mSchemasVisibleToPackages = schemasVisibleToPackages;
                this.mSchemasVisibleToPermissions = SetSchemaRequest.deepCopy(this.mSchemasVisibleToPermissions);
                this.mSchemas = new ArraySet<AppSearchSchema>(this.mSchemas);
                this.mSchemasNotDisplayedBySystem = new ArraySet<String>(this.mSchemasNotDisplayedBySystem);
                this.mMigrators = new ArrayMap<String, Migrator>(this.mMigrators);
                this.mBuilt = false;
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AppSearchSupportedPermission {
    }
}

