/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.app.appsearch.SearchResult;
import android.os.Bundle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SearchResultPage {
    public static final String RESULTS_FIELD = "results";
    public static final String NEXT_PAGE_TOKEN_FIELD = "nextPageToken";
    private final long mNextPageToken;
    private List<SearchResult> mResults;
    private final Bundle mBundle;

    public SearchResultPage(Bundle bundle) {
        this.mBundle = Objects.requireNonNull(bundle);
        this.mNextPageToken = this.mBundle.getLong(NEXT_PAGE_TOKEN_FIELD);
    }

    public Bundle getBundle() {
        return this.mBundle;
    }

    public long getNextPageToken() {
        return this.mNextPageToken;
    }

    public List<SearchResult> getResults() {
        if (this.mResults == null) {
            ArrayList resultBundles = this.mBundle.getParcelableArrayList(RESULTS_FIELD);
            if (resultBundles == null) {
                this.mResults = Collections.emptyList();
            } else {
                this.mResults = new ArrayList<SearchResult>(resultBundles.size());
                for (int i = 0; i < resultBundles.size(); ++i) {
                    this.mResults.add(new SearchResult((Bundle)resultBundles.get(i)));
                }
            }
        }
        return this.mResults;
    }
}

