/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.app.appsearch.GenericDocument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PutDocumentsRequest {
    private final List<GenericDocument> mDocuments;

    PutDocumentsRequest(List<GenericDocument> documents) {
        this.mDocuments = documents;
    }

    public List<GenericDocument> getGenericDocuments() {
        return Collections.unmodifiableList(this.mDocuments);
    }

    public static class Builder {
        private ArrayList<GenericDocument> mDocuments = new ArrayList();
        private boolean mBuilt = false;

        public Builder addGenericDocuments(GenericDocument ... documents) {
            Objects.requireNonNull(documents);
            this.resetIfBuilt();
            return this.addGenericDocuments(Arrays.asList(documents));
        }

        public Builder addGenericDocuments(Collection<? extends GenericDocument> documents) {
            Objects.requireNonNull(documents);
            this.resetIfBuilt();
            this.mDocuments.addAll(documents);
            return this;
        }

        public PutDocumentsRequest build() {
            this.mBuilt = true;
            return new PutDocumentsRequest(this.mDocuments);
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                this.mDocuments = new ArrayList<GenericDocument>(this.mDocuments);
                this.mBuilt = false;
            }
        }
    }
}

