/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.app.appsearch.AppSearchManager;
import android.app.appsearch.AppSearchMigrationHelper;
import android.app.appsearch.AppSearchResult;
import android.app.appsearch.AppSearchSchema;
import android.app.appsearch.BatchResultCallback;
import android.app.appsearch.GenericDocument;
import android.app.appsearch.GetByDocumentIdRequest;
import android.app.appsearch.GetSchemaResponse;
import android.app.appsearch.Migrator;
import android.app.appsearch.PutDocumentsRequest;
import android.app.appsearch.RemoveByDocumentIdRequest;
import android.app.appsearch.ReportUsageRequest;
import android.app.appsearch.SearchResults;
import android.app.appsearch.SearchSessionUtil;
import android.app.appsearch.SearchSpec;
import android.app.appsearch.SetSchemaRequest;
import android.app.appsearch.SetSchemaResponse;
import android.app.appsearch.StorageInfo;
import android.app.appsearch.VisibilityDocument;
import android.app.appsearch.aidl.AppSearchBatchResultParcel;
import android.app.appsearch.aidl.AppSearchResultParcel;
import android.app.appsearch.aidl.DocumentsParcel;
import android.app.appsearch.aidl.IAppSearchBatchResultCallback;
import android.app.appsearch.aidl.IAppSearchManager;
import android.app.appsearch.aidl.IAppSearchResultCallback;
import android.app.appsearch.internal.util.Preconditions;
import android.app.appsearch.util.SchemaMigrationUtil;
import android.content.AttributionSource;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.ArraySet;
import android.util.Log;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class AppSearchSession
implements Closeable {
    private static final String TAG = "AppSearchSession";
    private final AttributionSource mCallerAttributionSource;
    private final String mDatabaseName;
    private final UserHandle mUserHandle;
    private final IAppSearchManager mService;
    private boolean mIsMutated = false;
    private boolean mIsClosed = false;

    static void createSearchSession(AppSearchManager.SearchContext searchContext, IAppSearchManager service, UserHandle userHandle, AttributionSource callerAttributionSource, Executor executor, Consumer<AppSearchResult<AppSearchSession>> callback) {
        AppSearchSession searchSession = new AppSearchSession(service, userHandle, callerAttributionSource, searchContext.mDatabaseName);
        searchSession.initialize(executor, callback);
    }

    private void initialize(final Executor executor, final Consumer<AppSearchResult<AppSearchSession>> callback) {
        try {
            this.mService.initialize(this.mCallerAttributionSource, this.mUserHandle, SystemClock.elapsedRealtime(), new IAppSearchResultCallback.Stub(){

                @Override
                public void onResult(AppSearchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> {
                        AppSearchResult result = resultParcel.getResult();
                        if (result.isSuccess()) {
                            callback.accept(AppSearchResult.newSuccessfulResult(AppSearchSession.this));
                        } else {
                            callback.accept(AppSearchResult.newFailedResult(result));
                        }
                    });
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private AppSearchSession(IAppSearchManager service, UserHandle userHandle, AttributionSource callerAttributionSource, String databaseName) {
        this.mService = service;
        this.mUserHandle = userHandle;
        this.mCallerAttributionSource = callerAttributionSource;
        this.mDatabaseName = databaseName;
    }

    public void setSchema(SetSchemaRequest request, Executor workExecutor, Executor callbackExecutor, Consumer<AppSearchResult<SetSchemaResponse>> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(workExecutor);
        Objects.requireNonNull(callbackExecutor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        ArrayList<Bundle> schemaBundles = new ArrayList<Bundle>(request.getSchemas().size());
        for (AppSearchSchema schema : request.getSchemas()) {
            schemaBundles.add(schema.getBundle());
        }
        List<VisibilityDocument> visibilityDocuments = VisibilityDocument.toVisibilityDocuments(request);
        ArrayList<Bundle> visibilityBundles = new ArrayList<Bundle>(visibilityDocuments.size());
        for (int i = 0; i < visibilityDocuments.size(); ++i) {
            visibilityBundles.add(visibilityDocuments.get(i).getBundle());
        }
        if (request.getMigrators().isEmpty()) {
            this.setSchemaNoMigrations(request, schemaBundles, visibilityBundles, callbackExecutor, callback);
        } else {
            this.setSchemaWithMigrations(request, schemaBundles, visibilityBundles, workExecutor, callbackExecutor, callback);
        }
        this.mIsMutated = true;
    }

    public void getSchema(final Executor executor, final Consumer<AppSearchResult<GetSchemaResponse>> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        try {
            this.mService.getSchema(this.mCallerAttributionSource, this.mCallerAttributionSource.getPackageName(), this.mDatabaseName, this.mUserHandle, new IAppSearchResultCallback.Stub(){

                @Override
                public void onResult(AppSearchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> {
                        AppSearchResult result = resultParcel.getResult();
                        if (result.isSuccess()) {
                            GetSchemaResponse response = new GetSchemaResponse((Bundle)result.getResultValue());
                            callback.accept(AppSearchResult.newSuccessfulResult(response));
                        } else {
                            callback.accept(AppSearchResult.newFailedResult(result));
                        }
                    });
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void getNamespaces(final Executor executor, final Consumer<AppSearchResult<Set<String>>> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        try {
            this.mService.getNamespaces(this.mCallerAttributionSource, this.mDatabaseName, this.mUserHandle, new IAppSearchResultCallback.Stub(){

                @Override
                public void onResult(AppSearchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> {
                        AppSearchResult result = resultParcel.getResult();
                        if (result.isSuccess()) {
                            ArraySet namespaces = new ArraySet((Collection)result.getResultValue());
                            callback.accept(AppSearchResult.newSuccessfulResult(namespaces));
                        } else {
                            callback.accept(AppSearchResult.newFailedResult(result));
                        }
                    });
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void put(PutDocumentsRequest request, final Executor executor, final BatchResultCallback<String, Void> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        DocumentsParcel documentsParcel = new DocumentsParcel(request.getGenericDocuments());
        try {
            this.mService.putDocuments(this.mCallerAttributionSource, this.mDatabaseName, documentsParcel, this.mUserHandle, SystemClock.elapsedRealtime(), new IAppSearchBatchResultCallback.Stub(){

                @Override
                public void onResult(AppSearchBatchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> callback.onResult(resultParcel.getResult()));
                }

                @Override
                public void onSystemError(AppSearchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> SearchSessionUtil.sendSystemErrorToCallback(resultParcel.getResult(), callback));
                }
            });
            this.mIsMutated = true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void getByDocumentId(GetByDocumentIdRequest request, Executor executor, BatchResultCallback<String, GenericDocument> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        try {
            this.mService.getDocuments(this.mCallerAttributionSource, this.mCallerAttributionSource.getPackageName(), this.mDatabaseName, request.getNamespace(), new ArrayList<String>(request.getIds()), request.getProjectionsInternal(), this.mUserHandle, SystemClock.elapsedRealtime(), SearchSessionUtil.createGetDocumentCallback(executor, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public SearchResults search(String queryExpression, SearchSpec searchSpec) {
        Objects.requireNonNull(queryExpression);
        Objects.requireNonNull(searchSpec);
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        return new SearchResults(this.mService, this.mCallerAttributionSource, this.mDatabaseName, queryExpression, searchSpec, this.mUserHandle);
    }

    public void reportUsage(ReportUsageRequest request, final Executor executor, final Consumer<AppSearchResult<Void>> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        try {
            this.mService.reportUsage(this.mCallerAttributionSource, this.mCallerAttributionSource.getPackageName(), this.mDatabaseName, request.getNamespace(), request.getDocumentId(), request.getUsageTimestampMillis(), false, this.mUserHandle, new IAppSearchResultCallback.Stub(){

                @Override
                public void onResult(AppSearchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> callback.accept(resultParcel.getResult()));
                }
            });
            this.mIsMutated = true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void remove(RemoveByDocumentIdRequest request, final Executor executor, final BatchResultCallback<String, Void> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        try {
            this.mService.removeByDocumentId(this.mCallerAttributionSource, this.mDatabaseName, request.getNamespace(), new ArrayList<String>(request.getIds()), this.mUserHandle, SystemClock.elapsedRealtime(), new IAppSearchBatchResultCallback.Stub(){

                @Override
                public void onResult(AppSearchBatchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> callback.onResult(resultParcel.getResult()));
                }

                @Override
                public void onSystemError(AppSearchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> SearchSessionUtil.sendSystemErrorToCallback(resultParcel.getResult(), callback));
                }
            });
            this.mIsMutated = true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void remove(String queryExpression, SearchSpec searchSpec, final Executor executor, final Consumer<AppSearchResult<Void>> callback) {
        Objects.requireNonNull(queryExpression);
        Objects.requireNonNull(searchSpec);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        try {
            this.mService.removeByQuery(this.mCallerAttributionSource, this.mDatabaseName, queryExpression, searchSpec.getBundle(), this.mUserHandle, SystemClock.elapsedRealtime(), new IAppSearchResultCallback.Stub(){

                @Override
                public void onResult(AppSearchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> callback.accept(resultParcel.getResult()));
                }
            });
            this.mIsMutated = true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void getStorageInfo(final Executor executor, final Consumer<AppSearchResult<StorageInfo>> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "AppSearchSession has already been closed");
        try {
            this.mService.getStorageInfo(this.mCallerAttributionSource, this.mDatabaseName, this.mUserHandle, new IAppSearchResultCallback.Stub(){

                @Override
                public void onResult(AppSearchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> {
                        AppSearchResult result = resultParcel.getResult();
                        if (result.isSuccess()) {
                            StorageInfo response = new StorageInfo((Bundle)result.getResultValue());
                            callback.accept(AppSearchResult.newSuccessfulResult(response));
                        } else {
                            callback.accept(AppSearchResult.newFailedResult(result));
                        }
                    });
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void close() {
        if (this.mIsMutated && !this.mIsClosed) {
            try {
                this.mService.persistToDisk(this.mCallerAttributionSource, this.mUserHandle, SystemClock.elapsedRealtime());
                this.mIsClosed = true;
            }
            catch (RemoteException e) {
                Log.e(TAG, "Unable to close the AppSearchSession", e);
            }
        }
    }

    private void setSchemaNoMigrations(final SetSchemaRequest request, List<Bundle> schemaBundles, List<Bundle> visibilityBundles, final Executor executor, final Consumer<AppSearchResult<SetSchemaResponse>> callback) {
        try {
            this.mService.setSchema(this.mCallerAttributionSource, this.mDatabaseName, schemaBundles, visibilityBundles, request.isForceOverride(), request.getVersion(), this.mUserHandle, SystemClock.elapsedRealtime(), new IAppSearchResultCallback.Stub(){

                @Override
                public void onResult(AppSearchResultParcel resultParcel) {
                    SearchSessionUtil.safeExecute(executor, callback, () -> {
                        AppSearchResult result = resultParcel.getResult();
                        if (result.isSuccess()) {
                            try {
                                SetSchemaResponse setSchemaResponse = new SetSchemaResponse((Bundle)result.getResultValue());
                                if (!request.isForceOverride()) {
                                    SchemaMigrationUtil.checkDeletedAndIncompatible(setSchemaResponse.getDeletedTypes(), setSchemaResponse.getIncompatibleTypes());
                                }
                                callback.accept(AppSearchResult.newSuccessfulResult(setSchemaResponse));
                            }
                            catch (Throwable t) {
                                callback.accept(AppSearchResult.throwableToFailedResult(t));
                            }
                        } else {
                            callback.accept(AppSearchResult.newFailedResult(result));
                        }
                    });
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void setSchemaWithMigrations(SetSchemaRequest request, List<Bundle> schemaBundles, List<Bundle> visibilityBundles, Executor workExecutor, Executor callbackExecutor, Consumer<AppSearchResult<SetSchemaResponse>> callback) {
        SearchSessionUtil.safeExecute(workExecutor, callback, () -> {
            try {
                CompletableFuture getSchemaFuture = new CompletableFuture();
                this.getSchema(callbackExecutor, getSchemaFuture::complete);
                AppSearchResult getSchemaResult = (AppSearchResult)getSchemaFuture.get();
                if (!getSchemaResult.isSuccess()) {
                    SearchSessionUtil.safeExecute(callbackExecutor, callback, () -> callback.accept(AppSearchResult.newFailedResult(getSchemaResult)));
                    return;
                }
                GetSchemaResponse getSchemaResponse = (GetSchemaResponse)getSchemaResult.getResultValue();
                int currentVersion = getSchemaResponse.getVersion();
                int finalVersion = request.getVersion();
                Map<String, Migrator> activeMigrators = SchemaMigrationUtil.getActiveMigrators(getSchemaResponse.getSchemas(), request.getMigrators(), currentVersion, finalVersion);
                if (activeMigrators.isEmpty()) {
                    this.setSchemaNoMigrations(request, schemaBundles, visibilityBundles, callbackExecutor, callback);
                    return;
                }
                final CompletableFuture setSchemaFuture = new CompletableFuture();
                this.mService.setSchema(this.mCallerAttributionSource, this.mDatabaseName, schemaBundles, visibilityBundles, false, request.getVersion(), this.mUserHandle, SystemClock.elapsedRealtime(), new IAppSearchResultCallback.Stub(){

                    @Override
                    public void onResult(AppSearchResultParcel resultParcel) {
                        setSchemaFuture.complete(resultParcel.getResult());
                    }
                });
                AppSearchResult setSchemaResult = (AppSearchResult)setSchemaFuture.get();
                if (!setSchemaResult.isSuccess()) {
                    SearchSessionUtil.safeExecute(callbackExecutor, callback, () -> callback.accept(AppSearchResult.newFailedResult(setSchemaResult)));
                    return;
                }
                SetSchemaResponse setSchemaResponse = new SetSchemaResponse((Bundle)setSchemaResult.getResultValue());
                if (!request.isForceOverride()) {
                    SchemaMigrationUtil.checkDeletedAndIncompatibleAfterMigration(setSchemaResponse, activeMigrators.keySet());
                }
                try (AppSearchMigrationHelper migrationHelper = new AppSearchMigrationHelper(this.mService, this.mUserHandle, this.mCallerAttributionSource, this.mDatabaseName, request.getSchemas());){
                    for (Map.Entry<String, Migrator> entry : activeMigrators.entrySet()) {
                        migrationHelper.queryAndTransform(entry.getKey(), entry.getValue(), currentVersion, finalVersion);
                    }
                    if (!setSchemaResponse.getIncompatibleTypes().isEmpty() || !setSchemaResponse.getDeletedTypes().isEmpty()) {
                        final CompletableFuture setSchema2Future = new CompletableFuture();
                        this.mService.setSchema(this.mCallerAttributionSource, this.mDatabaseName, schemaBundles, visibilityBundles, true, request.getVersion(), this.mUserHandle, SystemClock.elapsedRealtime(), new IAppSearchResultCallback.Stub(){

                            @Override
                            public void onResult(AppSearchResultParcel resultParcel) {
                                setSchema2Future.complete(resultParcel.getResult());
                            }
                        });
                        AppSearchResult setSchema2Result = (AppSearchResult)setSchema2Future.get();
                        if (!setSchema2Result.isSuccess()) {
                            SearchSessionUtil.safeExecute(callbackExecutor, callback, () -> callback.accept(AppSearchResult.newFailedResult(setSchema2Result)));
                            return;
                        }
                    }
                    SetSchemaResponse.Builder responseBuilder = setSchemaResponse.toBuilder().addMigratedTypes(activeMigrators.keySet());
                    AppSearchResult<SetSchemaResponse> putResult = migrationHelper.putMigratedDocuments(responseBuilder);
                    SearchSessionUtil.safeExecute(callbackExecutor, callback, () -> callback.accept(putResult));
                }
            }
            catch (Throwable t) {
                SearchSessionUtil.safeExecute(callbackExecutor, callback, () -> callback.accept(AppSearchResult.throwableToFailedResult(t)));
            }
        });
    }
}

