/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.content.ComponentName;
import android.content.Intent;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.util.Log;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;

class ProvisioningIntentHelper {
    private static final Map<String, Class> EXTRAS_TO_CLASS_MAP = ProvisioningIntentHelper.createExtrasToClassMap();
    private static final String TAG = "ProvisioningIntentHelper";

    private ProvisioningIntentHelper() {
    }

    public static Intent createProvisioningIntentFromNfcIntent(Intent nfcIntent) {
        Objects.requireNonNull(nfcIntent);
        if (!"android.nfc.action.NDEF_DISCOVERED".equals(nfcIntent.getAction())) {
            Log.e(TAG, "Wrong Nfc action: " + nfcIntent.getAction());
            return null;
        }
        NdefRecord firstRecord = ProvisioningIntentHelper.getFirstNdefRecord(nfcIntent);
        if (firstRecord != null) {
            return ProvisioningIntentHelper.createProvisioningIntentFromNdefRecord(firstRecord);
        }
        return null;
    }

    private static Intent createProvisioningIntentFromNdefRecord(NdefRecord firstRecord) {
        Objects.requireNonNull(firstRecord);
        Properties properties = ProvisioningIntentHelper.loadPropertiesFromPayload(firstRecord.getPayload());
        if (properties == null) {
            Log.e(TAG, "Failed to load NdefRecord properties.");
            return null;
        }
        Bundle bundle = ProvisioningIntentHelper.createBundleFromProperties(properties);
        if (!ProvisioningIntentHelper.containsRequiredProvisioningExtras(bundle)) {
            Log.e(TAG, "Bundle does not contain the required provisioning extras.");
            return null;
        }
        return ProvisioningIntentHelper.createProvisioningIntentFromBundle(bundle);
    }

    private static Properties loadPropertiesFromPayload(byte[] payload) {
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(new String(payload, StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            Log.e(TAG, "NFC Intent properties loading failed.");
            return null;
        }
        return properties;
    }

    private static Bundle createBundleFromProperties(Properties properties) {
        Enumeration<?> propertyNames = properties.propertyNames();
        Bundle bundle = new Bundle();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            ProvisioningIntentHelper.addPropertyToBundle(propertyName, properties, bundle);
        }
        return bundle;
    }

    private static void addPropertyToBundle(String propertyName, Properties properties, Bundle bundle) {
        if (EXTRAS_TO_CLASS_MAP.get(propertyName) == ComponentName.class) {
            ComponentName componentName = ComponentName.unflattenFromString(properties.getProperty(propertyName));
            bundle.putParcelable(propertyName, componentName);
        } else if (EXTRAS_TO_CLASS_MAP.get(propertyName) == PersistableBundle.class) {
            try {
                bundle.putParcelable(propertyName, ProvisioningIntentHelper.deserializeExtrasBundle(properties, propertyName));
            }
            catch (IOException e) {
                Log.e(TAG, "Failed to parse " + propertyName + ".", e);
            }
        } else if (EXTRAS_TO_CLASS_MAP.get(propertyName) == Boolean.class) {
            bundle.putBoolean(propertyName, Boolean.parseBoolean(properties.getProperty(propertyName)));
        } else if (EXTRAS_TO_CLASS_MAP.get(propertyName) == Long.class) {
            bundle.putLong(propertyName, Long.parseLong(properties.getProperty(propertyName)));
        } else if (EXTRAS_TO_CLASS_MAP.get(propertyName) == Integer.class) {
            bundle.putInt(propertyName, Integer.parseInt(properties.getProperty(propertyName)));
        } else {
            bundle.putString(propertyName, properties.getProperty(propertyName));
        }
    }

    private static PersistableBundle deserializeExtrasBundle(Properties properties, String extraName) throws IOException {
        String serializedExtras = properties.getProperty(extraName);
        if (serializedExtras == null) {
            return null;
        }
        Properties bundleProperties = new Properties();
        bundleProperties.load(new StringReader(serializedExtras));
        PersistableBundle extrasBundle = new PersistableBundle(bundleProperties.size());
        Set<String> propertyNames = bundleProperties.stringPropertyNames();
        for (String propertyName : propertyNames) {
            extrasBundle.putString(propertyName, bundleProperties.getProperty(propertyName));
        }
        return extrasBundle;
    }

    private static Intent createProvisioningIntentFromBundle(Bundle bundle) {
        Objects.requireNonNull(bundle);
        Intent provisioningIntent = new Intent("android.app.action.PROVISION_MANAGED_DEVICE_FROM_TRUSTED_SOURCE");
        provisioningIntent.putExtras(bundle);
        provisioningIntent.putExtra("android.app.extra.PROVISIONING_TRIGGER", 5);
        return provisioningIntent;
    }

    private static boolean containsRequiredProvisioningExtras(Bundle bundle) {
        return bundle.containsKey("android.app.extra.PROVISIONING_DEVICE_ADMIN_PACKAGE_NAME") || bundle.containsKey("android.app.extra.PROVISIONING_DEVICE_ADMIN_COMPONENT_NAME");
    }

    private static NdefRecord getFirstNdefRecord(Intent nfcIntent) {
        Parcelable[] ndefMessages = nfcIntent.getParcelableArrayExtra("android.nfc.extra.NDEF_MESSAGES");
        if (ndefMessages == null) {
            Log.i(TAG, "No EXTRA_NDEF_MESSAGES from nfcIntent");
            return null;
        }
        Parcelable[] parcelableArray = ndefMessages;
        int n = parcelableArray.length;
        for (int i = 0; i < n; ++i) {
            NdefRecord record;
            String mimeType;
            int n2 = 0;
            Parcelable rawMsg = parcelableArray[i];
            NdefMessage msg = (NdefMessage)rawMsg;
            NdefRecord[] ndefRecordArray = msg.getRecords();
            int n3 = ndefRecordArray.length;
            if (n2 >= n3 || !"application/com.android.managedprovisioning".equals(mimeType = new String((record = ndefRecordArray[n2]).getType(), StandardCharsets.UTF_8))) continue;
            return record;
        }
        Log.i(TAG, "No compatible records found on nfcIntent");
        return null;
    }

    private static Map<String, Class> createExtrasToClassMap() {
        HashMap<String, Class> map = new HashMap<String, Class>();
        for (String extra : ProvisioningIntentHelper.getBooleanExtras()) {
            map.put(extra, Boolean.class);
        }
        for (String extra : ProvisioningIntentHelper.getLongExtras()) {
            map.put(extra, Long.class);
        }
        for (String extra : ProvisioningIntentHelper.getIntExtras()) {
            map.put(extra, Integer.class);
        }
        for (String extra : ProvisioningIntentHelper.getComponentNameExtras()) {
            map.put(extra, ComponentName.class);
        }
        for (String extra : ProvisioningIntentHelper.getPersistableBundleExtras()) {
            map.put(extra, PersistableBundle.class);
        }
        return map;
    }

    private static Set<String> getPersistableBundleExtras() {
        return Set.of("android.app.extra.PROVISIONING_ADMIN_EXTRAS_BUNDLE", "android.app.extra.PROVISIONING_ROLE_HOLDER_EXTRAS_BUNDLE");
    }

    private static Set<String> getComponentNameExtras() {
        return Set.of("android.app.extra.PROVISIONING_DEVICE_ADMIN_COMPONENT_NAME");
    }

    private static Set<String> getIntExtras() {
        return Set.of("android.app.extra.PROVISIONING_WIFI_PROXY_PORT", "android.app.extra.PROVISIONING_DEVICE_ADMIN_MINIMUM_VERSION_CODE", "android.app.extra.PROVISIONING_SUPPORTED_MODES");
    }

    private static Set<String> getLongExtras() {
        return Set.of("android.app.extra.PROVISIONING_LOCAL_TIME");
    }

    private static Set<String> getBooleanExtras() {
        return Set.of("android.app.extra.PROVISIONING_ALLOW_OFFLINE", "android.app.extra.PROVISIONING_SHOULD_LAUNCH_RESULT_INTENT", "android.app.extra.PROVISIONING_KEEP_ACCOUNT_ON_MIGRATION", "android.app.extra.PROVISIONING_LEAVE_ALL_SYSTEM_APPS_ENABLED", "android.app.extra.PROVISIONING_WIFI_HIDDEN", "android.app.extra.PROVISIONING_SENSORS_PERMISSION_GRANT_OPT_OUT", "android.app.extra.PROVISIONING_SKIP_ENCRYPTION", "android.app.extra.PROVISIONING_SKIP_EDUCATION_SCREENS", "android.app.extra.PROVISIONING_USE_MOBILE_DATA", "android.app.extra.PROVISIONING_SKIP_OWNERSHIP_DISCLAIMER", "android.app.extra.PROVISIONING_RETURN_BEFORE_POLICY_COMPLIANCE", "android.app.extra.PROVISIONING_KEEP_SCREEN_ON");
    }
}

