/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.annotation.SystemApi;
import android.app.admin.ParcelableResource;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class DevicePolicyDrawableResource
implements Parcelable {
    private final String mDrawableId;
    private final String mDrawableStyle;
    private final String mDrawableSource;
    private final int mResourceIdInCallingPackage;
    private ParcelableResource mResource;
    public static final Parcelable.Creator<DevicePolicyDrawableResource> CREATOR = new Parcelable.Creator<DevicePolicyDrawableResource>(){

        @Override
        public DevicePolicyDrawableResource createFromParcel(Parcel in) {
            String drawableId = in.readString();
            String drawableStyle = in.readString();
            String drawableSource = in.readString();
            int resourceIdInCallingPackage = in.readInt();
            ParcelableResource resource = in.readTypedObject(ParcelableResource.CREATOR);
            return new DevicePolicyDrawableResource(drawableId, drawableStyle, drawableSource, resourceIdInCallingPackage, resource);
        }

        public DevicePolicyDrawableResource[] newArray(int size) {
            return new DevicePolicyDrawableResource[size];
        }
    };

    public DevicePolicyDrawableResource(Context context, String drawableId, String drawableStyle, String drawableSource, int resourceIdInCallingPackage) {
        this(drawableId, drawableStyle, drawableSource, resourceIdInCallingPackage, new ParcelableResource(context, resourceIdInCallingPackage, 1));
    }

    private DevicePolicyDrawableResource(String drawableId, String drawableStyle, String drawableSource, int resourceIdInCallingPackage, ParcelableResource resource) {
        Objects.requireNonNull(drawableId);
        Objects.requireNonNull(drawableStyle);
        Objects.requireNonNull(drawableSource);
        Objects.requireNonNull(resource);
        this.mDrawableId = drawableId;
        this.mDrawableStyle = drawableStyle;
        this.mDrawableSource = drawableSource;
        this.mResourceIdInCallingPackage = resourceIdInCallingPackage;
        this.mResource = resource;
    }

    public DevicePolicyDrawableResource(Context context, String drawableId, String drawableStyle, int resourceIdInCallingPackage) {
        this(context, drawableId, drawableStyle, "UNDEFINED", resourceIdInCallingPackage);
    }

    public String getDrawableId() {
        return this.mDrawableId;
    }

    public String getDrawableStyle() {
        return this.mDrawableStyle;
    }

    public String getDrawableSource() {
        return this.mDrawableSource;
    }

    public int getResourceIdInCallingPackage() {
        return this.mResourceIdInCallingPackage;
    }

    public ParcelableResource getResource() {
        return this.mResource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DevicePolicyDrawableResource other = (DevicePolicyDrawableResource)o;
        return this.mDrawableId.equals(other.mDrawableId) && this.mDrawableStyle.equals(other.mDrawableStyle) && this.mDrawableSource.equals(other.mDrawableSource) && this.mResourceIdInCallingPackage == other.mResourceIdInCallingPackage && this.mResource.equals(other.mResource);
    }

    public int hashCode() {
        return Objects.hash(this.mDrawableId, this.mDrawableStyle, this.mDrawableSource, this.mResourceIdInCallingPackage, this.mResource);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mDrawableId);
        dest.writeString(this.mDrawableStyle);
        dest.writeString(this.mDrawableSource);
        dest.writeInt(this.mResourceIdInCallingPackage);
        dest.writeTypedObject(this.mResource, flags);
    }
}

