/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ApplicationPackageManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.pm.ApplicationInfo;
import android.content.res.ApkAssets;
import android.content.res.AssetManager;
import android.content.res.CompatResources;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.ResourcesImpl;
import android.content.res.ResourcesKey;
import android.content.res.loader.ResourcesLoader;
import android.hardware.display.DisplayManagerGlobal;
import android.os.IBinder;
import android.os.Process;
import android.os.Trace;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import android.view.Display;
import android.view.DisplayAdjustments;
import android.view.DisplayInfo;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.tools.layoutlib.java.Reference_Delegate;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Function;

public class ResourcesManager {
    static final String TAG = "ResourcesManager";
    private static final boolean DEBUG = false;
    private static ResourcesManager sResourcesManager;
    private final Object mLock = new Object();
    private CompatibilityInfo mResCompatibilityInfo;
    @UnsupportedAppUsage
    private final Configuration mResConfiguration = new Configuration();
    private int mResDisplayId = 0;
    private ArrayList<Pair<String[], ApplicationInfo>> mPendingAppInfoUpdates;
    @UnsupportedAppUsage
    private final ArrayMap<ResourcesKey, WeakReference<ResourcesImpl>> mResourceImpls = new ArrayMap();
    @UnsupportedAppUsage
    private final ArrayList<WeakReference<Resources>> mResourceReferences = new ArrayList();
    private final ReferenceQueue<Resources> mResourcesReferencesQueue = new ReferenceQueue();
    private final ArrayMap<ApkKey, WeakReference<ApkAssets>> mCachedApkAssets = new ArrayMap();
    @UnsupportedAppUsage
    private final WeakHashMap<IBinder, ActivityResources> mActivityResourceReferences = new WeakHashMap();
    private final UpdateHandler mUpdateCallbacks = new UpdateHandler();
    private final ArraySet<String> mApplicationOwnedApks = new ArraySet();

    @UnsupportedAppUsage
    public ResourcesManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static ResourcesManager getInstance() {
        Class<ResourcesManager> clazz = ResourcesManager.class;
        synchronized (ResourcesManager.class) {
            if (sResourcesManager == null) {
                sResourcesManager = new ResourcesManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sResourcesManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidatePath(String path) {
        Object object = this.mLock;
        synchronized (object) {
            Object key;
            int i;
            int count = 0;
            for (i = this.mResourceImpls.size() - 1; i >= 0; --i) {
                key = this.mResourceImpls.keyAt(i);
                if (!((ResourcesKey)key).isPathReferenced(path)) continue;
                ResourcesImpl impl = (ResourcesImpl)this.mResourceImpls.removeAt(i).get();
                if (impl != null) {
                    impl.flushLayoutCache();
                }
                ++count;
            }
            Log.i(TAG, "Invalidated " + count + " asset managers that referenced " + path);
            for (i = this.mCachedApkAssets.size() - 1; i >= 0; --i) {
                WeakReference<ApkAssets> apkAssetsRef;
                key = this.mCachedApkAssets.keyAt(i);
                if (!((ApkKey)key).path.equals(path) || (apkAssetsRef = this.mCachedApkAssets.removeAt(i)) == null || apkAssetsRef.get() == null) continue;
                ((ApkAssets)apkAssetsRef.get()).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getConfiguration() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mResConfiguration;
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public DisplayMetrics getDisplayMetrics() {
        return this.getDisplayMetrics(this.mResDisplayId, DisplayAdjustments.DEFAULT_DISPLAY_ADJUSTMENTS);
    }

    @VisibleForTesting
    protected DisplayMetrics getDisplayMetrics(int displayId, DisplayAdjustments da) {
        DisplayInfo displayInfo;
        DisplayManagerGlobal displayManagerGlobal = DisplayManagerGlobal.getInstance();
        DisplayMetrics dm = new DisplayMetrics();
        DisplayInfo displayInfo2 = displayInfo = displayManagerGlobal != null ? displayManagerGlobal.getDisplayInfo(displayId) : null;
        if (displayInfo != null) {
            displayInfo.getAppMetrics(dm, da);
        } else {
            dm.setToDefaults();
        }
        return dm;
    }

    private DisplayMetrics getDisplayMetrics(Configuration config) {
        DisplayInfo displayInfo;
        DisplayManagerGlobal displayManagerGlobal = DisplayManagerGlobal.getInstance();
        DisplayMetrics dm = new DisplayMetrics();
        DisplayInfo displayInfo2 = displayInfo = displayManagerGlobal != null ? displayManagerGlobal.getDisplayInfo(this.mResDisplayId) : null;
        if (displayInfo != null) {
            displayInfo.getAppMetrics(dm, DisplayAdjustments.DEFAULT_DISPLAY_ADJUSTMENTS.getCompatibilityInfo(), config);
        } else {
            dm.setToDefaults();
        }
        return dm;
    }

    private static void applyDisplayMetricsToConfiguration(DisplayMetrics dm, Configuration config) {
        config.touchscreen = 1;
        config.densityDpi = dm.densityDpi;
        config.screenWidthDp = (int)((float)dm.widthPixels / dm.density);
        config.screenHeightDp = (int)((float)dm.heightPixels / dm.density);
        int sl = Configuration.resetScreenLayout(config.screenLayout);
        if (dm.widthPixels > dm.heightPixels) {
            config.orientation = 2;
            config.screenLayout = Configuration.reduceScreenLayout(sl, config.screenWidthDp, config.screenHeightDp);
        } else {
            config.orientation = 1;
            config.screenLayout = Configuration.reduceScreenLayout(sl, config.screenHeightDp, config.screenWidthDp);
        }
        config.smallestScreenWidthDp = Math.min(config.screenWidthDp, config.screenHeightDp);
        config.compatScreenWidthDp = config.screenWidthDp;
        config.compatScreenHeightDp = config.screenHeightDp;
        config.compatSmallestScreenWidthDp = config.smallestScreenWidthDp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyCompatConfiguration(int displayDensity, Configuration compatConfiguration) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mResCompatibilityInfo != null && !this.mResCompatibilityInfo.supportsScreen()) {
                this.mResCompatibilityInfo.applyToConfiguration(displayDensity, compatConfiguration);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Display getAdjustedDisplay(int displayId, Resources resources) {
        Object object = this.mLock;
        synchronized (object) {
            DisplayManagerGlobal dm = DisplayManagerGlobal.getInstance();
            if (dm == null) {
                return null;
            }
            return dm.getCompatibleDisplay(displayId, resources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeApplicationPaths(String sourceDir, String[] splitDirs) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mApplicationOwnedApks.isEmpty()) {
                this.addApplicationPathsLocked(sourceDir, splitDirs);
            }
        }
    }

    private void addApplicationPathsLocked(String sourceDir, String[] splitDirs) {
        this.mApplicationOwnedApks.add(sourceDir);
        if (splitDirs != null) {
            this.mApplicationOwnedApks.addAll(Arrays.asList(splitDirs));
        }
    }

    private static String overlayPathToIdmapPath(String path) {
        return "/data/resource-cache/" + path.substring(1).replace('/', '@') + "@idmap";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApkAssets loadApkAssets(ApkKey key) throws IOException {
        ApkAssets apkAssets;
        Object object = this.mLock;
        synchronized (object) {
            WeakReference<ApkAssets> apkAssetsRef = this.mCachedApkAssets.get(key);
            if (apkAssetsRef != null) {
                apkAssets = (ApkAssets)apkAssetsRef.get();
                if (apkAssets != null && apkAssets.isUpToDate()) {
                    return apkAssets;
                }
                this.mCachedApkAssets.remove(key);
            }
        }
        int flags = 0;
        if (key.sharedLib) {
            flags |= 2;
        }
        if (this.mApplicationOwnedApks.contains(key.path)) {
            flags |= 0x10;
        }
        apkAssets = key.overlay ? ApkAssets.loadOverlayFromPath(ResourcesManager.overlayPathToIdmapPath(key.path), flags) : ApkAssets.loadFromPath(key.path, flags);
        Object object2 = this.mLock;
        synchronized (object2) {
            this.mCachedApkAssets.put(key, new WeakReference<ApkAssets>(apkAssets));
        }
        return apkAssets;
    }

    private static ArrayList<ApkKey> extractApkKeys(ResourcesKey key) {
        ArrayList<ApkKey> apkKeys = new ArrayList<ApkKey>();
        if (key.mResDir != null) {
            apkKeys.add(new ApkKey(key.mResDir, false, false));
        }
        if (key.mSplitResDirs != null) {
            for (String splitResDir : key.mSplitResDirs) {
                apkKeys.add(new ApkKey(splitResDir, false, false));
            }
        }
        if (key.mLibDirs != null) {
            for (String libDir : key.mLibDirs) {
                if (!libDir.endsWith(".apk")) continue;
                apkKeys.add(new ApkKey(libDir, true, false));
            }
        }
        if (key.mOverlayPaths != null) {
            for (String idmapPath : key.mOverlayPaths) {
                apkKeys.add(new ApkKey(idmapPath, false, true));
            }
        }
        return apkKeys;
    }

    @VisibleForTesting
    @UnsupportedAppUsage
    protected AssetManager createAssetManager(ResourcesKey key) {
        return this.createAssetManager(key, null);
    }

    private AssetManager createAssetManager(ResourcesKey key, ApkAssetsSupplier apkSupplier) {
        AssetManager.Builder builder = new AssetManager.Builder();
        ArrayList<ApkKey> apkKeys = ResourcesManager.extractApkKeys(key);
        int n = apkKeys.size();
        for (int i = 0; i < n; ++i) {
            ApkKey apkKey = apkKeys.get(i);
            try {
                builder.addApkAssets(apkSupplier != null ? apkSupplier.load(apkKey) : this.loadApkAssets(apkKey));
                continue;
            }
            catch (IOException e) {
                if (apkKey.overlay) {
                    Log.w(TAG, String.format("failed to add overlay path '%s'", apkKey.path), e);
                    continue;
                }
                if (apkKey.sharedLib) {
                    Log.w(TAG, String.format("asset path '%s' does not exist or contains no resources", apkKey.path), e);
                    continue;
                }
                Log.e(TAG, String.format("failed to add asset path '%s'", apkKey.path), e);
                return null;
            }
        }
        if (key.mLoaders != null) {
            for (ResourcesLoader loader : key.mLoaders) {
                builder.addLoader(loader);
            }
        }
        return builder.build();
    }

    private static <T> int countLiveReferences(Collection<WeakReference<T>> collection) {
        int count = 0;
        for (WeakReference<T> ref : collection) {
            Object value = ref != null ? ref.get() : null;
            if (value == null) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(String prefix, PrintWriter printWriter) {
        Object object = this.mLock;
        synchronized (object) {
            IndentingPrintWriter pw = new IndentingPrintWriter((Writer)printWriter, "  ");
            for (int i = 0; i < prefix.length() / 2; ++i) {
                pw.increaseIndent();
            }
            pw.println("ResourcesManager:");
            pw.increaseIndent();
            pw.print("total apks: ");
            pw.println(ResourcesManager.countLiveReferences(this.mCachedApkAssets.values()));
            pw.print("resources: ");
            int references = ResourcesManager.countLiveReferences(this.mResourceReferences);
            for (ActivityResources activityResources : this.mActivityResourceReferences.values()) {
                references += activityResources.countLiveReferences();
            }
            pw.println(references);
            pw.print("resource impls: ");
            pw.println(ResourcesManager.countLiveReferences(this.mResourceImpls.values()));
        }
    }

    private Configuration generateConfig(ResourcesKey key) {
        Configuration config;
        boolean hasOverrideConfig = key.hasOverrideConfiguration();
        if (hasOverrideConfig) {
            config = new Configuration(this.getConfiguration());
            config.updateFrom(key.mOverrideConfiguration);
        } else {
            config = this.getConfiguration();
        }
        return config;
    }

    private int generateDisplayId(ResourcesKey key) {
        return key.mDisplayId != -1 ? key.mDisplayId : this.mResDisplayId;
    }

    private ResourcesImpl createResourcesImpl(ResourcesKey key, ApkAssetsSupplier apkSupplier) {
        AssetManager assets = this.createAssetManager(key, apkSupplier);
        if (assets == null) {
            return null;
        }
        DisplayAdjustments daj = new DisplayAdjustments(key.mOverrideConfiguration);
        daj.setCompatibilityInfo(key.mCompatInfo);
        Configuration config = this.generateConfig(key);
        DisplayMetrics displayMetrics = this.getDisplayMetrics(this.generateDisplayId(key), daj);
        ResourcesImpl impl = new ResourcesImpl(assets, displayMetrics, config, daj);
        return impl;
    }

    private ResourcesImpl findResourcesImplForKeyLocked(ResourcesKey key) {
        ResourcesImpl impl;
        WeakReference<ResourcesImpl> weakImplRef = this.mResourceImpls.get(key);
        ResourcesImpl resourcesImpl = impl = weakImplRef != null ? (ResourcesImpl)weakImplRef.get() : null;
        if (impl != null && impl.getAssets().isUpToDate()) {
            return impl;
        }
        return null;
    }

    private ResourcesImpl findOrCreateResourcesImplForKeyLocked(ResourcesKey key) {
        return this.findOrCreateResourcesImplForKeyLocked(key, null);
    }

    private ResourcesImpl findOrCreateResourcesImplForKeyLocked(ResourcesKey key, ApkAssetsSupplier apkSupplier) {
        ResourcesImpl impl = this.findResourcesImplForKeyLocked(key);
        if (impl == null && (impl = this.createResourcesImpl(key, apkSupplier)) != null) {
            this.mResourceImpls.put(key, new WeakReference<ResourcesImpl>(impl));
        }
        return impl;
    }

    private ResourcesKey findKeyForResourceImplLocked(ResourcesImpl resourceImpl) {
        int refCount = this.mResourceImpls.size();
        for (int i = 0; i < refCount; ++i) {
            WeakReference<ResourcesImpl> weakImplRef = this.mResourceImpls.valueAt(i);
            if (weakImplRef == null || !Reference_Delegate.refersTo(weakImplRef, resourceImpl)) continue;
            return this.mResourceImpls.keyAt(i);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSameResourcesOverrideConfig(IBinder activityToken, Configuration overrideConfig) {
        Object object = this.mLock;
        synchronized (object) {
            ActivityResources activityResources;
            ActivityResources activityResources2 = activityResources = activityToken != null ? this.mActivityResourceReferences.get(activityToken) : null;
            if (activityResources == null) {
                return overrideConfig == null;
            }
            return Objects.equals(activityResources.overrideConfig, overrideConfig) || overrideConfig != null && activityResources.overrideConfig != null && 0 == overrideConfig.diffPublicOnly(activityResources.overrideConfig);
        }
    }

    private ActivityResources getOrCreateActivityResourcesStructLocked(IBinder activityToken) {
        ActivityResources activityResources = this.mActivityResourceReferences.get(activityToken);
        if (activityResources == null) {
            activityResources = new ActivityResources();
            this.mActivityResourceReferences.put(activityToken, activityResources);
        }
        return activityResources;
    }

    private Resources findResourcesForActivityLocked(IBinder targetActivityToken, ResourcesKey targetKey, ClassLoader targetClassLoader) {
        ActivityResources activityResources = this.getOrCreateActivityResourcesStructLocked(targetActivityToken);
        int size = activityResources.activityResources.size();
        for (int index = 0; index < size; ++index) {
            ResourcesKey key;
            ActivityResource activityResource = activityResources.activityResources.get(index);
            Resources resources = (Resources)activityResource.resources.get();
            ResourcesKey resourcesKey = key = resources == null ? null : this.findKeyForResourceImplLocked(resources.getImpl());
            if (key == null || !Objects.equals(resources.getClassLoader(), targetClassLoader) || !Objects.equals(key, targetKey)) continue;
            return resources;
        }
        return null;
    }

    private Resources createResourcesForActivityLocked(IBinder activityToken, Configuration initialOverrideConfig, Integer overrideDisplayId, ClassLoader classLoader, ResourcesImpl impl, CompatibilityInfo compatInfo) {
        ActivityResources activityResources = this.getOrCreateActivityResourcesStructLocked(activityToken);
        ResourcesManager.cleanupReferences(activityResources.activityResources, activityResources.activityResourcesQueue, r -> r.resources);
        Resources resources = compatInfo.needsCompatResources() ? new CompatResources(classLoader) : new Resources(classLoader);
        resources.setImpl(impl);
        resources.setCallbacks(this.mUpdateCallbacks);
        ActivityResource activityResource = new ActivityResource();
        activityResource.resources = new WeakReference<Resources>(resources, activityResources.activityResourcesQueue);
        activityResource.overrideConfig.setTo(initialOverrideConfig);
        activityResource.overrideDisplayId = overrideDisplayId;
        activityResources.activityResources.add(activityResource);
        return resources;
    }

    private Resources createResourcesLocked(ClassLoader classLoader, ResourcesImpl impl, CompatibilityInfo compatInfo) {
        ResourcesManager.cleanupReferences(this.mResourceReferences, this.mResourcesReferencesQueue);
        Resources resources = compatInfo.needsCompatResources() ? new CompatResources(classLoader) : new Resources(classLoader);
        resources.setImpl(impl);
        resources.setCallbacks(this.mUpdateCallbacks);
        this.mResourceReferences.add(new WeakReference<Resources>(resources, this.mResourcesReferencesQueue));
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Resources createBaseTokenResources(IBinder token, String resDir, String[] splitResDirs, String[] legacyOverlayDirs, String[] overlayPaths, String[] libDirs, int displayId, Configuration overrideConfig, CompatibilityInfo compatInfo, ClassLoader classLoader, List<ResourcesLoader> loaders) {
        try {
            Trace.traceBegin(8192L, "ResourcesManager#createBaseActivityResources");
            ResourcesKey key = new ResourcesKey(resDir, splitResDirs, ResourcesManager.combinedOverlayPaths(legacyOverlayDirs, overlayPaths), libDirs, displayId, overrideConfig, compatInfo, loaders == null ? null : loaders.toArray(new ResourcesLoader[0]));
            classLoader = classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
            Object object = this.mLock;
            synchronized (object) {
                this.getOrCreateActivityResourcesStructLocked(token);
            }
            this.updateResourcesForActivity(token, overrideConfig, displayId);
            object = this.mLock;
            synchronized (object) {
                Resources resources = this.findResourcesForActivityLocked(token, key, classLoader);
                if (resources != null) {
                    Resources resources2 = resources;
                    return resources2;
                }
            }
            object = this.createResourcesForActivity(token, key, Configuration.EMPTY, null, classLoader, null);
            return object;
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebaseKeyForActivity(IBinder activityToken, ResourcesKey key, boolean overridesActivityDisplay) {
        Object object = this.mLock;
        synchronized (object) {
            Configuration config;
            ActivityResources activityResources = this.getOrCreateActivityResourcesStructLocked(activityToken);
            if (key.mDisplayId == -1) {
                key.mDisplayId = activityResources.overrideDisplayId;
            }
            if (key.hasOverrideConfiguration()) {
                config = new Configuration(activityResources.overrideConfig);
                config.updateFrom(key.mOverrideConfiguration);
            } else {
                config = activityResources.overrideConfig;
            }
            if (overridesActivityDisplay && key.mOverrideConfiguration.windowConfiguration.getAppBounds() == null) {
                if (!key.hasOverrideConfiguration()) {
                    config = new Configuration(config);
                }
                config.windowConfiguration.setAppBounds(null);
            }
            key.mOverrideConfiguration.setTo(config);
        }
    }

    private void rebaseKeyForDisplay(ResourcesKey key, int overrideDisplay) {
        Configuration temp = new Configuration();
        DisplayAdjustments daj = new DisplayAdjustments(key.mOverrideConfiguration);
        daj.setCompatibilityInfo(key.mCompatInfo);
        DisplayMetrics dm = this.getDisplayMetrics(overrideDisplay, daj);
        ResourcesManager.applyDisplayMetricsToConfiguration(dm, temp);
        if (key.hasOverrideConfiguration()) {
            temp.updateFrom(key.mOverrideConfiguration);
        }
        key.mOverrideConfiguration.setTo(temp);
    }

    private static <T> void cleanupReferences(ArrayList<WeakReference<T>> references, ReferenceQueue<T> referenceQueue) {
        ResourcesManager.cleanupReferences(references, referenceQueue, Function.identity());
    }

    private static <C, T> void cleanupReferences(ArrayList<C> referenceContainers, ReferenceQueue<T> referenceQueue, Function<C, WeakReference<T>> unwrappingFunction) {
        Reference<T> enqueuedRef = referenceQueue.poll();
        if (enqueuedRef == null) {
            return;
        }
        HashSet deadReferences = new HashSet();
        while (enqueuedRef != null) {
            deadReferences.add(enqueuedRef);
            enqueuedRef = referenceQueue.poll();
        }
        ArrayUtils.unstableRemoveIf(referenceContainers, refContainer -> {
            WeakReference ref = (WeakReference)unwrappingFunction.apply(refContainer);
            return ref == null || deadReferences.contains(ref);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApkAssetsSupplier createApkAssetsSupplierNotLocked(ResourcesKey key) {
        Trace.traceBegin(8192L, "ResourcesManager#createApkAssetsSupplierNotLocked");
        try {
            ApkAssetsSupplier supplier = new ApkAssetsSupplier();
            ArrayList<ApkKey> apkKeys = ResourcesManager.extractApkKeys(key);
            int n = apkKeys.size();
            for (int i = 0; i < n; ++i) {
                ApkKey apkKey = apkKeys.get(i);
                try {
                    supplier.load(apkKey);
                    continue;
                }
                catch (IOException e) {
                    Log.w(TAG, String.format("failed to preload asset path '%s'", apkKey.path), e);
                }
            }
            ApkAssetsSupplier apkAssetsSupplier = supplier;
            return apkAssetsSupplier;
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resources createResources(ResourcesKey key, ClassLoader classLoader, ApkAssetsSupplier apkSupplier) {
        Object object = this.mLock;
        synchronized (object) {
            ResourcesImpl resourcesImpl = this.findOrCreateResourcesImplForKeyLocked(key, apkSupplier);
            if (resourcesImpl == null) {
                return null;
            }
            return this.createResourcesLocked(classLoader, resourcesImpl, key.mCompatInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resources createResourcesForActivity(IBinder activityToken, ResourcesKey key, Configuration initialOverrideConfig, Integer overrideDisplayId, ClassLoader classLoader, ApkAssetsSupplier apkSupplier) {
        Object object = this.mLock;
        synchronized (object) {
            ResourcesImpl resourcesImpl = this.findOrCreateResourcesImplForKeyLocked(key, apkSupplier);
            if (resourcesImpl == null) {
                return null;
            }
            return this.createResourcesForActivityLocked(activityToken, initialOverrideConfig, overrideDisplayId, classLoader, resourcesImpl, key.mCompatInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resources getResources(IBinder activityToken, String resDir, String[] splitResDirs, String[] legacyOverlayDirs, String[] overlayPaths, String[] libDirs, Integer overrideDisplayId, Configuration overrideConfig, CompatibilityInfo compatInfo, ClassLoader classLoader, List<ResourcesLoader> loaders) {
        try {
            Resources resources;
            Trace.traceBegin(8192L, "ResourcesManager#getResources");
            ResourcesKey key = new ResourcesKey(resDir, splitResDirs, ResourcesManager.combinedOverlayPaths(legacyOverlayDirs, overlayPaths), libDirs, overrideDisplayId != null ? overrideDisplayId : -1, overrideConfig, compatInfo, loaders == null ? null : loaders.toArray(new ResourcesLoader[0]));
            classLoader = classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
            ApkAssetsSupplier assetsSupplier = this.createApkAssetsSupplierNotLocked(key);
            if (overrideDisplayId != null) {
                this.rebaseKeyForDisplay(key, overrideDisplayId);
            }
            if (activityToken != null) {
                Configuration initialOverrideConfig = new Configuration(key.mOverrideConfiguration);
                this.rebaseKeyForActivity(activityToken, key, overrideDisplayId != null);
                resources = this.createResourcesForActivity(activityToken, key, initialOverrideConfig, overrideDisplayId, classLoader, assetsSupplier);
            } else {
                resources = this.createResources(key, classLoader, assetsSupplier);
            }
            Resources resources2 = resources;
            return resources2;
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateResourcesForActivity(IBinder activityToken, Configuration overrideConfig, int displayId) {
        try {
            Trace.traceBegin(8192L, "ResourcesManager#updateResourcesForActivity");
            if (displayId == -1) {
                throw new IllegalArgumentException("displayId can not be INVALID_DISPLAY");
            }
            Object object = this.mLock;
            synchronized (object) {
                ActivityResources activityResources;
                block12: {
                    boolean movedToDifferentDisplay;
                    activityResources = this.getOrCreateActivityResourcesStructLocked(activityToken);
                    boolean bl = movedToDifferentDisplay = activityResources.overrideDisplayId != displayId;
                    if (!Objects.equals(activityResources.overrideConfig, overrideConfig) || movedToDifferentDisplay) break block12;
                    return;
                }
                Configuration oldConfig = new Configuration(activityResources.overrideConfig);
                if (overrideConfig != null) {
                    activityResources.overrideConfig.setTo(overrideConfig);
                } else {
                    activityResources.overrideConfig.unset();
                }
                activityResources.overrideDisplayId = displayId;
                this.applyAllPendingAppInfoUpdates();
                int refCount = activityResources.activityResources.size();
                for (int i = 0; i < refCount; ++i) {
                    ResourcesImpl resourcesImpl;
                    ResourcesKey newKey;
                    ActivityResource activityResource = activityResources.activityResources.get(i);
                    Resources resources = (Resources)activityResource.resources.get();
                    if (resources == null || (newKey = this.rebaseActivityOverrideConfig(activityResource, overrideConfig, displayId)) == null || (resourcesImpl = this.findOrCreateResourcesImplForKeyLocked(newKey)) == null || resourcesImpl == resources.getImpl()) continue;
                    resources.setImpl(resourcesImpl);
                }
            }
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    private ResourcesKey rebaseActivityOverrideConfig(ActivityResource activityResource, Configuration newOverrideConfig, int displayId) {
        boolean hasOverrideConfig;
        Integer overrideDisplayId;
        Resources resources = (Resources)activityResource.resources.get();
        if (resources == null) {
            return null;
        }
        ResourcesKey oldKey = this.findKeyForResourceImplLocked(resources.getImpl());
        if (oldKey == null) {
            Slog.e(TAG, "can't find ResourcesKey for resources impl=" + resources.getImpl());
            return null;
        }
        Configuration rebasedOverrideConfig = new Configuration();
        if (newOverrideConfig != null) {
            rebasedOverrideConfig.setTo(newOverrideConfig);
        }
        if ((overrideDisplayId = activityResource.overrideDisplayId) != null) {
            DisplayAdjustments displayAdjustments = new DisplayAdjustments(rebasedOverrideConfig);
            displayAdjustments.getConfiguration().setTo(activityResource.overrideConfig);
            displayAdjustments.setCompatibilityInfo(oldKey.mCompatInfo);
            DisplayMetrics dm = this.getDisplayMetrics(overrideDisplayId, displayAdjustments);
            ResourcesManager.applyDisplayMetricsToConfiguration(dm, rebasedOverrideConfig);
        }
        boolean bl = hasOverrideConfig = !activityResource.overrideConfig.equals(Configuration.EMPTY);
        if (hasOverrideConfig) {
            rebasedOverrideConfig.updateFrom(activityResource.overrideConfig);
        }
        if (activityResource.overrideDisplayId != null && activityResource.overrideConfig.windowConfiguration.getAppBounds() == null) {
            rebasedOverrideConfig.windowConfiguration.setAppBounds(null);
        }
        displayId = overrideDisplayId != null ? overrideDisplayId : displayId;
        ResourcesKey newKey = new ResourcesKey(oldKey.mResDir, oldKey.mSplitResDirs, oldKey.mOverlayPaths, oldKey.mLibDirs, displayId, rebasedOverrideConfig, oldKey.mCompatInfo, oldKey.mLoaders);
        return newKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendPendingAppInfoUpdate(String[] oldSourceDirs, ApplicationInfo appInfo) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPendingAppInfoUpdates == null) {
                this.mPendingAppInfoUpdates = new ArrayList();
            }
            for (int i = this.mPendingAppInfoUpdates.size() - 1; i >= 0; --i) {
                if (!ArrayUtils.containsAll(oldSourceDirs, (String[])this.mPendingAppInfoUpdates.get((int)i).first)) continue;
                this.mPendingAppInfoUpdates.remove(i);
            }
            this.mPendingAppInfoUpdates.add(new Pair<String[], ApplicationInfo>(oldSourceDirs, appInfo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyAllPendingAppInfoUpdates() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPendingAppInfoUpdates != null) {
                int n = this.mPendingAppInfoUpdates.size();
                for (int i = 0; i < n; ++i) {
                    Pair<String[], ApplicationInfo> appInfo = this.mPendingAppInfoUpdates.get(i);
                    this.applyNewResourceDirsLocked((String[])appInfo.first, (ApplicationInfo)appInfo.second);
                }
                this.mPendingAppInfoUpdates = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean applyConfigurationToResources(Configuration config, CompatibilityInfo compat) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                Trace.traceBegin(8192L, "ResourcesManager#applyConfigurationToResources");
                if (!this.mResConfiguration.isOtherSeqNewer(config) && compat == null) {
                    boolean bl = false;
                    return bl;
                }
                int changes = this.mResConfiguration.updateFrom(config);
                if (!(compat == null || this.mResCompatibilityInfo != null && this.mResCompatibilityInfo.equals(compat))) {
                    this.mResCompatibilityInfo = compat;
                    changes |= 0xD00;
                }
                if ((changes & Integer.MIN_VALUE) != 0) {
                    this.applyAllPendingAppInfoUpdates();
                }
                DisplayMetrics displayMetrics = this.getDisplayMetrics(config);
                Resources.updateSystemConfiguration(config, displayMetrics, compat);
                ApplicationPackageManager.configurationChanged();
                Configuration tmpConfig = new Configuration();
                for (int i = this.mResourceImpls.size() - 1; i >= 0; --i) {
                    ResourcesImpl r;
                    ResourcesKey key = this.mResourceImpls.keyAt(i);
                    WeakReference<ResourcesImpl> weakImplRef = this.mResourceImpls.valueAt(i);
                    ResourcesImpl resourcesImpl = r = weakImplRef != null ? (ResourcesImpl)weakImplRef.get() : null;
                    if (r != null) {
                        this.applyConfigurationToResourcesLocked(config, compat, tmpConfig, key, r);
                        continue;
                    }
                    this.mResourceImpls.removeAt(i);
                }
                boolean bl = changes != 0;
                return bl;
            }
            finally {
                Trace.traceEnd(8192L);
            }
        }
    }

    private void applyConfigurationToResourcesLocked(Configuration config, CompatibilityInfo compat, Configuration tmpConfig, ResourcesKey key, ResourcesImpl resourcesImpl) {
        tmpConfig.setTo(config);
        if (key.hasOverrideConfiguration()) {
            tmpConfig.updateFrom(key.mOverrideConfiguration);
        }
        DisplayAdjustments daj = resourcesImpl.getDisplayAdjustments();
        if (compat != null) {
            daj = new DisplayAdjustments(daj);
            daj.setCompatibilityInfo(compat);
        }
        daj.setConfiguration(tmpConfig);
        DisplayMetrics dm = this.getDisplayMetrics(this.generateDisplayId(key), daj);
        resourcesImpl.updateConfiguration(tmpConfig, dm, compat);
    }

    @UnsupportedAppUsage
    public void appendLibAssetForMainAssetPath(String assetPath, String libAsset) {
        this.appendLibAssetsForMainAssetPath(assetPath, new String[]{libAsset});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendLibAssetsForMainAssetPath(String assetPath, String[] libAssets) {
        Object object = this.mLock;
        synchronized (object) {
            ArrayMap<ResourcesImpl, ResourcesKey> updatedResourceKeys = new ArrayMap<ResourcesImpl, ResourcesKey>();
            int implCount = this.mResourceImpls.size();
            for (int i = 0; i < implCount; ++i) {
                ResourcesImpl impl;
                ResourcesKey key = this.mResourceImpls.keyAt(i);
                WeakReference<ResourcesImpl> weakImplRef = this.mResourceImpls.valueAt(i);
                ResourcesImpl resourcesImpl = impl = weakImplRef != null ? (ResourcesImpl)weakImplRef.get() : null;
                if (impl == null || !Objects.equals(key.mResDir, assetPath)) continue;
                Object[] newLibAssets = key.mLibDirs;
                for (String libAsset : libAssets) {
                    newLibAssets = ArrayUtils.appendElement(String.class, newLibAssets, libAsset);
                }
                if (Arrays.equals(newLibAssets, key.mLibDirs)) continue;
                updatedResourceKeys.put(impl, new ResourcesKey(key.mResDir, key.mSplitResDirs, key.mOverlayPaths, (String[])newLibAssets, key.mDisplayId, key.mOverrideConfiguration, key.mCompatInfo, key.mLoaders));
            }
            this.redirectResourcesToNewImplLocked(updatedResourceKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyNewResourceDirsLocked(String[] oldSourceDirs, ApplicationInfo appInfo) {
        try {
            Trace.traceBegin(8192L, "ResourcesManager#applyNewResourceDirsLocked");
            String baseCodePath = appInfo.getBaseCodePath();
            int myUid = Process.myUid();
            String[] newSplitDirs = appInfo.uid == myUid ? appInfo.splitSourceDirs : appInfo.splitPublicSourceDirs;
            String[] copiedSplitDirs = ArrayUtils.cloneOrNull(newSplitDirs);
            String[] copiedResourceDirs = ResourcesManager.combinedOverlayPaths(appInfo.resourceDirs, appInfo.overlayPaths);
            if (appInfo.uid == myUid) {
                this.addApplicationPathsLocked(baseCodePath, copiedSplitDirs);
            }
            ArrayMap<ResourcesImpl, ResourcesKey> updatedResourceKeys = new ArrayMap<ResourcesImpl, ResourcesKey>();
            int implCount = this.mResourceImpls.size();
            for (int i = 0; i < implCount; ++i) {
                ResourcesImpl impl;
                ResourcesKey key = this.mResourceImpls.keyAt(i);
                WeakReference<ResourcesImpl> weakImplRef = this.mResourceImpls.valueAt(i);
                ResourcesImpl resourcesImpl = impl = weakImplRef != null ? (ResourcesImpl)weakImplRef.get() : null;
                if (impl == null || key.mResDir != null && !key.mResDir.equals(baseCodePath) && !ArrayUtils.contains(oldSourceDirs, key.mResDir)) continue;
                updatedResourceKeys.put(impl, new ResourcesKey(baseCodePath, copiedSplitDirs, copiedResourceDirs, key.mLibDirs, key.mDisplayId, key.mOverrideConfiguration, key.mCompatInfo, key.mLoaders));
            }
            this.redirectResourcesToNewImplLocked(updatedResourceKeys);
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    private static String[] combinedOverlayPaths(String[] resourceDirs, String[] overlayPaths) {
        if (resourceDirs == null) {
            return ArrayUtils.cloneOrNull(overlayPaths);
        }
        if (overlayPaths == null) {
            return ArrayUtils.cloneOrNull(resourceDirs);
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (String path : overlayPaths) {
            paths.add(path);
        }
        for (String path : resourceDirs) {
            if (paths.contains(path)) continue;
            paths.add(path);
        }
        return paths.toArray(new String[0]);
    }

    private void redirectResourcesToNewImplLocked(ArrayMap<ResourcesImpl, ResourcesKey> updatedResourceKeys) {
        if (updatedResourceKeys.isEmpty()) {
            return;
        }
        int resourcesCount = this.mResourceReferences.size();
        for (int i = 0; i < resourcesCount; ++i) {
            ResourcesKey key;
            Resources r;
            WeakReference<Resources> ref = this.mResourceReferences.get(i);
            Resources resources = r = ref != null ? (Resources)ref.get() : null;
            if (r == null || (key = updatedResourceKeys.get(r.getImpl())) == null) continue;
            ResourcesImpl impl = this.findOrCreateResourcesImplForKeyLocked(key);
            if (impl == null) {
                throw new Resources.NotFoundException("failed to redirect ResourcesImpl");
            }
            r.setImpl(impl);
        }
        for (ActivityResources activityResources : this.mActivityResourceReferences.values()) {
            int resCount = activityResources.activityResources.size();
            for (int i = 0; i < resCount; ++i) {
                ResourcesKey key;
                Resources r;
                ActivityResource activityResource = activityResources.activityResources.get(i);
                Resources resources = r = activityResource != null ? (Resources)activityResource.resources.get() : null;
                if (r == null || (key = updatedResourceKeys.get(r.getImpl())) == null) continue;
                ResourcesImpl impl = this.findOrCreateResourcesImplForKeyLocked(key);
                if (impl == null) {
                    throw new Resources.NotFoundException("failed to redirect ResourcesImpl");
                }
                r.setImpl(impl);
            }
        }
    }

    private class UpdateHandler
    implements Resources.UpdateCallbacks {
        private UpdateHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLoadersChanged(Resources resources, List<ResourcesLoader> newLoader) {
            Object object = ResourcesManager.this.mLock;
            synchronized (object) {
                ResourcesKey oldKey = ResourcesManager.this.findKeyForResourceImplLocked(resources.getImpl());
                if (oldKey == null) {
                    throw new IllegalArgumentException("Cannot modify resource loaders of ResourcesImpl not registered with ResourcesManager");
                }
                ResourcesKey newKey = new ResourcesKey(oldKey.mResDir, oldKey.mSplitResDirs, oldKey.mOverlayPaths, oldKey.mLibDirs, oldKey.mDisplayId, oldKey.mOverrideConfiguration, oldKey.mCompatInfo, newLoader.toArray(new ResourcesLoader[0]));
                ResourcesImpl impl = ResourcesManager.this.findOrCreateResourcesImplForKeyLocked(newKey);
                resources.setImpl(impl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLoaderUpdated(ResourcesLoader loader) {
            Object object = ResourcesManager.this.mLock;
            synchronized (object) {
                ArrayMap<ResourcesImpl, ResourcesKey> updatedResourceImplKeys = new ArrayMap<ResourcesImpl, ResourcesKey>();
                for (int i = ResourcesManager.this.mResourceImpls.size() - 1; i >= 0; --i) {
                    ResourcesKey key = ResourcesManager.this.mResourceImpls.keyAt(i);
                    WeakReference<ResourcesImpl> impl = ResourcesManager.this.mResourceImpls.valueAt(i);
                    if (impl == null || Reference_Delegate.refersTo(impl, null) || !ArrayUtils.contains(key.mLoaders, loader)) continue;
                    ResourcesManager.this.mResourceImpls.remove(key);
                    updatedResourceImplKeys.put((ResourcesImpl)impl.get(), key);
                }
                ResourcesManager.this.redirectResourcesToNewImplLocked(updatedResourceImplKeys);
            }
        }
    }

    private static class ActivityResource {
        public final Configuration overrideConfig = new Configuration();
        public Integer overrideDisplayId;
        public WeakReference<Resources> resources;

        private ActivityResource() {
        }
    }

    private static class ActivityResources {
        public final Configuration overrideConfig = new Configuration();
        public int overrideDisplayId;
        public final ArrayList<ActivityResource> activityResources = new ArrayList();
        public final ReferenceQueue<Resources> activityResourcesQueue = new ReferenceQueue();

        @UnsupportedAppUsage
        private ActivityResources() {
        }

        public int countLiveReferences() {
            int count = 0;
            for (int i = 0; i < this.activityResources.size(); ++i) {
                WeakReference<Resources> resources = this.activityResources.get((int)i).resources;
                if (resources == null || resources.get() == null) continue;
                ++count;
            }
            return count;
        }
    }

    private class ApkAssetsSupplier {
        final ArrayMap<ApkKey, ApkAssets> mLocalCache = new ArrayMap();

        private ApkAssetsSupplier() {
        }

        ApkAssets load(ApkKey apkKey) throws IOException {
            ApkAssets apkAssets = this.mLocalCache.get(apkKey);
            if (apkAssets == null) {
                apkAssets = ResourcesManager.this.loadApkAssets(apkKey);
                this.mLocalCache.put(apkKey, apkAssets);
            }
            return apkAssets;
        }
    }

    private static class ApkKey {
        public final String path;
        public final boolean sharedLib;
        public final boolean overlay;

        ApkKey(String path, boolean sharedLib, boolean overlay) {
            this.path = path;
            this.sharedLib = sharedLib;
            this.overlay = overlay;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.path.hashCode();
            result = 31 * result + Boolean.hashCode(this.sharedLib);
            result = 31 * result + Boolean.hashCode(this.overlay);
            return result;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ApkKey)) {
                return false;
            }
            ApkKey other = (ApkKey)obj;
            return this.path.equals(other.path) && this.sharedLib == other.sharedLib && this.overlay == other.overlay;
        }
    }
}

