/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IForegroundServiceObserver
extends IInterface {
    public static final String DESCRIPTOR = "android.app.IForegroundServiceObserver";

    public void onForegroundStateChanged(IBinder var1, String var2, int var3, boolean var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IForegroundServiceObserver {
        static final int TRANSACTION_onForegroundStateChanged = 1;

        public Stub() {
            this.attachInterface(this, IForegroundServiceObserver.DESCRIPTOR);
        }

        public static IForegroundServiceObserver asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IForegroundServiceObserver.DESCRIPTOR);
            if (iin != null && iin instanceof IForegroundServiceObserver) {
                return (IForegroundServiceObserver)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onForegroundStateChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IForegroundServiceObserver.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onForegroundStateChanged(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IForegroundServiceObserver {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IForegroundServiceObserver.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onForegroundStateChanged(IBinder serviceToken, String packageName, int userId, boolean isForeground) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IForegroundServiceObserver.DESCRIPTOR);
                    _data.writeStrongBinder(serviceToken);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    _data.writeBoolean(isForeground);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IForegroundServiceObserver {
        @Override
        public void onForegroundStateChanged(IBinder serviceToken, String packageName, int userId, boolean isForeground) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

