/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Consumer;
import com.intellij.util.NullableConsumer;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.CharsKt;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownList;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.intellij.plugins.markdown.lang.psi.util.AstUtilsKt;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u00013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\rH\u0002J\u001b\u0010\u001d\u001a\u00020\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\u001fH\u0007\u00a2\u0006\u0002\u0010 J\u000e\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#J2\u0010$\u001a\u00020%2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\u000e\u0010&\u001a\n\u0012\u0006\b\u0000\u0012\u00020\r0'2\u000e\u0010(\u001a\n\u0012\u0006\b\u0000\u0012\u00020\r0)H\u0007JD\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020\r2\b\u0010,\u001a\u0004\u0018\u00010\r2\b\u0010-\u001a\u0004\u0018\u00010\r2\u000e\u0010.\u001a\n\u0012\u0006\b\u0000\u0012\u00020\r0'2\u000e\u0010(\u001a\n\u0012\u0006\b\u0000\u0012\u00020\r0)H\u0002J \u0010/\u001a\u00020%2\u0006\u0010-\u001a\u00020\r2\u000e\u0010.\u001a\n\u0012\u0006\b\u0000\u0012\u00020\r0'H\u0002J \u00100\u001a\u00020%2\u0006\u0010-\u001a\u00020\r2\u000e\u0010.\u001a\n\u0012\u0006\b\u0000\u0012\u00020\r0'H\u0002J\f\u00101\u001a\u00020\u001a*\u00020\rH\u0002J\f\u00102\u001a\u00020\u001a*\u00020\rH\u0002R&\u0010\u0003\u001a\u001a\u0012\u0016\u0012\u0014 \u0007*\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00060\u0005\u00a2\u0006\u0002\b\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000b\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/intellij/plugins/markdown/util/MarkdownPsiUtil;", "", "()V", "HEADER_ORDER", "", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm.PlatformType", "IGNORED_CONTAINERS", "PRESENTABLE_CONTAINERS", "PRESENTABLE_TYPES", "TRANSPARENT_CONTAINERS", "findFirstChild", "Lcom/intellij/psi/PsiElement;", "myElement", "findNonWhiteSpacePrevSibling", "file", "Lcom/intellij/psi/PsiFile;", "offset", "", "getParentOfType", "types", "headerLevel", "curLevelType", "Lcom/intellij/psi/tree/IElementType;", "isSameLevelOrHigher", "", "psiA", "psiB", "isSimpleNestedList", "itemChildren", "", "([Lcom/intellij/psi/PsiElement;)Z", "isTopLevel", "node", "Lcom/intellij/lang/ASTNode;", "processContainer", "", "consumer", "Lcom/intellij/util/Consumer;", "nextHeaderConsumer", "Lcom/intellij/util/NullableConsumer;", "processHeader", "container", "sameLevelRestriction", "from", "resultConsumer", "processList", "processListItem", "isTransparentInFull", "isTransparentInPartial", "WhiteSpaces", "intellij.markdown.core"})
public final class MarkdownPsiUtil {
    @JvmField
    @NotNull
    public static final TokenSet PRESENTABLE_TYPES;
    @JvmField
    @NotNull
    public static final TokenSet TRANSPARENT_CONTAINERS;
    private static final TokenSet PRESENTABLE_CONTAINERS;
    private static final TokenSet IGNORED_CONTAINERS;
    private static final List<TokenSet> HEADER_ORDER;
    @NotNull
    public static final MarkdownPsiUtil INSTANCE;

    public final boolean isTopLevel(@NotNull ASTNode node) {
        return AstUtilsKt.hasType(node.getTreeParent(), MarkdownTokenTypeSets.MARKDOWN_FILE);
    }

    @Nullable
    public final PsiElement findNonWhiteSpacePrevSibling(@NotNull PsiFile file, int offset) {
        int offset2 = offset;
        while (offset2 > 0) {
            PsiElement element2 = file.findElementAt(offset2);
            if (element2 == null) {
                --offset2;
                continue;
            }
            if (!MarkdownTokenTypeSets.WHITE_SPACES.contains(element2.getNode().getElementType())) {
                return element2;
            }
            int newOffset = element2.getTextOffset();
            if (newOffset < offset2) {
                offset2 = newOffset;
                continue;
            }
            --offset2;
        }
        return null;
    }

    @JvmStatic
    public static final boolean isSimpleNestedList(@NotNull PsiElement[] itemChildren) {
        return itemChildren.length == 2 && Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)itemChildren[0]), (Object)MarkdownElementTypes.PARAGRAPH) && itemChildren[1] instanceof MarkdownList;
    }

    @JvmStatic
    public static final void processContainer(@Nullable PsiElement myElement, @NotNull Consumer<? super PsiElement> consumer, @NotNull NullableConsumer<? super PsiElement> nextHeaderConsumer) {
        if (myElement == null) {
            return;
        }
        PsiElement psiElement = myElement instanceof MarkdownFile ? INSTANCE.findFirstChild(myElement) : INSTANCE.getParentOfType(myElement, TRANSPARENT_CONTAINERS);
        if (psiElement == null) {
            return;
        }
        PsiElement structureContainer = psiElement;
        boolean isListsVisible = Registry.is((String)"markdown.structure.view.list.visibility");
        if (myElement instanceof MarkdownHeader) {
            INSTANCE.processHeader(structureContainer, myElement, myElement, consumer, nextHeaderConsumer);
        } else if (myElement instanceof MarkdownList && isListsVisible) {
            INSTANCE.processList(myElement, consumer);
        } else if (myElement instanceof MarkdownListItem && isListsVisible) {
            if (!((MarkdownListItem)myElement).hasTrivialChildren()) {
                INSTANCE.processListItem(myElement, consumer);
            }
        } else {
            INSTANCE.processHeader(structureContainer, null, null, consumer, nextHeaderConsumer);
        }
    }

    private final PsiElement findFirstChild(PsiElement myElement) {
        Object v0;
        block1: {
            Sequence $this$firstOrNull$iv = ArraysKt.asSequence((Object[])myElement.getChildren());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getLanguage(), (Object)((Object)MarkdownLanguage.INSTANCE))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final void processHeader(PsiElement container, PsiElement sameLevelRestriction, PsiElement from, Consumer<? super PsiElement> resultConsumer, NullableConsumer<? super PsiElement> nextHeaderConsumer) {
        PsiElement nextSibling = from == null ? container.getFirstChild() : from.getNextSibling();
        PsiElement maxContentLevel = null;
        while (nextSibling != null) {
            if (this.isTransparentInPartial(nextSibling) && maxContentLevel == null) {
                this.processHeader(nextSibling, null, null, resultConsumer, nextHeaderConsumer);
            } else if (this.isTransparentInFull(nextSibling) && maxContentLevel == null) {
                if (!IGNORED_CONTAINERS.contains(PsiUtilCore.getElementType((PsiElement)container)) && PRESENTABLE_CONTAINERS.contains(PsiUtilCore.getElementType((PsiElement)nextSibling))) {
                    resultConsumer.consume((Object)nextSibling);
                }
                this.processHeader(nextSibling, null, null, resultConsumer, nextHeaderConsumer);
            } else if (nextSibling instanceof MarkdownHeader) {
                if (sameLevelRestriction != null && this.isSameLevelOrHigher(nextSibling, sameLevelRestriction)) {
                    nextHeaderConsumer.consume((Object)nextSibling);
                    break;
                }
                if (maxContentLevel == null || this.isSameLevelOrHigher(nextSibling, maxContentLevel)) {
                    maxContentLevel = nextSibling;
                    IElementType type = ((MarkdownHeader)nextSibling).getNode().getElementType();
                    if (PRESENTABLE_TYPES.contains(type)) {
                        resultConsumer.consume((Object)nextSibling);
                    }
                }
            }
            if ((nextSibling = nextSibling.getNextSibling()) != null) continue;
            nextHeaderConsumer.consume(null);
        }
    }

    private final void processList(PsiElement from, Consumer<? super PsiElement> resultConsumer) {
        for (PsiElement listItem = from.getFirstChild(); listItem != null; listItem = listItem.getNextSibling()) {
            PsiElement[] itemChildren = listItem.getChildren();
            PsiElement[] psiElementArray = itemChildren;
            boolean isContainerIsFirst = !(psiElementArray.length == 0) && PRESENTABLE_TYPES.contains(itemChildren[0].getNode().getElementType()) || itemChildren.length == 1 && PRESENTABLE_CONTAINERS.contains(PsiUtilCore.getElementType((PsiElement)itemChildren[0]));
            if (isContainerIsFirst) {
                resultConsumer.consume((Object)itemChildren[0]);
                continue;
            }
            if (MarkdownPsiUtil.isSimpleNestedList(itemChildren)) {
                resultConsumer.consume((Object)itemChildren[1]);
                continue;
            }
            if (!(listItem instanceof MarkdownListItem)) continue;
            resultConsumer.consume((Object)listItem);
        }
    }

    private final void processListItem(PsiElement from, Consumer<? super PsiElement> resultConsumer) {
        for (PsiElement itemChild = from.getFirstChild(); itemChild != null; itemChild = itemChild.getNextSibling()) {
            if (PRESENTABLE_TYPES.contains(itemChild.getNode().getElementType())) {
                resultConsumer.consume((Object)itemChild);
                break;
            }
            if (!PRESENTABLE_CONTAINERS.contains(PsiUtilCore.getElementType((PsiElement)itemChild))) continue;
            resultConsumer.consume((Object)itemChild);
        }
    }

    private final boolean isTransparentInFull(PsiElement $this$isTransparentInFull) {
        return Registry.is((String)"markdown.structure.view.list.visibility") && TRANSPARENT_CONTAINERS.contains(PsiUtilCore.getElementType((PsiElement)$this$isTransparentInFull)) && !($this$isTransparentInFull instanceof MarkdownListItem);
    }

    private final boolean isTransparentInPartial(PsiElement $this$isTransparentInPartial) {
        return !Registry.is((String)"markdown.structure.view.list.visibility") && TRANSPARENT_CONTAINERS.contains(PsiUtilCore.getElementType((PsiElement)$this$isTransparentInPartial));
    }

    private final boolean isSameLevelOrHigher(PsiElement psiA, PsiElement psiB) {
        IElementType typeA = psiA.getNode().getElementType();
        IElementType typeB = psiB.getNode().getElementType();
        return this.headerLevel(typeA) <= this.headerLevel(typeB);
    }

    /*
     * WARNING - void declaration
     */
    private final int headerLevel(IElementType curLevelType) {
        int n = 0;
        int n2 = ((Collection)HEADER_ORDER).size();
        while (n < n2) {
            void i;
            if (HEADER_ORDER.get((int)i).contains(curLevelType)) {
                return (int)i;
            }
            ++i;
        }
        return Integer.MAX_VALUE;
    }

    private final PsiElement getParentOfType(PsiElement myElement, TokenSet types) {
        ASTNode parentNode;
        ASTNode aSTNode = parentNode = TreeUtil.findParent((ASTNode)myElement.getNode(), (TokenSet)types);
        return aSTNode != null ? aSTNode.getPsi() : null;
    }

    private MarkdownPsiUtil() {
    }

    static {
        MarkdownPsiUtil markdownPsiUtil;
        INSTANCE = markdownPsiUtil = new MarkdownPsiUtil();
        PRESENTABLE_TYPES = MarkdownTokenTypeSets.HEADERS;
        TRANSPARENT_CONTAINERS = TokenSet.create((IElementType[])new IElementType[]{MarkdownElementTypes.MARKDOWN_FILE, MarkdownElementTypes.UNORDERED_LIST, MarkdownElementTypes.ORDERED_LIST, MarkdownElementTypes.LIST_ITEM, MarkdownElementTypes.BLOCK_QUOTE});
        PRESENTABLE_CONTAINERS = TokenSet.create((IElementType[])new IElementType[]{MarkdownElementTypes.UNORDERED_LIST, MarkdownElementTypes.ORDERED_LIST});
        IGNORED_CONTAINERS = TokenSet.create((IElementType[])new IElementType[]{MarkdownElementTypes.BLOCK_QUOTE});
        HEADER_ORDER = CollectionsKt.listOf((Object[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{(IElementType)MarkdownElementTypes.MARKDOWN_FILE_ELEMENT_TYPE}), MarkdownTokenTypeSets.HEADER_LEVEL_1_SET, MarkdownTokenTypeSets.HEADER_LEVEL_2_SET, MarkdownTokenTypeSets.HEADER_LEVEL_3_SET, MarkdownTokenTypeSets.HEADER_LEVEL_4_SET, MarkdownTokenTypeSets.HEADER_LEVEL_5_SET, MarkdownTokenTypeSets.HEADER_LEVEL_6_SET});
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Lorg/intellij/plugins/markdown/util/MarkdownPsiUtil$WhiteSpaces;", "", "()V", "isNewLine", "", "element", "Lcom/intellij/psi/PsiElement;", "isWhiteSpace", "intellij.markdown.core"})
    public static final class WhiteSpaces {
        @NotNull
        public static final WhiteSpaces INSTANCE;

        @JvmStatic
        public static final boolean isNewLine(@NotNull PsiElement element2) {
            return PsiUtilsKt.hasType(element2, MarkdownTokenTypeSets.WHITE_SPACES) && Intrinsics.areEqual((Object)element2.getText(), (Object)"\n");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public static final boolean isWhiteSpace(@NotNull PsiElement element2) {
            if (!PsiUtilsKt.hasType(element2, MarkdownTokenTypeSets.WHITE_SPACES)) return false;
            CharSequence $this$all$iv = element2.getText();
            boolean $i$f$all = false;
            int n = 0;
            while (n < $this$all$iv.length()) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(n);
                boolean bl = false;
                if (!CharsKt.isWhitespace((char)it)) return false;
                if (it == '\n') return false;
                boolean bl2 = true;
                if (!bl2) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        private WhiteSpaces() {
        }

        static {
            WhiteSpaces whiteSpaces;
            INSTANCE = whiteSpaces = new WhiteSpaces();
        }
    }
}

