/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0018\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u0004J\f\u0010\u000e\u001a\u0004\u0018\u00010\u0004*\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lorg/intellij/plugins/markdown/util/MarkdownFileUtil;", "", "()V", "getDirectory", "Ljava/io/File;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "getPathForHtmlImage", "", "path", "getPathForMarkdownImage", "currentDirectory", "getContainingDirectoryFile", "Lcom/intellij/psi/PsiElement;", "intellij.markdown.core"})
public final class MarkdownFileUtil {
    @NotNull
    public static final MarkdownFileUtil INSTANCE;

    @Nullable
    public final File getContainingDirectoryFile(@NotNull PsiElement $this$getContainingDirectoryFile) {
        PsiFile psiFile = $this$getContainingDirectoryFile.getContainingFile();
        VirtualFile file = psiFile != null && (psiFile = psiFile.getContainingDirectory()) != null ? psiFile.getVirtualFile() : null;
        Object object = file;
        return object != null && (object = object.getFileSystem()) != null && (object = object.getNioPath(file)) != null ? object.toFile() : null;
    }

    @Nullable
    public final File getDirectory(@Nullable Project project, @NotNull Document document) {
        Project project2 = project;
        if (project2 == null) {
            return null;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
        return psiFile != null ? this.getContainingDirectoryFile((PsiElement)psiFile) : null;
    }

    @NotNull
    public final String getPathForHtmlImage(@NotNull String path) {
        return ((Object)Path.of(path, new String[0]).toAbsolutePath().normalize()).toString();
    }

    @NotNull
    public final String getPathForMarkdownImage(@NotNull String path, @Nullable File currentDirectory) {
        String string = FileUtilRt.getRelativePath((File)currentDirectory, (File)new File(path));
        if (string == null) {
            string = path;
        }
        return FileUtil.toCanonicalPath((String)string);
    }

    private MarkdownFileUtil() {
    }

    static {
        MarkdownFileUtil markdownFileUtil;
        INSTANCE = markdownFileUtil = new MarkdownFileUtil();
    }
}

