/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.split;

import com.intellij.openapi.fileEditor.AsyncFileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.intellij.plugins.markdown.ui.split.SplitFileEditor;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SplitTextEditorProvider
implements AsyncFileEditorProvider,
DumbAware {
    protected static final String FIRST_EDITOR = "first_editor";
    protected static final String SECOND_EDITOR = "second_editor";
    protected static final String SPLIT_LAYOUT = "split_layout";
    @NotNull
    protected final FileEditorProvider myFirstProvider;
    @NotNull
    protected final FileEditorProvider mySecondProvider;
    @NotNull
    private final String myEditorTypeId;

    public SplitTextEditorProvider(@NotNull FileEditorProvider firstProvider, @NotNull FileEditorProvider secondProvider) {
        this.myFirstProvider = firstProvider;
        this.mySecondProvider = secondProvider;
        this.myEditorTypeId = "split-provider[" + this.myFirstProvider.getEditorTypeId() + ";" + this.mySecondProvider.getEditorTypeId() + "]";
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        return this.myFirstProvider.accept(project, file) && this.mySecondProvider.accept(project, file);
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        return this.createEditorAsync(project, file).build();
    }

    @NotNull
    public String getEditorTypeId() {
        return this.myEditorTypeId;
    }

    @NotNull
    public AsyncFileEditorProvider.Builder createEditorAsync(@NotNull Project project, @NotNull VirtualFile file) {
        final AsyncFileEditorProvider.Builder firstBuilder = SplitTextEditorProvider.getBuilderFromEditorProvider(this.myFirstProvider, project, file);
        final AsyncFileEditorProvider.Builder secondBuilder = SplitTextEditorProvider.getBuilderFromEditorProvider(this.mySecondProvider, project, file);
        return new AsyncFileEditorProvider.Builder(){

            public FileEditor build() {
                return SplitTextEditorProvider.this.createSplitEditor(firstBuilder.build(), secondBuilder.build());
            }
        };
    }

    @Nullable
    protected FileEditorState readFirstProviderState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        Element child = sourceElement.getChild(FIRST_EDITOR);
        if (child != null) {
            return this.myFirstProvider.readState(child, project, file);
        }
        return null;
    }

    @Nullable
    protected FileEditorState readSecondProviderState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        Element child = sourceElement.getChild(SECOND_EDITOR);
        if (child != null) {
            return this.mySecondProvider.readState(child, project, file);
        }
        return null;
    }

    @Nullable
    protected String readSplitLayoutState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        Attribute attribute = sourceElement.getAttribute(SPLIT_LAYOUT);
        String layoutName = null;
        if (attribute != null) {
            layoutName = attribute.getValue();
        }
        return layoutName;
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        FileEditorState firstState = this.readFirstProviderState(sourceElement, project, file);
        FileEditorState secondState = this.readSecondProviderState(sourceElement, project, file);
        String layoutName = this.readSplitLayoutState(sourceElement, project, file);
        return new SplitFileEditor.MyFileEditorState(layoutName, firstState, secondState);
    }

    protected void writeFirstProviderState(@Nullable FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
        Element child = new Element(FIRST_EDITOR);
        if (state != null) {
            this.myFirstProvider.writeState(state, project, child);
            targetElement.addContent(child);
        }
    }

    protected void writeSecondProviderState(@Nullable FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
        Element child = new Element(SECOND_EDITOR);
        if (state != null) {
            this.mySecondProvider.writeState(state, project, child);
            targetElement.addContent(child);
        }
    }

    protected void writeSplitLayoutState(@Nullable String splitLayout, @NotNull Project project, @NotNull Element targetElement) {
        if (splitLayout != null) {
            targetElement.setAttribute(SPLIT_LAYOUT, splitLayout);
        }
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
        if (!(state instanceof SplitFileEditor.MyFileEditorState)) {
            return;
        }
        SplitFileEditor.MyFileEditorState compositeState = (SplitFileEditor.MyFileEditorState)state;
        this.writeFirstProviderState(compositeState.getFirstState(), project, targetElement);
        this.writeSecondProviderState(compositeState.getSecondState(), project, targetElement);
        this.writeSplitLayoutState(compositeState.getSplitLayout(), project, targetElement);
    }

    protected abstract FileEditor createSplitEditor(@NotNull FileEditor var1, @NotNull FileEditor var2);

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }

    @NotNull
    public static AsyncFileEditorProvider.Builder getBuilderFromEditorProvider(final @NotNull FileEditorProvider provider, final @NotNull Project project, final @NotNull VirtualFile file) {
        if (provider instanceof AsyncFileEditorProvider) {
            return ((AsyncFileEditorProvider)provider).createEditorAsync(project, file);
        }
        return new AsyncFileEditorProvider.Builder(){

            public FileEditor build() {
                return provider.createEditor(project, file);
            }
        };
    }
}

