/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.html;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.LeafASTNode;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.TrimmingInlineHolderProvider;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.CommandRunnerExtension;
import org.intellij.plugins.markdown.ui.preview.html.DefaultCodeFenceGeneratingProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012R\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/html/CodeSpanRunnerGeneratingProvider;", "Lorg/intellij/markdown/html/TrimmingInlineHolderProvider;", "generatingProvider", "Lorg/intellij/markdown/html/GeneratingProvider;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lorg/intellij/markdown/html/GeneratingProvider;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getGeneratingProvider", "()Lorg/intellij/markdown/html/GeneratingProvider;", "getProject", "()Lcom/intellij/openapi/project/Project;", "processNode", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "intellij.markdown.core"})
public final class CodeSpanRunnerGeneratingProvider
extends TrimmingInlineHolderProvider {
    @NotNull
    private final GeneratingProvider generatingProvider;
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile file;

    public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
        CommandRunnerExtension codeViewExtension = CommandRunnerExtension.Companion.getRunnerByFile(this.file);
        if (codeViewExtension == null) {
            this.generatingProvider.processNode(visitor, text, node);
            return;
        }
        Object codeLine = "";
        for (ASTNode child : this.childrenToRender(node)) {
            IElementType iElementType;
            if (!(child instanceof LeafASTNode) || Intrinsics.areEqual((Object)(iElementType = child.getType()), (Object)MarkdownTokenTypes.BACKTICK)) continue;
            String string = text;
            int n = child.getStartOffset();
            int n2 = child.getEndOffset();
            String string2 = string.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            codeLine = (String)codeLine + string2;
        }
        HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default((HtmlGenerator.HtmlGeneratingVisitor)visitor, (ASTNode)node, (CharSequence)"code", (CharSequence[])new CharSequence[0], (boolean)false, (int)8, null);
        visitor.consumeHtml((CharSequence)(codeViewExtension.processCodeLine((String)codeLine, false) + DefaultCodeFenceGeneratingProvider.Companion.escape$intellij_markdown_core((String)codeLine)));
        visitor.consumeTagClose((CharSequence)"code");
    }

    @NotNull
    public final GeneratingProvider getGeneratingProvider() {
        return this.generatingProvider;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    public CodeSpanRunnerGeneratingProvider(@NotNull GeneratingProvider generatingProvider, @NotNull Project project, @NotNull VirtualFile file) {
        this.generatingProvider = generatingProvider;
        this.project = project;
        this.file = file;
    }
}

