/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.ui.preview.PreviewStaticServer;
import org.intellij.plugins.markdown.ui.preview.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.FileResponses;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/PreviewStaticServer;", "Lorg/jetbrains/ide/HttpRequestHandler;", "()V", "defaultResourceProvider", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider$DefaultResourceProvider;", "resourceProviders", "Ljava/util/HashMap;", "", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "Lkotlin/collections/HashMap;", "getProviderHash", "path", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "getStaticPath", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "obtainResourceProvider", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "registerResourceProvider", "Lcom/intellij/openapi/Disposable;", "resourceProvider", "unregisterResourceProvider", "", "Companion", "intellij.markdown.core"})
public final class PreviewStaticServer
extends HttpRequestHandler {
    private final ResourceProvider.DefaultResourceProvider defaultResourceProvider = new ResourceProvider.DefaultResourceProvider();
    private final HashMap<Integer, ResourceProvider> resourceProviders = MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)this.defaultResourceProvider.hashCode(), (Object)this.defaultResourceProvider)});
    private static final String prefixUuid = "4f800f8a-bbed-4dd8-b03c-00449c9f6698";
    private static final String prefixPath = "/4f800f8a-bbed-4dd8-b03c-00449c9f6698";
    private static final String[] typesForExplicitUtfCharset;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final synchronized Disposable registerResourceProvider(@NotNull ResourceProvider resourceProvider) {
        ((Map)this.resourceProviders).put(resourceProvider.hashCode(), resourceProvider);
        return new Disposable(this, resourceProvider){
            final /* synthetic */ PreviewStaticServer this$0;
            final /* synthetic */ ResourceProvider $resourceProvider;

            public final void dispose() {
                this.this$0.unregisterResourceProvider(this.$resourceProvider);
            }
            {
                this.this$0 = previewStaticServer;
                this.$resourceProvider = resourceProvider;
            }
        };
    }

    public final synchronized void unregisterResourceProvider(@NotNull ResourceProvider resourceProvider) {
        this.resourceProviders.remove(resourceProvider.hashCode());
    }

    private final Integer getProviderHash(String path) {
        String string = (String)CollectionsKt.getOrNull((List)StringsKt.split$default((CharSequence)path, (char[])new char[]{'/'}, (boolean)false, (int)0, (int)6, null), (int)2);
        return string != null ? StringsKt.toIntOrNull((String)string) : null;
    }

    private final String getStaticPath(String path) {
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)StringsKt.split$default((CharSequence)path, (char[])new char[]{'/'}, (boolean)false, (int)0, (int)6, null), (int)3), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ResourceProvider obtainResourceProvider(String path) {
        ResourceProvider resourceProvider;
        HashMap<Integer, ResourceProvider> hashMap;
        Integer n = this.getProviderHash(path);
        if (n == null) {
            return null;
        }
        int providerHash = n;
        HashMap<Integer, ResourceProvider> hashMap2 = hashMap = this.resourceProviders;
        synchronized (hashMap2) {
            boolean bl = false;
            Map map = this.resourceProviders;
            Integer n2 = providerHash;
            Object v = null;
            resourceProvider = map.getOrDefault(n2, v);
        }
        return resourceProvider;
    }

    public boolean isSupported(@NotNull FullHttpRequest request) {
        if (!super.isSupported(request)) {
            return false;
        }
        String path = request.uri();
        return StringsKt.startsWith$default((String)path, (String)prefixPath, (boolean)false, (int)2, null);
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        String path = urlDecoder.path();
        boolean bl = StringsKt.startsWith$default((String)path, (String)prefixPath, (boolean)false, (int)2, null);
        if (!bl) {
            boolean $i$a$-check-PreviewStaticServer$process$22 = false;
            String $i$a$-check-PreviewStaticServer$process$22 = "prefix should have been checked by #isSupported";
            throw new IllegalStateException($i$a$-check-PreviewStaticServer$process$22.toString());
        }
        ResourceProvider resourceProvider = this.obtainResourceProvider(path);
        if (resourceProvider == null) {
            return false;
        }
        ResourceProvider resourceProvider2 = resourceProvider;
        String resourceName = this.getStaticPath(path);
        if (resourceProvider2.canProvide(resourceName)) {
            PreviewStaticServer.Companion.sendResource((HttpRequest)request, context.channel(), resourceProvider2.loadResource(resourceName), resourceName);
            return true;
        }
        return false;
    }

    static {
        Companion = new Companion(null);
        typesForExplicitUtfCharset = new String[]{"application/javascript", "text/html", "text/css", "image/svg+xml"};
    }

    @NotNull
    public static final PreviewStaticServer getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @NotNull
    public static final String createCSP(@NotNull List<String> scripts, @NotNull List<String> styles) {
        return Companion.createCSP(scripts, styles);
    }

    @JvmStatic
    @NotNull
    public static final String getStaticUrl(@NotNull ResourceProvider resourceProvider, @NotNull String staticPath) {
        return Companion.getStaticUrl(resourceProvider, staticPath);
    }

    @Deprecated(message="Use PreviewStaticServer.getStaticUrl(ResourceProvider, String) instead")
    @JvmStatic
    @NotNull
    public static final String getStaticUrl(@NotNull String staticPath) {
        return Companion.getStaticUrl(staticPath);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u000e\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0007J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tH\u0007J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\tH\u0007J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0002J*\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0017\u001a\u00020\tH\u0002R\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006 "}, d2={"Lorg/intellij/plugins/markdown/ui/preview/PreviewStaticServer$Companion;", "", "()V", "instance", "Lorg/intellij/plugins/markdown/ui/preview/PreviewStaticServer;", "getInstance$annotations", "getInstance", "()Lorg/intellij/plugins/markdown/ui/preview/PreviewStaticServer;", "prefixPath", "", "prefixUuid", "typesForExplicitUtfCharset", "", "[Ljava/lang/String;", "createCSP", "scripts", "", "styles", "getStaticUrl", "staticPath", "resourceProvider", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "guessContentType", "resourceName", "sendResource", "", "request", "Lio/netty/handler/codec/http/HttpRequest;", "channel", "Lio/netty/channel/Channel;", "resource", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider$Resource;", "intellij.markdown.core"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        @NotNull
        public final PreviewStaticServer getInstance() {
            PreviewStaticServer previewStaticServer = (PreviewStaticServer)((Object)HttpRequestHandler.Companion.getEP_NAME().findExtension(PreviewStaticServer.class));
            if (previewStaticServer == null) {
                String string = "Could not get server instance!";
                throw new IllegalStateException(string.toString());
            }
            return previewStaticServer;
        }

        @JvmStatic
        @NotNull
        public final String createCSP(@NotNull List<String> scripts, @NotNull List<String> styles) {
            Object object;
            String p1;
            Object object2;
            Iterable $this$mapTo$iv$iv;
            createCSP.1 $fun$stripQueryParameters$1 = createCSP.1.INSTANCE;
            Iterable $this$map$iv = scripts;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl = false;
                object = createCSP.1.INSTANCE.invoke(p1);
                object2.add(object);
            }
            $this$map$iv = styles;
            object2 = StringUtil.join((Collection)((List)destination$iv$iv), (String)" ");
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                p1 = (String)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                String string = createCSP.1.INSTANCE.invoke(p1);
                object.add(string);
            }
            object = (List)destination$iv$iv;
            return "\n        default-src 'none';\n        script-src " + (String)object2 + ";\n        style-src https: " + StringUtil.join((Collection)((Collection)object), (String)" ") + " 'unsafe-inline';\n        img-src file: *; connect-src 'none'; font-src * data: *;\n        object-src 'none'; media-src 'none'; child-src 'none';\n      ";
        }

        @JvmStatic
        @NotNull
        public final String getStaticUrl(@NotNull ResourceProvider resourceProvider, @NotNull String staticPath) {
            int providerHash = resourceProvider.hashCode();
            int port = BuiltInServerManager.Companion.getInstance().getPort();
            String raw = "http://localhost:" + port + "/4f800f8a-bbed-4dd8-b03c-00449c9f6698/" + providerHash + "/" + staticPath;
            Url url = Urls.parseEncoded((String)raw);
            if (url == null) {
                boolean bl = false;
                String string = "Could not parse url!";
                throw new IllegalArgumentException(string.toString());
            }
            return BuiltInServerManager.Companion.getInstance().addAuthToken(url).toExternalForm();
        }

        @Deprecated(message="Use PreviewStaticServer.getStaticUrl(ResourceProvider, String) instead")
        @JvmStatic
        @NotNull
        public final String getStaticUrl(@NotNull String staticPath) {
            return this.getStaticUrl(this.getInstance().defaultResourceProvider, staticPath);
        }

        private final String guessContentType(String resourceName) {
            String type = FileResponses.INSTANCE.getContentType(resourceName);
            return ArraysKt.contains((Object[])typesForExplicitUtfCharset, (Object)type) ? type + "; charset=utf-8" : type;
        }

        private final void sendResource(HttpRequest request, Channel channel, ResourceProvider.Resource resource, String resourceName) {
            FullHttpResponse response;
            long lastModified = ApplicationInfo.getInstance().getBuildDate().getTimeInMillis();
            if (FileResponses.checkCache$default((FileResponses)FileResponses.INSTANCE, (HttpRequest)request, (Channel)channel, (long)lastModified, null, (int)8, null)) {
                return;
            }
            if (resource == null) {
                Responses.send$default((HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (Channel)channel, (HttpRequest)request, null, null, (int)12, null);
                return;
            }
            FullHttpResponse $this$with = response = (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])resource.getContent()));
            boolean bl = false;
            if (resource.getType() != null) {
                $this$with.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)resource.getType());
            } else {
                $this$with.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)Companion.guessContentType(resourceName));
            }
            $this$with.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"private, must-revalidate");
            $this$with.headers().set((CharSequence)HttpHeaderNames.LAST_MODIFIED, (Object)new Date(lastModified));
            Responses.send$default((HttpResponse)((HttpResponse)$this$with), (Channel)channel, (HttpRequest)request, null, (int)4, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

