/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.intellij.plugins.markdown.ui.preview.MarkdownEditorWithPreviewState;
import org.intellij.plugins.markdown.ui.preview.MarkdownPreviewFileEditor;
import org.jetbrains.annotations.NotNull;

public final class MarkdownEditorWithPreview
extends TextEditorWithPreview {
    public static final Key<MarkdownEditorWithPreview> PARENT_SPLIT_EDITOR_KEY = Key.create((String)"parentSplit");
    private boolean myAutoScrollPreview;
    private final List<SplitLayoutListener> myLayoutListeners = new ArrayList<SplitLayoutListener>();

    public MarkdownEditorWithPreview(@NotNull TextEditor editor2, @NotNull MarkdownPreviewFileEditor preview) {
        super(editor2, (FileEditor)preview, MarkdownBundle.message("markdown.editor.name", new Object[0]), TextEditorWithPreview.Layout.SHOW_EDITOR_AND_PREVIEW, !MarkdownSettings.getInstance(ProjectUtil.currentOrDefaultProject((Project)editor2.getEditor().getProject())).isVerticalSplit());
        editor2.putUserData(PARENT_SPLIT_EDITOR_KEY, (Object)this);
        preview.putUserData(PARENT_SPLIT_EDITOR_KEY, (Object)this);
        preview.setMainEditor(editor2.getEditor());
        Project project = ProjectUtil.currentOrDefaultProject((Project)editor2.getEditor().getProject());
        final MarkdownSettings settings = MarkdownSettings.getInstance(project);
        this.myAutoScrollPreview = settings.isAutoScrollEnabled();
        MarkdownSettings.ChangeListener settingsChangedListener = new MarkdownSettings.ChangeListener(){
            private boolean wasVerticalSplitBefore;
            {
                this.wasVerticalSplitBefore = settings.isVerticalSplit();
            }

            @Override
            public void beforeSettingsChanged(@NotNull MarkdownSettings settings2) {
                this.wasVerticalSplitBefore = settings2.isVerticalSplit();
            }

            @Override
            public void settingsChanged(@NotNull MarkdownSettings settings2) {
                MarkdownEditorWithPreview.this.setAutoScrollPreview(settings2.isAutoScrollEnabled());
                if (this.wasVerticalSplitBefore != settings2.isVerticalSplit()) {
                    MarkdownEditorWithPreview.this.handleLayoutChange(!settings2.isVerticalSplit());
                }
            }
        };
        project.getMessageBus().connect((Disposable)this).subscribe(MarkdownSettings.ChangeListener.TOPIC, (Object)settingsChangedListener);
        this.getTextEditor().getEditor().getScrollingModel().addVisibleAreaListener((VisibleAreaListener)new MyVisibleAreaListener());
    }

    public void addLayoutListener(SplitLayoutListener listener) {
        this.myLayoutListeners.add(listener);
    }

    public void removeLayoutListener(SplitLayoutListener listener) {
        this.myLayoutListeners.remove(listener);
    }

    protected void onLayoutChange(TextEditorWithPreview.Layout oldValue, TextEditorWithPreview.Layout newValue) {
        this.myLayoutListeners.forEach(listener -> listener.onLayoutChange(oldValue, newValue));
        super.onLayoutChange(oldValue, newValue);
    }

    public boolean isAutoScrollPreview() {
        return this.myAutoScrollPreview;
    }

    public void setAutoScrollPreview(boolean autoScrollPreview) {
        this.myAutoScrollPreview = autoScrollPreview;
    }

    public void setLayout(@NotNull TextEditorWithPreview.Layout layout) {
        super.setLayout(layout);
    }

    public void setState(@NotNull FileEditorState state) {
        if (state instanceof MarkdownEditorWithPreviewState) {
            MarkdownEditorWithPreviewState actualState = (MarkdownEditorWithPreviewState)state;
            super.setState(actualState.getUnderlyingState());
            this.setVerticalSplit(actualState.isVerticalSplit());
        }
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        FileEditorState underlyingState = super.getState(level);
        return new MarkdownEditorWithPreviewState(underlyingState, this.isVerticalSplit());
    }

    @NotNull
    protected ToggleAction getShowEditorAction() {
        return (ToggleAction)Objects.requireNonNull(ActionUtil.getAction((String)"Markdown.Layout.EditorOnly"));
    }

    @NotNull
    protected ToggleAction getShowEditorAndPreviewAction() {
        return (ToggleAction)Objects.requireNonNull(ActionUtil.getAction((String)"Markdown.Layout.EditorAndPreview"));
    }

    @NotNull
    protected ToggleAction getShowPreviewAction() {
        return (ToggleAction)Objects.requireNonNull(ActionUtil.getAction((String)"Markdown.Layout.PreviewOnly"));
    }

    private class MyVisibleAreaListener
    implements VisibleAreaListener {
        private int previousLine = 0;

        private MyVisibleAreaListener() {
        }

        public void visibleAreaChanged(@NotNull VisibleAreaEvent event) {
            int currentLine;
            if (!MarkdownEditorWithPreview.this.isAutoScrollPreview()) {
                return;
            }
            Editor editor2 = event.getEditor();
            int y = editor2.getScrollingModel().getVerticalScrollOffset();
            int n = currentLine = editor2 instanceof EditorImpl ? editor2.yToVisualLine(y) : y / editor2.getLineHeight();
            if (currentLine == this.previousLine) {
                return;
            }
            this.previousLine = currentLine;
            ((MarkdownPreviewFileEditor)MarkdownEditorWithPreview.this.getPreviewEditor()).scrollToSrcOffset(EditorUtil.getVisualLineEndOffset((Editor)editor2, (int)currentLine));
        }
    }

    public static interface SplitLayoutListener
    extends EventListener {
        public void onLayoutChange(TextEditorWithPreview.Layout var1, TextEditorWithPreview.Layout var2);
    }
}

