/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions.styling;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.util.DocumentUtil;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElementFactory;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionUtil;
import org.intellij.plugins.markdown.ui.actions.styling.SetHeaderLevelImpl$setSelected$;
import org.intellij.plugins.markdown.ui.actions.styling.SetHeaderLevelImpl$tryToCreateHeaderFromRawLine$;
import org.intellij.plugins.markdown.util.MarkdownPsiUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b'\u0018\u0000  2\u00020\u0001:\u0005 !\"#$BX\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0011\u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070\u0005\u0012\u0015\b\u0002\u0010\b\u001a\u000f\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u0007\u0018\u00010\u0005\u0012\u0013\b\u0002\u0010\t\u001a\r\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070\u0005\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J\u0018\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\b\u001a\u000f\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u0007\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006%"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/SetHeaderLevelImpl;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "level", "", "text", "Ljava/util/function/Supplier;", "", "Lorg/jetbrains/annotations/Nls;", "secondaryText", "description", "icon", "Ljavax/swing/Icon;", "(ILjava/util/function/Supplier;Ljava/util/function/Supplier;Ljava/util/function/Supplier;Ljavax/swing/Icon;)V", "getLevel", "()I", "getSecondaryText", "()Ljava/util/function/Supplier;", "handleExistingHeader", "", "header", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeader;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isSelected", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "state", "tryToCreateHeaderFromRawLine", "caret", "Lcom/intellij/openapi/editor/Caret;", "Companion", "Heading", "Normal", "Subtitle", "Title", "intellij.markdown.core"})
@ApiStatus.Internal
public abstract class SetHeaderLevelImpl
extends ToggleAction {
    private final int level;
    @Nullable
    private final Supplier<String> secondaryText;
    private static final TokenSet inlineElements;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public boolean isSelected(@NotNull AnActionEvent event) {
        MarkdownHeader markdownHeader;
        PsiElement element2;
        PsiFile psiFile = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return false;
        }
        PsiFile file = psiFile;
        Caret caret = (Caret)event.getData(CommonDataKeys.CARET);
        if (caret == null) {
            return false;
        }
        Caret caret2 = caret;
        PsiElement psiElement = element2 = Companion.findParent$intellij_markdown_core(file, caret2);
        if (psiElement != null) {
            void $this$parentOfType$iv;
            PsiElement psiElement2 = psiElement;
            boolean withSelf$iv = true;
            boolean $i$f$parentOfType = false;
            markdownHeader = (MarkdownHeader)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, MarkdownHeader.class, (boolean)false);
        } else {
            markdownHeader = null;
        }
        MarkdownHeader header = markdownHeader;
        return header == null && this.level == 0 ? true : (header != null ? header.getLevel() == this.level : false);
    }

    public void setSelected(@NotNull AnActionEvent event, boolean state) {
        if (!state) {
            return;
        }
        PsiFile psiFile = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        Caret caret = (Caret)event.getData(CommonDataKeys.CARET);
        if (caret == null) {
            return;
        }
        Caret caret2 = caret;
        Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        PsiElement element2 = Companion.findParent$intellij_markdown_core(file, caret2);
        if (element2 == null) {
            this.tryToCreateHeaderFromRawLine(editor3, caret2);
            return;
        }
        MarkdownHeader header = (MarkdownHeader)PsiTreeUtil.getParentOfType((PsiElement)element2, MarkdownHeader.class, (boolean)false);
        Project project = file.getProject();
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable(this, project, header, editor3, element2){
            final /* synthetic */ SetHeaderLevelImpl this$0;
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ MarkdownHeader $header$inlined;
            final /* synthetic */ Editor $editor$inlined;
            final /* synthetic */ PsiElement $element$inlined;
            {
                this.this$0 = setHeaderLevelImpl;
                this.$project$inlined = project;
                this.$header$inlined = markdownHeader;
                this.$editor$inlined = editor2;
                this.$element$inlined = psiElement;
            }

            public final T compute() {
                boolean bl = false;
                Project project$iv = this.$project$inlined;
                String name$iv = null;
                String groupId$iv = null;
                boolean $i$f$executeCommand = false;
                CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(this){
                    final /* synthetic */ setSelected$$inlined$runWriteAction$1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void run() {
                        boolean bl = false;
                        if (this.this$0.$header$inlined != null) {
                            SetHeaderLevelImpl.access$handleExistingHeader(this.this$0.this$0, this.this$0.$header$inlined, this.this$0.$editor$inlined);
                        } else if (this.this$0.this$0.getLevel() != 0) {
                            this.this$0.$element$inlined.replace((PsiElement)MarkdownPsiElementFactory.createHeader(this.this$0.$project$inlined, this.this$0.this$0.getLevel(), this.this$0.$element$inlined.getText()));
                        }
                    }
                }, name$iv, (Object)groupId$iv);
                return (T)Unit.INSTANCE;
            }
        });
    }

    private final void tryToCreateHeaderFromRawLine(Editor editor2, Caret caret) {
        Document document = editor2.getDocument();
        int selectionStart = caret.getSelectionStart();
        int selectionEnd = caret.getSelectionEnd();
        int line = document.getLineNumber(selectionStart);
        if (line != document.getLineNumber(selectionEnd)) {
            return;
        }
        int lineStartOffset = document.getLineStartOffset(line);
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable(this, editor2, line, document, lineStartOffset){
            final /* synthetic */ SetHeaderLevelImpl this$0;
            final /* synthetic */ Editor $editor$inlined;
            final /* synthetic */ int $line$inlined;
            final /* synthetic */ Document $document$inlined;
            final /* synthetic */ int $lineStartOffset$inlined;
            {
                this.this$0 = setHeaderLevelImpl;
                this.$editor$inlined = editor2;
                this.$line$inlined = n;
                this.$document$inlined = document;
                this.$lineStartOffset$inlined = n2;
            }

            public final T compute() {
                boolean bl = false;
                Project project$iv = this.$editor$inlined.getProject();
                String name$iv = null;
                String groupId$iv = null;
                boolean $i$f$executeCommand = false;
                CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(this){
                    final /* synthetic */ tryToCreateHeaderFromRawLine$$inlined$runWriteAction$1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void run() {
                        boolean bl = false;
                        int nextLine = this.this$0.$line$inlined + 1;
                        if (nextLine < this.this$0.$document$inlined.getLineCount() && !DocumentUtil.isLineEmpty((Document)this.this$0.$document$inlined, (int)nextLine)) {
                            int lineEndOffset = this.this$0.$document$inlined.getLineEndOffset(this.this$0.$line$inlined);
                            this.this$0.$document$inlined.insertString(lineEndOffset, (CharSequence)"\n");
                        }
                        this.this$0.$document$inlined.insertString(this.this$0.$lineStartOffset$inlined, (CharSequence)(StringsKt.repeat((CharSequence)"#", (int)this.this$0.this$0.getLevel()) + " "));
                        int previousLine = this.this$0.$line$inlined - 1;
                        if (previousLine >= 0 && !DocumentUtil.isLineEmpty((Document)this.this$0.$document$inlined, (int)previousLine)) {
                            this.this$0.$document$inlined.insertString(this.this$0.$lineStartOffset$inlined, (CharSequence)"\n");
                        }
                    }
                }, name$iv, (Object)groupId$iv);
                return (T)Unit.INSTANCE;
            }
        });
    }

    private final void handleExistingHeader(MarkdownHeader header, Editor editor2) {
        block3: {
            block2: {
                if (this.level != 0) break block2;
                String string = header.getName();
                if (string == null) {
                    return;
                }
                editor2.getDocument().replaceString(UtilsKt.getStartOffset((PsiElement)((PsiElement)header)), UtilsKt.getEndOffset((PsiElement)((PsiElement)header)), (CharSequence)string);
                break block3;
            }
            if (header.getLevel() == this.level) break block3;
            String string = header.getName();
            if (string == null) {
                return;
            }
            header.replace((PsiElement)MarkdownPsiElementFactory.createHeader(header.getProject(), string, this.level));
        }
    }

    public final int getLevel() {
        return this.level;
    }

    @Nullable
    public final Supplier<String> getSecondaryText() {
        return this.secondaryText;
    }

    public SetHeaderLevelImpl(int level, @NotNull Supplier<String> text, @Nullable Supplier<String> secondaryText, @NotNull Supplier<String> description, @Nullable Icon icon) {
        super(text, description, icon);
        this.level = level;
        this.secondaryText = secondaryText;
    }

    public /* synthetic */ SetHeaderLevelImpl(int n, Supplier supplier, Supplier supplier2, Supplier supplier3, Icon icon, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            supplier2 = null;
        }
        if ((n2 & 8) != 0) {
            supplier3 = supplier;
        }
        if ((n2 & 0x10) != 0) {
            icon = null;
        }
        this(n, supplier, supplier2, supplier3, icon);
    }

    static {
        Companion = new Companion(null);
        inlineElements = TokenSet.orSet((TokenSet[])new TokenSet[]{MarkdownTokenTypeSets.INLINE_HOLDING_ELEMENT_TYPES, MarkdownTokenTypeSets.INLINE_HOLDING_ELEMENT_PARENTS_TYPES});
    }

    public static final /* synthetic */ void access$handleExistingHeader(SetHeaderLevelImpl $this, MarkdownHeader header, Editor editor2) {
        $this.handleExistingHeader(header, editor2);
    }

    @JvmStatic
    @Nullable
    public static final PsiElement findParent$intellij_markdown_core(@NotNull PsiFile psiFile, @NotNull Caret caret) {
        return Companion.findParent$intellij_markdown_core(psiFile, caret);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/SetHeaderLevelImpl$Normal;", "Lorg/intellij/plugins/markdown/ui/actions/styling/SetHeaderLevelImpl;", "()V", "intellij.markdown.core"})
    public static final class Normal
    extends SetHeaderLevelImpl {
        public Normal() {
            super(0, MarkdownBundle.messagePointer("markdown.header.level.popup.normal.action.text", new Object[0]), null, null, null, 28, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/SetHeaderLevelImpl$Title;", "Lorg/intellij/plugins/markdown/ui/actions/styling/SetHeaderLevelImpl;", "()V", "intellij.markdown.core"})
    public static final class Title
    extends SetHeaderLevelImpl {
        public Title() {
            super(1, MarkdownBundle.messagePointer("markdown.header.level.popup.title.action.text", new Object[0]), MarkdownBundle.messagePointer("markdown.header.level.popup.heading.action.secondary.text", 1), null, null, 24, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/SetHeaderLevelImpl$Subtitle;", "Lorg/intellij/plugins/markdown/ui/actions/styling/SetHeaderLevelImpl;", "()V", "intellij.markdown.core"})
    public static final class Subtitle
    extends SetHeaderLevelImpl {
        public Subtitle() {
            super(2, MarkdownBundle.messagePointer("markdown.header.level.popup.subtitle.action.text", new Object[0]), MarkdownBundle.messagePointer("markdown.header.level.popup.heading.action.secondary.text", 2), null, null, 24, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/SetHeaderLevelImpl$Heading;", "Lorg/intellij/plugins/markdown/ui/actions/styling/SetHeaderLevelImpl;", "level", "", "(I)V", "intellij.markdown.core"})
    public static final class Heading
    extends SetHeaderLevelImpl {
        public Heading(int level) {
            super(level, MarkdownBundle.messagePointer("markdown.header.level.popup.heading.action.text", level - 2), MarkdownBundle.messagePointer("markdown.header.level.popup.heading.action.secondary.text", level), null, null, 24, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\b\fJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/SetHeaderLevelImpl$Companion;", "", "()V", "inlineElements", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "findParent", "Lcom/intellij/psi/PsiElement;", "psiFile", "Lcom/intellij/psi/PsiFile;", "caret", "Lcom/intellij/openapi/editor/Caret;", "findParent$intellij_markdown_core", "isSameLine", "", "document", "Lcom/intellij/openapi/editor/Document;", "firstOffset", "", "secondOffset", "intellij.markdown.core"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final PsiElement findParent$intellij_markdown_core(@NotNull PsiFile psiFile, @NotNull Caret caret) {
            PsiElement parent;
            PsiElement endElement;
            void left;
            Pair<PsiElement, PsiElement> pair = MarkdownActionUtil.getElementsUnderCaretOrSelection(psiFile, caret);
            PsiElement psiElement = (PsiElement)pair.component1();
            PsiElement right = (PsiElement)pair.component2();
            PsiElement startElement = MarkdownPsiUtil.WhiteSpaces.isNewLine((PsiElement)left) ? PsiTreeUtil.nextVisibleLeaf((PsiElement)left) : left;
            PsiElement psiElement2 = endElement = MarkdownPsiUtil.WhiteSpaces.isNewLine(right) ? PsiTreeUtil.prevVisibleLeaf((PsiElement)right) : right;
            if (startElement == null || endElement == null || startElement.getTextOffset() > endElement.getTextOffset()) {
                return null;
            }
            PsiElement psiElement3 = parent = MarkdownActionUtil.getCommonParentOfTypes(startElement, endElement, inlineElements);
            if (psiElement3 == null || !PsiUtilsKt.hasType(psiElement3, MarkdownElementTypes.PARAGRAPH)) {
                return parent;
            }
            Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
            if (document == null) {
                return null;
            }
            Document document2 = document;
            int startOffset = parent.getTextRange().getStartOffset();
            int endOffset = parent.getTextRange().getEndOffset();
            if (startOffset < 0 || endOffset > document2.getTextLength()) {
                return null;
            }
            return this.isSameLine(document2, startOffset, endOffset) ? parent : null;
        }

        private final boolean isSameLine(Document document, int firstOffset, int secondOffset) {
            return document.getLineNumber(firstOffset) == document.getLineNumber(secondOffset);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

