/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions.styling;

import com.intellij.codeInsight.daemon.impl.quickfix.EmptyExpression;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ReplacePromptDialog;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import kotlin.Pair;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElementFactory;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDestination;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownIntroduceLinkReferenceAction
extends AnAction
implements DumbAware {
    private static final String VAR_NAME = "reference";

    public void update(@NotNull AnActionEvent e) {
        com.intellij.openapi.util.Pair<PsiFile, Editor> fileAndEditor = MarkdownIntroduceLinkReferenceAction.getFileAndEditor(e);
        if (fileAndEditor == null) {
            return;
        }
        Caret caret = ((Editor)fileAndEditor.getSecond()).getCaretModel().getCurrentCaret();
        Pair<PsiElement, PsiElement> elements2 = MarkdownActionUtil.getElementsUnderCaretOrSelection((PsiFile)fileAndEditor.getFirst(), caret);
        PsiElement parentLink = MarkdownActionUtil.getCommonParentOfTypes((PsiElement)elements2.getFirst(), (PsiElement)elements2.getSecond(), MarkdownTokenTypeSets.LINKS);
        if (parentLink == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setEnabled(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Caret caret;
        com.intellij.openapi.util.Pair<PsiFile, Editor> fileAndEditor = MarkdownIntroduceLinkReferenceAction.getFileAndEditor(e);
        if (fileAndEditor == null) {
            return;
        }
        Editor editor2 = (Editor)fileAndEditor.getSecond();
        PsiFile file = (PsiFile)fileAndEditor.getFirst();
        Pair<PsiElement, PsiElement> elements2 = MarkdownActionUtil.getElementsUnderCaretOrSelection(file, caret = editor2.getCaretModel().getCurrentCaret());
        PsiElement link = MarkdownActionUtil.getCommonTopmostParentOfTypes((PsiElement)elements2.getFirst(), (PsiElement)elements2.getSecond(), MarkdownTokenTypeSets.LINKS);
        if (link == null) {
            return;
        }
        Project project = link.getProject();
        WriteCommandAction.runWriteCommandAction((Project)file.getProject(), null, null, () -> {
            PostprocessReformattingAspect.getInstance((Project)file.getProject()).disablePostprocessFormattingInside(() -> {
                if (!file.isValid()) {
                    return;
                }
                com.intellij.openapi.util.Pair<PsiElement, PsiElement> referencePair = MarkdownIntroduceLinkReferenceAction.createLinkDeclarationAndReference(project, link, VAR_NAME);
                MarkdownIntroduceLinkReferenceAction.insertLastNewLines(file, 2);
                PsiElement declaration = file.addAfter((PsiElement)referencePair.getSecond(), file.getLastChild());
                PsiElement reference = link.replace((PsiElement)referencePair.getFirst());
                String url = Objects.requireNonNull((MarkdownLinkDestination)PsiTreeUtil.getChildOfType((PsiElement)declaration, MarkdownLinkDestination.class)).getText();
                PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor2.getDocument());
                TemplateBuilderImpl builder = (TemplateBuilderImpl)TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)file);
                PsiElement declarationLabel = declaration.getFirstChild();
                PsiElement referenceLabel = reference.getFirstChild().getLastChild();
                TextExpression expression = ApplicationManager.getApplication().isUnitTestMode() ? new TextExpression(VAR_NAME) : new EmptyExpression();
                builder.replaceElement(declarationLabel, TextRange.create((int)1, (int)(declarationLabel.getTextLength() - 1)), VAR_NAME, (Expression)expression, true);
                builder.replaceElement(referenceLabel, TextRange.create((int)1, (int)(referenceLabel.getTextLength() - 1)), VAR_NAME, (Expression)expression, true);
                editor2.getCaretModel().moveToOffset(0);
                Template template = builder.buildInlineTemplate();
                PsiElement title = ((PsiElement)referencePair.getSecond()).getLastChild();
                String titleText = null;
                if (PsiUtilCore.getElementType((PsiElement)title) == MarkdownElementTypes.LINK_TITLE) {
                    titleText = title.getText();
                }
                TemplateManager.getInstance((Project)project).startTemplate(editor2, template, (TemplateEditingListener)new DuplicatesFinder(file, editor2, url, titleText));
            });
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor2.getDocument());
        }, (PsiFile[])new PsiFile[0]);
    }

    @Nullable
    private static com.intellij.openapi.util.Pair<PsiFile, Editor> getFileAndEditor(@NotNull AnActionEvent e) {
        Editor editor2 = MarkdownActionUtil.findMarkdownTextEditor(e);
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (editor2 == null || psiFile == null || !psiFile.isValid()) {
            return null;
        }
        return com.intellij.openapi.util.Pair.create((Object)psiFile, (Object)editor2);
    }

    private static void insertLastNewLines(@NotNull PsiFile psiFile, int num) {
        assert (num >= 0) : "Cannot insert negative number of new lines";
        PsiElement newLines = MarkdownPsiElementFactory.createNewLines(psiFile.getProject(), num);
        psiFile.addRange(newLines.getFirstChild(), newLines.getLastChild());
    }

    public static void replaceDuplicate(@NotNull PsiElement match, @NotNull String referenceText) {
        WriteCommandAction.runWriteCommandAction((Project)match.getProject(), null, null, () -> {
            PsiFile file = match.getContainingFile();
            if (!file.isValid()) {
                return;
            }
            match.replace((PsiElement)MarkdownIntroduceLinkReferenceAction.createLinkDeclarationAndReference(match.getProject(), match, referenceText).getFirst());
        }, (PsiFile[])new PsiFile[0]);
    }

    @NotNull
    public static com.intellij.openapi.util.Pair<PsiElement, PsiElement> createLinkDeclarationAndReference(Project project, PsiElement link, String referenceText) {
        String text = null;
        String title = null;
        String url = MarkdownIntroduceLinkReferenceAction.getUrl(link);
        if (PsiUtilCore.getElementType((PsiElement)link) == MarkdownElementTypes.INLINE_LINK) {
            PsiElement titleElement;
            SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser();
            PsiElement textElement = (PsiElement)syntaxTraverser.children((Object)link).find(child -> PsiUtilCore.getElementType((PsiElement)child) == MarkdownElementTypes.LINK_TEXT);
            if (textElement != null) {
                text = textElement.getText();
                assert (text.startsWith("[") && text.endsWith("]"));
                text = text.substring(1, text.length() - 1);
            }
            if ((titleElement = (PsiElement)syntaxTraverser.children((Object)link).find(child -> PsiUtilCore.getElementType((PsiElement)child) == MarkdownElementTypes.LINK_TITLE)) != null) {
                title = titleElement.getText();
            }
        }
        assert (url != null);
        if (text == null) {
            text = url;
        }
        return MarkdownPsiElementFactory.createLinkDeclarationAndReference(project, url, text, title, referenceText);
    }

    @Nullable
    public static String getUrl(@NotNull PsiElement link) {
        SyntaxTraverser syntaxTraverser;
        PsiElement child;
        String url = null;
        IElementType type = PsiUtilCore.getElementType((PsiElement)link);
        if (type == MarkdownElementTypes.AUTOLINK) {
            url = link.getFirstChild().getNextSibling().getText();
        } else if (type == MarkdownTokenTypes.GFM_AUTOLINK) {
            url = link.getText();
        } else if (type == MarkdownTokenTypes.EMAIL_AUTOLINK) {
            url = link.getText();
        } else if (type == MarkdownElementTypes.INLINE_LINK && (child = (PsiElement)(syntaxTraverser = SyntaxTraverser.psiTraverser()).children((Object)link).find(it -> PsiUtilCore.getElementType((PsiElement)it) == MarkdownElementTypes.LINK_DESTINATION)) != null) {
            url = child.getText();
        }
        return url;
    }

    public static void replaceDuplicates(@NotNull PsiElement file, @NotNull Editor editor2, @NotNull List<SmartPsiElementPointer<PsiElement>> duplicates, @NotNull String referenceText, boolean showWarning) {
        int exitCode;
        Object warningMessage = "";
        if (showWarning) {
            warningMessage = "\n\n" + MarkdownBundle.message("markdown.extract.link.extract.duplicates.warning", new Object[0]);
        }
        String message = MarkdownBundle.message("markdown.extract.link.extract.duplicates.description", ApplicationNamesInfo.getInstance().getProductName(), duplicates.size()) + (String)warningMessage;
        boolean isUnittest = ApplicationManager.getApplication().isUnitTestMode();
        Project project = file.getProject();
        int n = exitCode = !isUnittest ? Messages.showYesNoDialog((Project)project, (String)message, (String)MarkdownBundle.message("markdown.extract.link.refactoring.dialog.title", new Object[0]), (Icon)Messages.getInformationIcon()) : 0;
        if (exitCode == 0) {
            boolean replaceAll = false;
            HashMap<PsiElement, RangeHighlighter> highlighterMap = new HashMap<PsiElement, RangeHighlighter>();
            for (SmartPsiElementPointer<PsiElement> smartPsiElementPointer : duplicates) {
                PsiElement match = smartPsiElementPointer.getElement();
                if (match == null || !match.isValid()) continue;
                if (!replaceAll) {
                    MarkdownIntroduceLinkReferenceAction.highlightInEditor(project, editor2, highlighterMap, match);
                    int promptResult = 3;
                    if (!isUnittest) {
                        ReplacePromptDialog promptDialog = new ReplacePromptDialog(false, MarkdownBundle.message("markdown.extract.link.extract.link.replace", new Object[0]), project);
                        promptDialog.show();
                        promptResult = promptDialog.getExitCode();
                    }
                    if (promptResult == 2) {
                        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
                        RangeHighlighter highlighter = (RangeHighlighter)highlighterMap.get(match);
                        if (highlighter == null) continue;
                        highlightManager.removeSegmentHighlighter(editor2, highlighter);
                        continue;
                    }
                    if (promptResult == 1) break;
                    if (promptResult == 0) {
                        MarkdownIntroduceLinkReferenceAction.replaceDuplicate(match, referenceText);
                        continue;
                    }
                    if (promptResult != 3) continue;
                    MarkdownIntroduceLinkReferenceAction.replaceDuplicate(match, referenceText);
                    replaceAll = true;
                    continue;
                }
                MarkdownIntroduceLinkReferenceAction.replaceDuplicate(match, referenceText);
            }
        }
    }

    private static void highlightInEditor(@NotNull Project project, @NotNull Editor editor2, @NotNull Map<PsiElement, RangeHighlighter> highlighterMap, @NotNull PsiElement element2) {
        ArrayList highlighters = new ArrayList();
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        int startOffset = element2.getTextRange().getStartOffset();
        int endOffset = element2.getTextRange().getEndOffset();
        highlightManager.addRangeHighlight(editor2, startOffset, endOffset, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, highlighters);
        highlighterMap.put(element2, (RangeHighlighter)highlighters.get(0));
        LogicalPosition logicalPosition = editor2.offsetToLogicalPosition(startOffset);
        editor2.getScrollingModel().scrollTo(logicalPosition, ScrollType.MAKE_VISIBLE);
    }

    private static final class DuplicatesFinder
    extends TemplateEditingAdapter {
        @NotNull
        private final String myUrl;
        @NotNull
        private final PsiFile myFile;
        @NotNull
        private final Editor myEditor;
        @Nullable
        private final String myTitleText;

        private DuplicatesFinder(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull String url, String titleText) {
            this.myUrl = url;
            this.myFile = file;
            this.myEditor = editor2;
            this.myTitleText = titleText;
        }

        public void currentVariableChanged(@NotNull TemplateState templateState, Template template, int oldIndex, int newIndex) {
            if (!(ApplicationManager.getApplication().isUnitTestMode() || oldIndex == 0 && newIndex == 1 || oldIndex == -1 && newIndex == -1)) {
                return;
            }
            TextResult reference = templateState.getVariableValue(MarkdownIntroduceLinkReferenceAction.VAR_NAME);
            if (reference == null) {
                return;
            }
            this.processDuplicates(reference.getText());
        }

        public void processDuplicates(@NotNull String referenceText) {
            boolean showWarning;
            Object[] duplicatedLinks = PsiTreeUtil.collectElements((PsiElement)this.myFile, element2 -> MarkdownTokenTypeSets.LINKS.contains(PsiUtilCore.getElementType((PsiElement)element2)) && this.myUrl.equals(MarkdownIntroduceLinkReferenceAction.getUrl(element2)) && PsiTreeUtil.findFirstParent((PsiElement)element2, (boolean)true, element1 -> PsiUtilCore.getElementType((PsiElement)element1) == MarkdownElementTypes.INLINE_LINK) == null && PsiTreeUtil.findFirstParent((PsiElement)element2, element1 -> PsiUtilCore.getElementType((PsiElement)element1) == MarkdownElementTypes.FULL_REFERENCE_LINK) == null);
            boolean bl = showWarning = !ContainerUtil.and((Object[])duplicatedLinks, link -> {
                PsiElement[] children2 = link.getChildren();
                return children2.length == 0 && this.myTitleText == null || children2.length == 3 && PsiUtilCore.getElementType((PsiElement)children2[2]) == MarkdownElementTypes.LINK_TITLE && children2[2].getText().equals(this.myTitleText);
            });
            if (duplicatedLinks.length > 0) {
                List duplicates = ContainerUtil.map((Object[])duplicatedLinks, link -> SmartPointerManager.createPointer((PsiElement)link));
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    MarkdownIntroduceLinkReferenceAction.replaceDuplicates((PsiElement)this.myFile, this.myEditor, duplicates, referenceText, showWarning);
                    PsiDocumentManager.getInstance((Project)this.myFile.getProject()).doPostponedOperationsAndUnblockDocument(this.myEditor.getDocument());
                    Document document = this.myEditor.getDocument();
                    document.setText((CharSequence)(document.getText() + "\nTitles Warning: " + showWarning));
                } else {
                    ApplicationManager.getApplication().invokeLater(() -> MarkdownIntroduceLinkReferenceAction.replaceDuplicates((PsiElement)this.myFile, this.myEditor, duplicates, referenceText, showWarning));
                }
            }
        }
    }
}

