/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions.styling;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import kotlin.Pair;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseToggleStateAction
extends ToggleAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(BaseToggleStateAction.class);
    private static final List<IElementType> elementsToIgnore = Arrays.asList(MarkdownElementTypes.LINK_DESTINATION, MarkdownElementTypes.AUTOLINK, MarkdownTokenTypes.GFM_AUTOLINK);

    @NotNull
    protected abstract String getBoundString(@NotNull CharSequence var1, int var2, int var3);

    @Nullable
    protected String getExistingBoundString(@NotNull CharSequence text, int startOffset) {
        return String.valueOf(text.charAt(startOffset));
    }

    protected abstract boolean shouldMoveToWordBounds();

    @NotNull
    protected abstract IElementType getTargetNodeType();

    @NotNull
    protected SelectionState getCommonState(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        return MarkdownActionUtil.getCommonParentOfType(element1, element2, this.getTargetNodeType()) == null ? SelectionState.NO : SelectionState.YES;
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(MarkdownActionUtil.findMarkdownTextEditor(e) != null);
        super.update(e);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Editor editor2 = MarkdownActionUtil.findMarkdownTextEditor(e);
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (editor2 == null || psiFile == null) {
            return false;
        }
        SelectionState lastState = null;
        for (Caret caret : editor2.getCaretModel().getAllCarets()) {
            Pair<PsiElement, PsiElement> elements2 = MarkdownActionUtil.getElementsUnderCaretOrSelection(psiFile, caret);
            SelectionState state = this.getCommonState((PsiElement)elements2.getFirst(), (PsiElement)elements2.getSecond());
            if (lastState == null) {
                lastState = state;
                continue;
            }
            if (lastState == state) continue;
            lastState = SelectionState.INCONSISTENT;
            break;
        }
        if (lastState == SelectionState.INCONSISTENT) {
            e.getPresentation().setEnabled(false);
            return false;
        }
        e.getPresentation().setEnabled(true);
        return lastState == SelectionState.YES;
    }

    public void setSelected(@NotNull AnActionEvent event, boolean state) {
        Editor editor2 = MarkdownActionUtil.findMarkdownTextEditor(event);
        PsiFile file = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (editor2 == null || file == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)file.getProject(), (String)this.getTemplatePresentation().getText(), null, () -> {
            Document document = editor2.getDocument();
            for (Caret caret : ContainerUtil.reverse((List)editor2.getCaretModel().getAllCarets())) {
                this.processCaret(file, editor2, caret, state);
            }
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
        }, (PsiFile[])new PsiFile[0]);
    }

    private void processCaret(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull Caret caret, boolean state) {
        Pair<PsiElement, PsiElement> elements2 = MarkdownActionUtil.getElementsUnderCaretOrSelection(file, caret);
        if (!state) {
            PsiElement parent = MarkdownActionUtil.getCommonParentOfType((PsiElement)elements2.getFirst(), (PsiElement)elements2.getSecond(), this.getTargetNodeType());
            if (parent == null) {
                LOG.warn("Could not find enclosing element on its destruction");
                return;
            }
            TextRange range = parent.getTextRange();
            this.removeEmphFromSelection(editor2.getDocument(), caret, range);
            return;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)((PsiElement)elements2.getFirst()), (PsiElement)((PsiElement)elements2.getSecond()));
        if (!elementsToIgnore.contains(PsiUtilCore.getElementType((PsiElement)parent))) {
            this.addEmphToSelection(editor2.getDocument(), caret);
        }
    }

    public void removeEmphFromSelection(@NotNull Document document, @NotNull Caret caret, @NotNull TextRange nodeRange) {
        CharSequence text = document.getCharsSequence();
        String boundString = this.getExistingBoundString(text, nodeRange.getStartOffset());
        if (boundString == null) {
            LOG.warn("Could not fetch bound string from found node");
            return;
        }
        int boundLength = boundString.length();
        if (nodeRange.getStartOffset() + boundLength == caret.getSelectionStart() && nodeRange.getEndOffset() - boundLength == caret.getSelectionEnd()) {
            document.deleteString(nodeRange.getEndOffset() - boundLength, nodeRange.getEndOffset());
            document.deleteString(nodeRange.getStartOffset(), nodeRange.getStartOffset() + boundLength);
            return;
        }
        int from = caret.getSelectionStart();
        int to = caret.getSelectionEnd();
        if (this.shouldMoveToWordBounds()) {
            while (from - boundLength > nodeRange.getStartOffset() && Character.isWhitespace(text.charAt(from - 1))) {
                --from;
            }
            while (to + boundLength < nodeRange.getEndOffset() && Character.isWhitespace(text.charAt(to))) {
                ++to;
            }
        }
        if (to + boundLength == nodeRange.getEndOffset()) {
            document.deleteString(nodeRange.getEndOffset() - boundLength, nodeRange.getEndOffset());
        } else {
            document.insertString(to, (CharSequence)boundString);
        }
        if (from - boundLength == nodeRange.getStartOffset()) {
            document.deleteString(nodeRange.getStartOffset(), nodeRange.getStartOffset() + boundLength);
        } else {
            document.insertString(from, (CharSequence)boundString);
        }
    }

    public void addEmphToSelection(@NotNull Document document, @NotNull Caret caret) {
        int from;
        int to = caret.getSelectionEnd();
        CharSequence text = document.getCharsSequence();
        if (this.shouldMoveToWordBounds()) {
            for (from = caret.getSelectionStart(); from < to && Character.isWhitespace(text.charAt(from)); ++from) {
            }
            while (to > from && Character.isWhitespace(text.charAt(to - 1))) {
                --to;
            }
            if (from == to) {
                from = caret.getSelectionStart();
                to = caret.getSelectionEnd();
            }
        }
        String boundString = this.getBoundString(text, from, to);
        document.insertString(to, (CharSequence)boundString);
        document.insertString(from, (CharSequence)boundString);
        if (caret.getSelectionStart() == caret.getSelectionEnd()) {
            caret.moveCaretRelatively(boundString.length(), 0, false, false);
        }
    }

    protected static enum SelectionState {
        YES,
        NO,
        INCONSISTENT;

    }
}

