/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtils;
import org.intellij.plugins.markdown.ui.preview.MarkdownEditorWithPreview;
import org.intellij.plugins.markdown.ui.preview.MarkdownPreviewFileEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J\"\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\"\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\"\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J$\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J$\u0010\u001e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000f2\u000e\u0010 \u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000f0!H\u0007\u00a8\u0006\""}, d2={"Lorg/intellij/plugins/markdown/ui/actions/MarkdownActionUtil;", "", "()V", "findMarkdownPreviewEditor", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "findMarkdownTextEditor", "Lcom/intellij/openapi/editor/Editor;", "findMarkdownTextEditorByPsiFile", "findSplitEditor", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownEditorWithPreview;", "editor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getCommonParentOfType", "Lcom/intellij/psi/PsiElement;", "left", "right", "elementType", "Lcom/intellij/psi/tree/IElementType;", "getCommonParentOfTypes", "tokenSet", "Lcom/intellij/psi/tree/TokenSet;", "getCommonTopmostParentOfTypes", "getElementsUnderCaretOrSelection", "Lkotlin/Pair;", "file", "Lcom/intellij/psi/PsiFile;", "caret", "Lcom/intellij/openapi/editor/Caret;", "getTopmostParentOfType", "element", "condition", "Lcom/intellij/openapi/util/Condition;", "intellij.markdown.core"})
public final class MarkdownActionUtil {
    @NotNull
    public static final MarkdownActionUtil INSTANCE;

    @JvmStatic
    @RequiresEdt
    @Nullable
    public static final MarkdownEditorWithPreview findSplitEditor(@NotNull AnActionEvent event) {
        FileEditor editor2 = (FileEditor)event.getData(PlatformCoreDataKeys.FILE_EDITOR);
        return MarkdownActionUtil.findSplitEditor(editor2);
    }

    @JvmStatic
    @RequiresEdt
    @Nullable
    public static final MarkdownEditorWithPreview findSplitEditor(@Nullable FileEditor editor2) {
        MarkdownEditorWithPreview markdownEditorWithPreview;
        FileEditor fileEditor = editor2;
        if (fileEditor instanceof MarkdownEditorWithPreview) {
            markdownEditorWithPreview = (MarkdownEditorWithPreview)editor2;
        } else {
            FileEditor fileEditor2 = editor2;
            markdownEditorWithPreview = fileEditor2 != null ? (MarkdownEditorWithPreview)((Object)fileEditor2.getUserData(MarkdownEditorWithPreview.PARENT_SPLIT_EDITOR_KEY)) : null;
        }
        return markdownEditorWithPreview;
    }

    @JvmStatic
    @RequiresEdt
    @Nullable
    public static final MarkdownPreviewFileEditor findMarkdownPreviewEditor(@NotNull AnActionEvent event) {
        MarkdownEditorWithPreview markdownEditorWithPreview = MarkdownActionUtil.findSplitEditor(event);
        if (markdownEditorWithPreview == null) {
            return null;
        }
        MarkdownEditorWithPreview splitEditor = markdownEditorWithPreview;
        FileEditor editor2 = splitEditor.getPreviewEditor();
        return !(editor2 instanceof MarkdownPreviewFileEditor) || !editor2.getComponent().isVisible() ? null : (MarkdownPreviewFileEditor)editor2;
    }

    @JvmStatic
    @Nullable
    public static final Editor findMarkdownTextEditor(@NotNull AnActionEvent event) {
        MarkdownEditorWithPreview splitEditor = MarkdownActionUtil.findSplitEditor(event);
        if (splitEditor == null) {
            PsiFile psiFile = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
            if (psiFile == null) {
                return null;
            }
            PsiFile psiFile2 = psiFile;
            Language language = psiFile2.getLanguage();
            return Intrinsics.areEqual((Object)language, (Object)((Object)MarkdownLanguage.INSTANCE)) ? (Editor)event.getData(CommonDataKeys.EDITOR) : null;
        }
        TextEditor mainEditor = splitEditor.getTextEditor();
        return !mainEditor.getComponent().isVisible() ? null : mainEditor.getEditor();
    }

    @Nullable
    public final Editor findMarkdownTextEditorByPsiFile(@NotNull AnActionEvent event) {
        PsiFile psiFile = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        return MarkdownLanguageUtils.INSTANCE.isMarkdownLanguage(psiFile2.getLanguage()) ? (Editor)event.getData(CommonDataKeys.EDITOR) : null;
    }

    @JvmStatic
    @NotNull
    public static final Pair<PsiElement, PsiElement> getElementsUnderCaretOrSelection(@NotNull PsiFile file, @NotNull Caret caret) {
        if (caret.getSelectionStart() == caret.getSelectionEnd()) {
            PsiElement element2 = PsiUtilBase.getElementAtOffset((PsiFile)file, (int)caret.getSelectionStart());
            return TuplesKt.to((Object)element2, (Object)element2);
        }
        PsiElement startElement = PsiUtilBase.getElementAtOffset((PsiFile)file, (int)caret.getSelectionStart());
        PsiElement endElement = PsiUtilBase.getElementAtOffset((PsiFile)file, (int)caret.getSelectionEnd());
        return TuplesKt.to((Object)startElement, (Object)endElement);
    }

    @JvmStatic
    @Nullable
    public static final PsiElement getCommonParentOfType(@NotNull PsiElement left, @NotNull PsiElement right, @NotNull IElementType elementType) {
        return MarkdownActionUtil.getCommonParentOfTypes(left, right, TokenSet.create((IElementType[])new IElementType[]{elementType}));
    }

    @JvmStatic
    @Nullable
    public static final PsiElement getCommonTopmostParentOfTypes(@NotNull PsiElement left, @NotNull PsiElement right, @NotNull TokenSet tokenSet) {
        PsiElement base2 = PsiTreeUtil.findCommonParent((PsiElement)left, (PsiElement)right);
        return MarkdownActionUtil.getTopmostParentOfType(base2, (Condition<? super PsiElement>)new Condition(tokenSet){
            final /* synthetic */ TokenSet $tokenSet;

            public final boolean value(PsiElement it) {
                ASTNode node = it.getNode();
                return node != null && this.$tokenSet.contains(node.getElementType());
            }
            {
                this.$tokenSet = tokenSet;
            }
        });
    }

    @JvmStatic
    @Nullable
    public static final PsiElement getTopmostParentOfType(@Nullable PsiElement element2, @NotNull Condition<? super PsiElement> condition) {
        PsiElement answer = PsiTreeUtil.findFirstParent((PsiElement)element2, (boolean)false, condition);
        while (PsiTreeUtil.findFirstParent((PsiElement)answer, (boolean)true, condition) != null) {
            PsiElement next;
            answer = next;
        }
        return answer;
    }

    @JvmStatic
    @Nullable
    public static final PsiElement getCommonParentOfTypes(@NotNull PsiElement left, @NotNull PsiElement right, @NotNull TokenSet tokenSet) {
        PsiElement base2 = PsiTreeUtil.findCommonParent((PsiElement)left, (PsiElement)right);
        return PsiTreeUtil.findFirstParent((PsiElement)base2, (boolean)false, (Condition)new Condition(tokenSet){
            final /* synthetic */ TokenSet $tokenSet;

            public final boolean value(PsiElement it) {
                ASTNode node = it.getNode();
                return node != null && this.$tokenSet.contains(node.getElementType());
            }
            {
                this.$tokenSet = tokenSet;
            }
        });
    }

    private MarkdownActionUtil() {
    }

    static {
        MarkdownActionUtil markdownActionUtil;
        INSTANCE = markdownActionUtil = new MarkdownActionUtil();
    }
}

