/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.structureView;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.structureView.MarkdownStructureElement;
import org.intellij.plugins.markdown.util.MarkdownPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownStructureViewFactory
implements PsiStructureViewFactory {
    @Nullable
    public StructureViewBuilder getStructureViewBuilder(final @NotNull PsiFile psiFile) {
        return new TreeBasedStructureViewBuilder(){

            @NotNull
            public StructureViewModel createStructureViewModel(@Nullable Editor editor2) {
                return new MarkdownStructureViewModel(psiFile, editor2);
            }

            public boolean isRootNodeShown() {
                return false;
            }
        };
    }

    private static class MarkdownStructureViewModel
    extends StructureViewModelBase
    implements StructureViewModel.ElementInfoProvider {
        MarkdownStructureViewModel(@NotNull PsiFile psiFile, @Nullable Editor editor2) {
            super(psiFile, editor2, (StructureViewTreeElement)new MarkdownStructureElement((PsiElement)psiFile));
        }

        @Nullable
        protected Object findAcceptableElement(PsiElement element2) {
            while (element2 != null && !(element2 instanceof PsiFile) && !MarkdownPsiUtil.PRESENTABLE_TYPES.contains(PsiUtilCore.getElementType((PsiElement)element2))) {
                IElementType parentType = PsiUtilCore.getElementType((PsiElement)element2.getParent());
                PsiElement previous = element2.getPrevSibling();
                if (previous == null || !MarkdownPsiUtil.TRANSPARENT_CONTAINERS.contains(parentType)) {
                    element2 = element2.getParent();
                    continue;
                }
                element2 = previous;
            }
            return element2;
        }

        public boolean isAlwaysShowsPlus(StructureViewTreeElement element2) {
            return false;
        }

        public boolean isAlwaysLeaf(StructureViewTreeElement element2) {
            return MarkdownTokenTypeSets.HEADER_LEVEL_6_SET.contains(PsiUtilCore.getElementType((PsiElement)((PsiElement)element2.getValue())));
        }
    }
}

