/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.references;

import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.paths.PathReferenceProviderBase;
import com.intellij.openapi.paths.StaticPathReferenceProvider;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiReferenceWrapper;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDestination;
import org.intellij.plugins.markdown.lang.references.ContentRootRelatedMissingExtensionFileReference;
import org.intellij.plugins.markdown.lang.references.MarkdownAnchorPathReferenceProvider;
import org.jetbrains.annotations.NotNull;

public class MarkdownReferenceProvider
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        PsiElementPattern.Capture linkDestinationCapture = (PsiElementPattern.Capture)PlatformPatterns.psiElement(MarkdownLinkDestination.class).inFile((ElementPattern)PlatformPatterns.psiFile(MarkdownFile.class));
        registrar.registerReferenceProvider((ElementPattern)linkDestinationCapture, (PsiReferenceProvider)new CommonLinkDestinationReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)linkDestinationCapture, (PsiReferenceProvider)new GithubWikiLocalFileReferenceProvider());
    }

    static class GithubWikiLocalFileReferenceProvider
    extends PsiReferenceProvider {
        private static final Pattern LINK_PATTERN = Pattern.compile("^https://github.com/[^/]*/[^/]*/wiki/");
        private static final boolean ARE_REFERENCES_SOFT = false;
        private final MarkdownAnchorPathReferenceProvider myAnchorPathReferenceProvider = new MarkdownAnchorPathReferenceProvider();

        GithubWikiLocalFileReferenceProvider() {
        }

        public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element2, @NotNull ProcessingContext context) {
            String text = element2.getText();
            Matcher matcher = LINK_PATTERN.matcher(text);
            if (matcher.find()) {
                ArrayList<PsiReference> references = new ArrayList<PsiReference>();
                int offsetInElement = matcher.end();
                int lastPos = PathReferenceProviderBase.getLastPosOfURL((int)offsetInElement, (String)text);
                String path = lastPos == -1 ? text.substring(offsetInElement) : text.substring(offsetInElement, lastPos);
                StaticPathReferenceProvider staticProvider = new StaticPathReferenceProvider(null);
                staticProvider.setEndingSlashNotAllowed(true);
                staticProvider.setRelativePathsAllowed(false);
                staticProvider.createReferences(element2, offsetInElement, path, references, false);
                ContentRootRelatedMissingExtensionFileReference.Companion.createReference(element2, references, false);
                this.myAnchorPathReferenceProvider.createReferences(element2, references, false);
                return ContainerUtil.map(references, x$0 -> new GithubWikiLocalFileReferenceWrapper((PsiReference)x$0)).toArray(PsiReference.EMPTY_ARRAY);
            }
            return PsiReference.EMPTY_ARRAY;
        }

        static class GithubWikiLocalFileReferenceWrapper
        extends PsiReferenceWrapper {
            private GithubWikiLocalFileReferenceWrapper(PsiReference originalPsiReference) {
                super(originalPsiReference);
            }
        }
    }

    private static class CommonLinkDestinationReferenceProvider
    extends PsiReferenceProvider {
        private CommonLinkDestinationReferenceProvider() {
        }

        public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element2, @NotNull ProcessingContext context) {
            return PathReferenceManager.getInstance().createReferences(element2, false, true, true, new PathReferenceProvider[0]);
        }
    }
}

