/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.index.MarkdownHeadersIndex;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.intellij.plugins.markdown.lang.references.MarkdownAnchorReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004B)\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0011\u001a\u00020\u0006H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0006H\u0016J\u0013\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016\u00a2\u0006\u0002\u0010\u0019J\u001b\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/intellij/plugins/markdown/lang/references/MarkdownAnchorReferenceImpl;", "Lorg/intellij/plugins/markdown/lang/references/MarkdownAnchorReference;", "Lcom/intellij/psi/PsiPolyVariantReferenceBase;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInsight/daemon/EmptyResolveMessageProvider;", "myAnchor", "", "myFileReference", "Lcom/intellij/psi/PsiReference;", "myPsiElement", "myOffset", "", "(Ljava/lang/String;Lcom/intellij/psi/PsiReference;Lcom/intellij/psi/PsiElement;I)V", "file", "Lcom/intellij/psi/PsiFile;", "getFile", "()Lcom/intellij/psi/PsiFile;", "getCanonicalText", "getElement", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "getUnresolvedMessagePattern", "getVariants", "", "", "()[Ljava/lang/Object;", "multiResolve", "Lcom/intellij/psi/ResolveResult;", "incompleteCode", "", "(Z)[Lcom/intellij/psi/ResolveResult;", "intellij.markdown.core"})
public final class MarkdownAnchorReferenceImpl
extends PsiPolyVariantReferenceBase<PsiElement>
implements MarkdownAnchorReference,
EmptyResolveMessageProvider {
    private final String myAnchor;
    private final PsiReference myFileReference;
    private final PsiElement myPsiElement;
    private final int myOffset;

    private final PsiFile getFile() {
        PsiFile psiFile;
        if (this.myFileReference != null) {
            PsiElement psiElement = this.myFileReference.resolve();
            if (!(psiElement instanceof PsiFile)) {
                psiElement = null;
            }
            psiFile = (PsiFile)psiElement;
        } else {
            psiFile = this.myPsiElement.getContainingFile().getOriginalFile();
        }
        return psiFile;
    }

    @NotNull
    public PsiElement getElement() {
        return this.myPsiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return new TextRange(this.myOffset, this.myOffset + this.myAnchor.length());
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        CharSequence charSequence = this.myAnchor;
        if (charSequence.length() == 0) {
            Object v1;
            PsiElement labelElement;
            block6: {
                Object v0;
                block5: {
                    Sequence $this$firstOrNull$iv = PsiTreeUtilKt.siblings$default((PsiElement)this.myPsiElement, (boolean)false, (boolean)false, (int)2, null);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl = false;
                        if (!PsiUtilsKt.hasType(it, MarkdownElementTypes.LINK_LABEL)) continue;
                        v0 = element$iv;
                        break block5;
                    }
                    v0 = null;
                }
                labelElement = v0;
                Sequence $this$firstOrNull$iv = PsiTreeUtilKt.siblings$default((PsiElement)this.myPsiElement, (boolean)true, (boolean)false, (int)2, null);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!PsiUtilsKt.hasType(it, MarkdownElementTypes.LINK_COMMENT)) continue;
                    v1 = element$iv;
                    break block6;
                }
                v1 = null;
            }
            PsiElement commentElement = v1;
            if (commentElement != null) {
                PsiElement psiElement = labelElement;
                if (Intrinsics.areEqual((Object)(psiElement != null ? psiElement.getText() : null), (Object)"[//]")) {
                    return new ResolveResult[0];
                }
            }
            return PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{this.myPsiElement});
        }
        Project project = this.myPsiElement.getProject();
        return PsiElementResolveResult.createResults(MarkdownAnchorReference.Companion.getPsiHeaders(project, this.getCanonicalText(), this.getFile()));
    }

    @NotNull
    public String getCanonicalText() {
        return this.myAnchor;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Object[] getVariants() {
        Project project = this.myPsiElement.getProject();
        ArrayList list2 = new ArrayList();
        Iterable $this$forEach$iv = StubIndex.getInstance().getAllKeys(MarkdownHeadersIndex.Companion.getKEY(), project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GlobalSearchScope globalSearchScope;
            String key = (String)element$iv;
            boolean bl = false;
            StubIndex stubIndex = StubIndex.getInstance();
            StubIndexKey<String, MarkdownHeader> stubIndexKey = MarkdownHeadersIndex.Companion.getKEY();
            String string = key;
            Project project2 = project;
            if (this.getFile() != null) {
                void it;
                PsiFile psiFile;
                PsiFile psiFile2 = psiFile;
                Project project3 = project2;
                String string2 = string;
                StubIndexKey<String, MarkdownHeader> stubIndexKey2 = stubIndexKey;
                StubIndex stubIndex2 = stubIndex;
                boolean bl2 = false;
                GlobalSearchScope globalSearchScope2 = GlobalSearchScope.fileScope((PsiFile)it);
                stubIndex = stubIndex2;
                stubIndexKey = stubIndexKey2;
                string = string2;
                project2 = project3;
                globalSearchScope = globalSearchScope2;
            } else {
                globalSearchScope = null;
            }
            stubIndex.processElements(stubIndexKey, (Object)string, project2, globalSearchScope, MarkdownHeader.class, new Processor(key, this, project, list2){
                final /* synthetic */ String $key;
                final /* synthetic */ MarkdownAnchorReferenceImpl this$0;
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ ArrayList $list$inlined;
                {
                    this.$key = string;
                    this.this$0 = markdownAnchorReferenceImpl;
                    this.$project$inlined = project;
                    this.$list$inlined = arrayList;
                }

                public final boolean process(MarkdownHeader it) {
                    return this.$list$inlined.add(MarkdownAnchorReference.Companion.dashed(this.$key));
                }
            });
        }
        Collection $this$toTypedArray$iv = list2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        if (objectArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return objectArray;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string;
        PsiFile psiFile = this.getFile();
        if (psiFile == null) {
            string = MarkdownBundle.message("markdown.cannot.resolve.anchor.error.message", this.myAnchor);
        } else {
            Object[] objectArray = new Object[2];
            objectArray[0] = this.myAnchor;
            PsiFile psiFile2 = this.getFile();
            if (psiFile2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiFile");
            }
            objectArray[1] = psiFile2.getName();
            string = MarkdownBundle.message("markdown.cannot.resolve.anchor.in.file.error.message", objectArray);
        }
        return string;
    }

    public MarkdownAnchorReferenceImpl(@NotNull String myAnchor, @Nullable PsiReference myFileReference, @NotNull PsiElement myPsiElement, int myOffset) {
        super(myPsiElement);
        this.myAnchor = myAnchor;
        this.myFileReference = myFileReference;
        this.myPsiElement = myPsiElement;
        this.myOffset = myOffset;
    }
}

