/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCompositePsiElementBase;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownTableRow
extends MarkdownCompositePsiElementBase {
    public MarkdownTableRow(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public String getPresentableTagName() {
        if (this.getNode().getElementType() == MarkdownElementTypes.TABLE_HEADER) {
            return "th";
        }
        return "tr";
    }

    @NotNull
    public @NotNull List<@NotNull MarkdownTableCell> getCells() {
        Object[] cells = (MarkdownTableCell[])PsiTreeUtil.getChildrenOfType((PsiElement)this, MarkdownTableCell.class);
        if (cells == null) {
            return ContainerUtil.emptyList();
        }
        return ContainerUtil.immutableList((Object[])cells);
    }

    @Nullable
    public MarkdownTableCell getCell(int nth) {
        List<MarkdownTableCell> cells = this.getCells();
        if (cells.size() <= nth) {
            return null;
        }
        return cells.get(nth);
    }

    @Nullable
    public MarkdownTable getParentTable() {
        return (MarkdownTable)PsiTreeUtil.getParentOfType((PsiElement)this, MarkdownTable.class);
    }
}

