/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi.impl;

import com.intellij.execution.process.ConsoleHighlighter;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import javax.swing.Icon;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCompositePsiElementBase;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownParagraph;
import org.intellij.plugins.markdown.structureView.MarkdownBasePresentation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownListItem
extends MarkdownCompositePsiElementBase {
    public MarkdownListItem(@NotNull ASTNode node) {
        super(node);
    }

    @Nullable
    public PsiElement getMarkerElement() {
        PsiElement child = this.getFirstChild();
        if (child != null && MarkdownTokenTypeSets.LIST_MARKERS.contains(child.getNode().getElementType())) {
            return child;
        }
        return null;
    }

    @Nullable
    public PsiElement getCheckBox() {
        PsiElement markerElement = this.getMarkerElement();
        if (markerElement == null) {
            return null;
        }
        PsiElement candidate = markerElement.getNextSibling();
        if (candidate != null && candidate.getNode().getElementType() == MarkdownTokenTypes.CHECK_BOX) {
            return candidate;
        }
        return null;
    }

    @Nullable
    private PsiElement getFirstNonMarkerElement() {
        PsiElement marker2 = this.getMarkerElement();
        if (marker2 == null) {
            return null;
        }
        PsiElement next = marker2.getNextSibling();
        if (next != null && PsiUtilCore.getElementType((PsiElement)next) == MarkdownTokenTypes.CHECK_BOX) {
            return next.getNextSibling();
        }
        return next;
    }

    @Nullable
    public String getItemText() {
        PsiElement element2 = this.getFirstNonMarkerElement();
        if (element2 == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        while (element2 != null) {
            builder.append(element2.getText());
            element2 = element2.getNextSibling();
        }
        return builder.toString();
    }

    @Override
    public ItemPresentation getPresentation() {
        return new MyItemPresentation();
    }

    @Override
    public String getPresentableTagName() {
        return "li";
    }

    private class MyItemPresentation
    extends MarkdownBasePresentation
    implements ColoredItemPresentation {
        private MyItemPresentation() {
        }

        @Nullable
        public String getPresentableText() {
            if (!MarkdownListItem.this.isValid()) {
                return null;
            }
            PsiElement markerElement = MarkdownListItem.this.getMarkerElement();
            if (markerElement == null) {
                return null;
            }
            return markerElement.getText().trim();
        }

        @Nullable
        public String getLocationString() {
            if (!MarkdownListItem.this.isValid()) {
                return null;
            }
            if (ContainerUtil.getFirstItem(MarkdownListItem.this.getCompositeChildren()) instanceof MarkdownParagraph) {
                MarkdownCompositePsiElementBase element2 = (MarkdownCompositePsiElementBase)MarkdownListItem.this.findChildByClass(MarkdownCompositePsiElementBase.class);
                assert (element2 != null);
                return StringUtil.shortenTextWithEllipsis((String)element2.getText(), (int)50, (int)0);
            }
            return null;
        }

        @Override
        @Nullable
        public Icon getIcon(boolean unused) {
            return null;
        }

        @Nullable
        public TextAttributesKey getTextAttributesKey() {
            PsiElement checkBox = MarkdownListItem.this.getCheckBox();
            if (checkBox == null) {
                return null;
            }
            if (checkBox.textContains('x') || checkBox.textContains('X')) {
                return ConsoleHighlighter.GREEN;
            }
            return ConsoleHighlighter.RED;
        }
    }
}

