/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi.impl;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElement;
import org.intellij.plugins.markdown.structureView.MarkdownBasePresentation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownLinkDefinition
extends ASTWrapperPsiElement
implements MarkdownPsiElement {
    public MarkdownLinkDefinition(@NotNull ASTNode node) {
        super(node);
    }

    @NotNull
    public PsiElement getLinkLabel() {
        PsiElement label = this.findChildByType(MarkdownElementTypes.LINK_LABEL);
        if (label == null) {
            throw new IllegalStateException("Probably parsing failed. Should have a label");
        }
        return label;
    }

    @NotNull
    public PsiElement getLinkDestination() {
        PsiElement destination = this.findChildByType(MarkdownElementTypes.LINK_DESTINATION);
        if (destination == null) {
            throw new IllegalStateException("Probably parsing failed. Should have a destination");
        }
        return destination;
    }

    @Nullable
    public PsiElement getLinkTitle() {
        return this.findChildByType(MarkdownElementTypes.LINK_TITLE);
    }

    public ItemPresentation getPresentation() {
        return new MarkdownBasePresentation(){

            @Nullable
            public String getPresentableText() {
                if (!MarkdownLinkDefinition.this.isValid()) {
                    return null;
                }
                return "Def: " + MarkdownLinkDefinition.this.getLinkLabel().getText() + " \u2192 " + MarkdownLinkDefinition.this.getLinkDestination().getText();
            }

            @Nullable
            public String getLocationString() {
                if (!MarkdownLinkDefinition.this.isValid()) {
                    return null;
                }
                PsiElement linkTitle = MarkdownLinkDefinition.this.getLinkTitle();
                if (linkTitle == null) {
                    return null;
                }
                return linkTitle.getText();
            }
        };
    }
}

