/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Locale;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.psi.MarkdownElementVisitor;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeaderImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownImage;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownInlineLink;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkText;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.intellij.plugins.markdown.lang.stubs.impl.MarkdownHeaderStubElement;
import org.intellij.plugins.markdown.lang.stubs.impl.MarkdownHeaderStubElementType;
import org.intellij.plugins.markdown.structureView.MarkdownStructureColors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u000bH\u0002J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0007J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\n\u0010\u001c\u001a\u0004\u0018\u00010\u000bH\u0002J\n\u0010\u001d\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J*\u0010 \u001a\u00020\u00132\n\u0010!\u001a\u00060\"j\u0002`#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001b0%2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010&\u001a\u00020\u0013*\u00060\"j\u0002`#2\u0006\u0010'\u001a\u00020(H\u0002R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006*"}, d2={"Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeader;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeaderImpl;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "stub", "Lorg/intellij/plugins/markdown/lang/stubs/impl/MarkdownHeaderStubElement;", "type", "Lorg/intellij/plugins/markdown/lang/stubs/impl/MarkdownHeaderStubElementType;", "(Lorg/intellij/plugins/markdown/lang/stubs/impl/MarkdownHeaderStubElement;Lorg/intellij/plugins/markdown/lang/stubs/impl/MarkdownHeaderStubElementType;)V", "anchorText", "", "getAnchorText", "()Ljava/lang/String;", "level", "", "getLevel", "()I", "accept", "", "visitor", "Lcom/intellij/psi/PsiElementVisitor;", "buildAnchorText", "buildVisibleText", "hideImages", "", "findContentHolder", "Lcom/intellij/psi/PsiElement;", "getHeaderText", "getName", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "traverseNameText", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "elements", "Lkotlin/sequences/Sequence;", "processInlineLink", "element", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownInlineLink;", "Companion", "intellij.markdown.core"})
public final class MarkdownHeader
extends MarkdownHeaderImpl {
    private static final Regex garbageRegex;
    @NotNull
    public static final Companion Companion;

    public final int getLevel() {
        return this.calculateHeaderLevel();
    }

    @Nullable
    public final String getAnchorText() {
        return this.buildAnchorText();
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        PsiElementVisitor psiElementVisitor = visitor;
        if (psiElementVisitor instanceof MarkdownElementVisitor) {
            ((MarkdownElementVisitor)visitor).visitHeader(this);
        } else {
            super.accept(visitor);
        }
    }

    @NotNull
    public ItemPresentation getPresentation() {
        String headerText = this.getHeaderText();
        Object object = headerText;
        if (object == null) {
            object = "Invalid header: " + this.getText();
        }
        String text = object;
        return (ItemPresentation)new ColoredItemPresentation(this, text){
            final /* synthetic */ MarkdownHeader this$0;
            final /* synthetic */ String $text;

            @NotNull
            public String getPresentableText() {
                PsiElement prevSibling = this.this$0.getPrevSibling();
                if (Registry.is((String)"markdown.structure.view.list.visibility") && MarkdownTokenTypeSets.LIST_MARKERS.contains(PsiTreeUtilKt.getElementType((PsiElement)prevSibling))) {
                    return prevSibling.getText() + this.$text;
                }
                return this.$text;
            }

            @Nullable
            public Icon getIcon(boolean open) {
                return null;
            }

            @Nullable
            public TextAttributesKey getTextAttributesKey() {
                TextAttributesKey textAttributesKey;
                switch (this.this$0.getLevel()) {
                    case 1: {
                        textAttributesKey = MarkdownStructureColors.MARKDOWN_HEADER_BOLD;
                        break;
                    }
                    default: {
                        textAttributesKey = MarkdownStructureColors.MARKDOWN_HEADER;
                    }
                }
                return textAttributesKey;
            }
            {
                this.this$0 = this$0;
                this.$text = $captured_local_variable$1;
            }
        };
    }

    @Nullable
    public String getName() {
        return this.getHeaderText();
    }

    private final PsiElement findContentHolder() {
        return this.findChildByType(MarkdownTokenTypeSets.INLINE_HOLDING_ELEMENT_TYPES);
    }

    private final String getHeaderText() {
        if (!this.isValid()) {
            return null;
        }
        PsiElement psiElement = this.findContentHolder();
        if (psiElement == null) {
            return null;
        }
        PsiElement contentHolder = psiElement;
        return StringUtil.trim((String)contentHolder.getText());
    }

    @ApiStatus.Experimental
    @Nullable
    public final String buildVisibleText(boolean hideImages) {
        PsiElement psiElement = this.findContentHolder();
        if (psiElement == null) {
            return null;
        }
        PsiElement contentHolder = psiElement;
        StringBuilder builder = new StringBuilder();
        Sequence children2 = SequencesKt.dropWhile(PsiUtilsKt.children(contentHolder), (Function1)buildVisibleText.children.1.INSTANCE);
        this.traverseNameText(builder, (Sequence<? extends PsiElement>)children2, hideImages);
        return StringsKt.trim((String)builder.toString(), (char[])new char[]{' '});
    }

    public static /* synthetic */ String buildVisibleText$default(MarkdownHeader markdownHeader, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return markdownHeader.buildVisibleText(bl);
    }

    private final void traverseNameText(StringBuilder builder, Sequence<? extends PsiElement> elements2, boolean hideImages) {
        for (PsiElement child : elements2) {
            PsiElement psiElement = child;
            if (psiElement instanceof LeafPsiElement) {
                builder.append(((LeafPsiElement)child).getText());
                continue;
            }
            if (psiElement instanceof MarkdownInlineLink) {
                MarkdownLinkText markdownLinkText = ((MarkdownInlineLink)child).getLinkText();
                Object object = markdownLinkText != null ? markdownLinkText.getContentElements() : null;
                Sequence sequence = object;
                if (sequence == null) {
                    sequence = SequencesKt.emptySequence();
                }
                this.traverseNameText(builder, (Sequence<? extends PsiElement>)sequence, hideImages);
                continue;
            }
            if (psiElement instanceof MarkdownImage) {
                if (hideImages) continue;
                builder.append(((MarkdownImage)child).getText());
                continue;
            }
            this.traverseNameText(builder, PsiUtilsKt.children(child), hideImages);
        }
    }

    private final String buildAnchorText() {
        PsiElement psiElement = this.findContentHolder();
        if (psiElement == null) {
            return null;
        }
        PsiElement contentHolder = psiElement;
        Sequence children2 = SequencesKt.filter(PsiUtilsKt.children(contentHolder), (Function1)buildAnchorText.children.1.INSTANCE);
        CharSequence charSequence = new StringBuilder();
        StringBuilder $this$buildString = charSequence;
        boolean bl = false;
        $this$buildString.append("#");
        int count = 0;
        for (PsiElement child : children2) {
            PsiElement psiElement2;
            if (count >= 1) {
                $this$buildString.append(" ");
            }
            if ((psiElement2 = child) instanceof MarkdownImage) {
                $this$buildString.append("");
            } else if (psiElement2 instanceof MarkdownInlineLink) {
                this.processInlineLink($this$buildString, (MarkdownInlineLink)child);
            } else {
                $this$buildString.append(child.getText());
            }
            ++count;
        }
        String string = ((StringBuilder)charSequence).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String text = string;
        charSequence = text;
        String string2 = ((String)charSequence).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        charSequence = string2;
        Regex regex = garbageRegex;
        String string3 = "";
        return StringsKt.replace$default((String)regex.replace(charSequence, string3), (String)" ", (String)"-", (boolean)false, (int)4, null);
    }

    private final void processInlineLink(StringBuilder $this$processInlineLink, MarkdownInlineLink element2) {
        MarkdownLinkText markdownLinkText = element2.getLinkText();
        Object object = markdownLinkText != null ? markdownLinkText.getContentElements() : null;
        Sequence sequence = object;
        if (sequence == null) {
            sequence = SequencesKt.emptySequence();
        }
        Sequence contentElements2 = sequence;
        Sequence withoutWhitespaces2 = SequencesKt.filterNot((Sequence)contentElements2, (Function1)processInlineLink.withoutWhitespaces.1.INSTANCE);
        SequencesKt.joinTo$default((Sequence)withoutWhitespaces2, (Appendable)$this$processInlineLink, (CharSequence)" ", null, null, (int)0, null, (Function1)processInlineLink.1.INSTANCE, (int)60, null);
    }

    public MarkdownHeader(@NotNull ASTNode node) {
        super(node);
    }

    public MarkdownHeader(@NotNull MarkdownHeaderStubElement stub, @NotNull MarkdownHeaderStubElementType type) {
        super(stub, type);
    }

    static {
        Companion = new Companion(null);
        garbageRegex = new Regex("[^#\\w\\- ]");
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeader$Companion;", "", "()V", "garbageRegex", "Lkotlin/text/Regex;", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

