/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.intellij.plugins.markdown.editor.images.ImageUtils;
import org.intellij.plugins.markdown.editor.images.MarkdownImageData;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElement;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDefinition;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownList;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownParagraph;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRow;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MarkdownPsiElementFactory {
    private MarkdownPsiElementFactory() {
    }

    @NotNull
    public static MarkdownFile createFile(@NotNull Project project, @NotNull String text) {
        LightVirtualFile virtualFile = new LightVirtualFile("temp.rb", (Language)MarkdownLanguage.INSTANCE, (CharSequence)text);
        PsiFile psiFile = ((PsiFileFactoryImpl)PsiFileFactory.getInstance((Project)project)).trySetupPsiForFile(virtualFile, (Language)MarkdownLanguage.INSTANCE, true, true);
        if (!(psiFile instanceof MarkdownFile)) {
            throw new RuntimeException("Cannot create a new markdown file. Text: " + text);
        }
        return (MarkdownFile)psiFile;
    }

    @NotNull
    public static MarkdownCodeFence createCodeFence(@NotNull Project project, @Nullable String language, @NotNull String text) {
        return MarkdownPsiElementFactory.createCodeFence(project, language, text, null);
    }

    @NotNull
    public static MarkdownCodeFence createCodeFence(@NotNull Project project, @Nullable String language, @NotNull String text, @Nullable String indent) {
        text = StringUtil.isEmpty((String)text) ? "" : "\n" + (String)text;
        String content2 = "```" + StringUtil.notNullize((String)language) + (String)text + "\n" + StringUtil.notNullize((String)indent) + "```";
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, content2);
        return (MarkdownCodeFence)file.getFirstChild().getFirstChild();
    }

    @NotNull
    public static PsiElement createImage(@NotNull Project project, @Nullable String description, @NotNull String path, @Nullable String title) {
        String text = ImageUtils.createMarkdownImageText(Objects.requireNonNullElse(description, ""), path, Objects.requireNonNullElse(title, ""));
        return MarkdownPsiElementFactory.createFile(project, text).getFirstChild().getFirstChild().getFirstChild();
    }

    @NotNull
    public static PsiElement createHtmlBlockWithImage(@NotNull Project project, @NotNull MarkdownImageData imageData) {
        String text = ImageUtils.createHtmlImageText(imageData);
        return MarkdownPsiElementFactory.createFile(project, text).getFirstChild().getFirstChild();
    }

    @NotNull
    public static PsiElement createHtmlImageTag(@NotNull Project project, @NotNull MarkdownImageData imageData) {
        String text = ImageUtils.createHtmlImageText(imageData);
        PsiElement root = MarkdownPsiElementFactory.createFile(project, "Prefix text" + text).getFirstChild();
        return root.getFirstChild().getFirstChild().getNextSibling();
    }

    @NotNull
    public static MarkdownPsiElement createTextElement(@NotNull Project project, @NotNull String text) {
        return (MarkdownPsiElement)MarkdownPsiElementFactory.createFile(project, text).getFirstChild().getFirstChild();
    }

    @NotNull
    public static MarkdownHeader createSetext(@NotNull Project project, @NotNull String text, @NotNull String symbol, int count) {
        return (MarkdownHeader)MarkdownPsiElementFactory.createFile(project, text + "\n" + StringUtil.repeat((String)symbol, (int)count)).getFirstChild().getFirstChild();
    }

    @NotNull
    public static MarkdownHeader createHeader(@NotNull Project project, @NotNull String text, int level) {
        return (MarkdownHeader)MarkdownPsiElementFactory.createFile(project, StringUtil.repeat((String)"#", (int)level) + " " + text).getFirstChild().getFirstChild();
    }

    @NotNull
    public static PsiElement createNewLine(@NotNull Project project) {
        return MarkdownPsiElementFactory.createFile(project, "\n").getFirstChild().getFirstChild();
    }

    @NotNull
    public static PsiElement createNewLines(@NotNull Project project, int num) {
        return MarkdownPsiElementFactory.createFile(project, StringUtil.repeat((String)"\n", (int)num)).getFirstChild();
    }

    @NotNull
    public static Pair<PsiElement, PsiElement> createLinkDeclarationAndReference(@NotNull Project project, @NotNull String url, @NotNull String text, @Nullable String title, @NotNull String reference) {
        text = (String)ObjectUtils.notNull((Object)text, (Object)reference);
        title = title == null ? "" : " " + (String)title;
        String linkReference = "[" + text + "][" + reference + "]\n\n[" + reference + "]: " + url + (String)title;
        PsiElement linkReferenceElement = MarkdownPsiElementFactory.createFile(project, linkReference).getFirstChild();
        PsiElement ref = linkReferenceElement.getFirstChild();
        assert (ref instanceof MarkdownParagraph);
        PsiElement declaration = linkReferenceElement.getLastChild();
        assert (declaration instanceof MarkdownParagraph || declaration instanceof MarkdownLinkDefinition);
        return Pair.create((Object)ref, (Object)declaration);
    }

    @ApiStatus.Experimental
    @NotNull
    public static MarkdownTableSeparatorRow createTableSeparatorRow(@NotNull Project project, @NotNull String text) {
        int columnsCount2 = StringUtil.countChars((CharSequence)text, (char)'|') - 1;
        if (columnsCount2 < 1) {
            throw new IllegalArgumentException("Passed separator text should be valid and contain at least one column.\n Text passed: [" + text + "]");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("|");
        for (int column = 0; column < columnsCount2; ++column) {
            builder.append("    |");
        }
        builder.append('\n');
        builder.append(text);
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, builder.toString());
        PsiElement table = Objects.requireNonNull(file.findElementAt(0)).getParent().getParent();
        return Objects.requireNonNull((MarkdownTableSeparatorRow)PsiTreeUtil.getChildOfType((PsiElement)table, MarkdownTableSeparatorRow.class));
    }

    @ApiStatus.Experimental
    @NotNull
    public static Pair<MarkdownTableCell, PsiElement> createTableCell(@NotNull Project project, @NotNull String text) {
        String content2 = "|" + text + "|\n|----|";
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, content2);
        PsiElement contentElement = file.findElementAt(1);
        MarkdownTableCell cell = Objects.requireNonNull((MarkdownTableCell)PsiTreeUtil.getParentOfType((PsiElement)contentElement, MarkdownTableCell.class));
        PsiElement separator = cell.getNextSibling();
        return new Pair((Object)cell, (Object)separator);
    }

    @NotNull
    private static MarkdownTable findTable(@NotNull PsiElement element2) {
        return Objects.requireNonNull((MarkdownTable)PsiTreeUtil.getParentOfType((PsiElement)element2, MarkdownTable.class));
    }

    @ApiStatus.Experimental
    @NotNull
    public static PsiElement createTableSeparator(@NotNull Project project) {
        String content2 = "|    |\n|----|";
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, "|    |\n|----|");
        return Objects.requireNonNull(file.findElementAt(0));
    }

    @ApiStatus.Experimental
    @NotNull
    public static MarkdownTableRow createTableRow(@NotNull Project project, @NotNull Collection<String> contents2) {
        int count;
        StringBuilder builder = new StringBuilder();
        builder.append('|');
        for (count = 0; count < contents2.size(); ++count) {
            builder.append("     |");
        }
        builder.append('\n');
        builder.append('|');
        for (count = 0; count < contents2.size(); ++count) {
            builder.append("-----|");
        }
        builder.append('\n');
        builder.append('|');
        for (String content2 : contents2) {
            builder.append(content2);
            builder.append('|');
        }
        builder.append('\n');
        builder.append('|');
        for (int count2 = 0; count2 < contents2.size(); ++count2) {
            builder.append("     |");
        }
        builder.append('\n');
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, builder.toString());
        PsiElement element2 = Objects.requireNonNull(file.findElementAt(0));
        PsiElement row = Objects.requireNonNull(MarkdownPsiElementFactory.findTable(element2).getLastChild().getPrevSibling().getPrevSibling());
        if (row instanceof MarkdownTableRow) {
            return (MarkdownTableRow)row;
        }
        throw new IllegalStateException("Failed to find row element");
    }

    @ApiStatus.Experimental
    @NotNull
    public static MarkdownTableRow createTableEmptyRow(@NotNull Project project, @NotNull Collection<Integer> widths) {
        List contents2 = ContainerUtil.map(widths, width -> " ".repeat((int)width));
        return MarkdownPsiElementFactory.createTableRow(project, contents2);
    }

    @ApiStatus.Experimental
    @NotNull
    public static PsiElement createBlockQuoteArrow(@NotNull Project project) {
        String contents2 = "> ";
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, "> ");
        return Objects.requireNonNull(file.findElementAt(1));
    }

    @ApiStatus.Experimental
    @NotNull
    public static MarkdownHeader createHeader(@NotNull Project project, int level, @NotNull String text) {
        String contents2 = StringUtil.repeat((String)"#", (int)level) + " " + text;
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, contents2);
        PsiElement element2 = Objects.requireNonNull(file.getFirstChild().getFirstChild());
        assert (element2 instanceof MarkdownHeader);
        return (MarkdownHeader)element2;
    }

    @ApiStatus.Experimental
    @NotNull
    public static PsiElement createListMarker(@NotNull Project project, @NotNull String markerText) {
        String contents2 = markerText + " list item";
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, contents2);
        return Objects.requireNonNull(file.getFirstChild().getFirstChild().getFirstChild().getFirstChild());
    }

    @ApiStatus.Experimental
    @NotNull
    public static Pair<PsiElement, PsiElement> createListMarkerWithCheckbox(@NotNull Project project, @NotNull String markerText, boolean checked) {
        Object text = markerText;
        text = checked ? (String)text + " [x]" : (String)text + " [ ]";
        PsiElement marker2 = MarkdownPsiElementFactory.createListMarker(project, (String)text);
        PsiElement checkbox = Objects.requireNonNull(marker2.getNextSibling());
        return new Pair((Object)marker2, (Object)checkbox);
    }

    @ApiStatus.Experimental
    @NotNull
    public static MarkdownList createEmptyList(@NotNull Project project, boolean ordered) {
        String contents2 = ordered ? "1) list item" : "* list item";
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, contents2);
        PsiElement list2 = Objects.requireNonNull(file.getFirstChild().getFirstChild());
        assert (list2 instanceof MarkdownList);
        for (PsiElement child : list2.getChildren()) {
            child.delete();
        }
        return (MarkdownList)list2;
    }

    @ApiStatus.Experimental
    @NotNull
    public static MarkdownList createList(@NotNull Project project, @NotNull @NotNull Iterable<@NotNull String> items, @NotNull Function<? super Integer, String> markerSupplier) {
        StringBuilder builder = new StringBuilder();
        int itemIndex = 0;
        for (String item : items) {
            builder.append(markerSupplier.apply((Integer)itemIndex));
            builder.append(" ");
            builder.append(item);
            builder.append("\n");
            ++itemIndex;
        }
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, builder.toString());
        PsiElement list2 = Objects.requireNonNull(file.getFirstChild().getFirstChild());
        assert (list2 instanceof MarkdownList);
        return (MarkdownList)list2;
    }
}

