/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.parser;

import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import java.util.concurrent.atomic.AtomicReference;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.parser.MarkdownParser;
import org.intellij.plugins.markdown.extensions.CodeFencePluginFlavourDescriptor;
import org.intellij.plugins.markdown.lang.parser.GFMCommentAwareFlavourDescriptor;
import org.jetbrains.annotations.NotNull;

public final class MarkdownParserManager {
    public static final Key<MarkdownFlavourDescriptor> FLAVOUR_DESCRIPTION = Key.create((String)"Markdown.Flavour");
    public static final GFMCommentAwareFlavourDescriptor FLAVOUR = new GFMCommentAwareFlavourDescriptor();
    public static final CodeFencePluginFlavourDescriptor CODE_FENCE_PLUGIN_FLAVOUR = new CodeFencePluginFlavourDescriptor();
    private static final AtomicReference<ParsingInfo> ourLastParsingResult = new AtomicReference();

    public static ASTNode parseContent(@NotNull CharSequence buffer) {
        return MarkdownParserManager.parseContent(buffer, (MarkdownFlavourDescriptor)FLAVOUR);
    }

    public static ASTNode parseContent(@NotNull CharSequence buffer, @NotNull MarkdownFlavourDescriptor flavour) {
        ParsingInfo info = ourLastParsingResult.get();
        if (info != null && info.myBufferHash == buffer.hashCode() && info.myBuffer.equals(buffer)) {
            return info.myParseResult;
        }
        ASTNode parseResult = new MarkdownParser(flavour).parse(MarkdownElementTypes.MARKDOWN_FILE, buffer.toString(), false);
        ourLastParsingResult.set(new ParsingInfo(buffer, parseResult));
        return parseResult;
    }

    static {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                ourLastParsingResult.set(null);
            }
        });
    }

    private static class ParsingInfo {
        @NotNull
        final CharSequence myBuffer;
        final int myBufferHash;
        @NotNull
        final ASTNode myParseResult;

        ParsingInfo(@NotNull CharSequence buffer, @NotNull ASTNode parseResult) {
            this.myBuffer = buffer;
            this.myBufferHash = this.myBuffer.hashCode();
            this.myParseResult = parseResult;
        }
    }
}

