/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.lexer;

import com.intellij.lexer.LexerBase;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeKt;
import org.intellij.markdown.ast.visitors.RecursiveVisitor;
import org.intellij.markdown.ast.visitors.Visitor;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.plugins.markdown.lang.MarkdownElementType;
import org.intellij.plugins.markdown.lang.parser.MarkdownParserManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownToplevelLexer
extends LexerBase {
    private CharSequence myBuffer;
    private int myBufferStart;
    private int myBufferEnd;
    private List<IElementType> myLexemes;
    private List<Integer> myStartOffsets;
    private List<Integer> myEndOffsets;
    private int myLexemeIndex;
    @NotNull
    final MarkdownFlavourDescriptor myFlavour;

    public MarkdownToplevelLexer() {
        this((MarkdownFlavourDescriptor)MarkdownParserManager.FLAVOUR);
    }

    public MarkdownToplevelLexer(@NotNull MarkdownFlavourDescriptor flavour) {
        this.myFlavour = flavour;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.myBuffer = buffer;
        this.myBufferStart = startOffset;
        this.myBufferEnd = endOffset;
        ASTNode parsedTree = MarkdownParserManager.parseContent(buffer.subSequence(startOffset, endOffset), this.myFlavour);
        this.myLexemes = new ArrayList<IElementType>();
        this.myStartOffsets = new ArrayList<Integer>();
        this.myEndOffsets = new ArrayList<Integer>();
        ASTNodeKt.accept((ASTNode)parsedTree, (Visitor)new LexerBuildingVisitor());
        this.myLexemeIndex = 0;
    }

    public int getState() {
        return this.myLexemeIndex;
    }

    @Nullable
    public IElementType getTokenType() {
        if (this.myLexemeIndex >= this.myLexemes.size()) {
            return null;
        }
        return this.myLexemes.get(this.myLexemeIndex);
    }

    public int getTokenStart() {
        if (this.myLexemeIndex >= this.myLexemes.size()) {
            return this.myBufferEnd;
        }
        return this.myBufferStart + this.myStartOffsets.get(this.myLexemeIndex);
    }

    public int getTokenEnd() {
        if (this.myLexemeIndex >= this.myLexemes.size()) {
            return this.myBufferEnd;
        }
        return this.myBufferStart + this.myEndOffsets.get(this.myLexemeIndex);
    }

    public void advance() {
        ++this.myLexemeIndex;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        return this.myBuffer;
    }

    public int getBufferEnd() {
        return this.myBufferEnd;
    }

    private class LexerBuildingVisitor
    extends RecursiveVisitor {
        private LexerBuildingVisitor() {
        }

        public void visitNode(@NotNull ASTNode node) {
            if (node.getStartOffset() == node.getEndOffset()) {
                return;
            }
            List children2 = node.getChildren();
            if (children2.isEmpty()) {
                MarkdownToplevelLexer.this.myLexemes.add(MarkdownElementType.platformType(node.getType()));
                MarkdownToplevelLexer.this.myStartOffsets.add(node.getStartOffset());
                MarkdownToplevelLexer.this.myEndOffsets.add(node.getEndOffset());
            } else {
                super.visitNode(node);
            }
        }
    }
}

