/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.formatter.blocks.special;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.formatter.blocks.MarkdownBlocks;
import org.intellij.plugins.markdown.lang.formatter.blocks.MarkdownFormattingBlock;
import org.intellij.plugins.markdown.lang.formatter.blocks.special.MarkdownRangedFormattingBlock;
import org.intellij.plugins.markdown.lang.formatter.settings.MarkdownCustomCodeStyleSettings;
import org.intellij.plugins.markdown.lang.psi.util.AstUtilsKt;
import org.intellij.plugins.markdown.util.MarkdownTextUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0014R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lorg/intellij/plugins/markdown/lang/formatter/blocks/special/MarkdownWrappingFormattingBlock;", "Lorg/intellij/plugins/markdown/lang/formatter/blocks/MarkdownFormattingBlock;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "spacing", "Lcom/intellij/formatting/SpacingBuilder;", "node", "Lcom/intellij/lang/ASTNode;", "alignment", "Lcom/intellij/formatting/Alignment;", "wrap", "Lcom/intellij/formatting/Wrap;", "(Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lcom/intellij/formatting/SpacingBuilder;Lcom/intellij/lang/ASTNode;Lcom/intellij/formatting/Alignment;Lcom/intellij/formatting/Wrap;)V", "newlines", "", "getNewlines", "()I", "buildChildren", "", "Lcom/intellij/formatting/Block;", "intellij.markdown.core"})
public final class MarkdownWrappingFormattingBlock
extends MarkdownFormattingBlock {
    /*
     * WARNING - void declaration
     */
    public final int getNewlines() {
        void var3_3;
        CharSequence $this$count$iv = this.getNode().getText();
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        return (int)var3_3;
    }

    @Override
    @NotNull
    protected List<Block> buildChildren() {
        MarkdownCustomCodeStyleSettings customSettings = this.obtainCustomSettings();
        WrapType wrapType = customSettings.WRAP_TEXT_IF_LONG ? WrapType.NORMAL : WrapType.NONE;
        Wrap wrapping = Wrap.createWrap((WrapType)wrapType, (boolean)false);
        Sequence<ASTNode> filtered = MarkdownBlocks.INSTANCE.filterFromWhitespaces(AstUtilsKt.children(this.getNode()));
        ArrayList<MarkdownFormattingBlock> result2 = new ArrayList<MarkdownFormattingBlock>();
        for (ASTNode node : filtered) {
            IElementType iElementType = node.getElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.TEXT)) {
                Sequence<TextRange> splits = MarkdownTextUtil.INSTANCE.getSplitBySpacesRanges(node.getText(), node.getTextRange().getStartOffset());
                for (TextRange split : splits) {
                    result2.add(new MarkdownRangedFormattingBlock(node, split, this.getSettings(), this.getSpacing(), this.getAlignment(), wrapping));
                }
                continue;
            }
            result2.add(MarkdownBlocks.INSTANCE.create(node, this.getSettings(), this.getSpacing(), (Function1<? super ASTNode, ? extends Alignment>)((Function1)new Function1<ASTNode, Alignment>(this){
                final /* synthetic */ MarkdownWrappingFormattingBlock this$0;

                @Nullable
                public final Alignment invoke(@NotNull ASTNode it) {
                    return this.this$0.getAlignment();
                }
                {
                    this.this$0 = markdownWrappingFormattingBlock;
                    super(1);
                }
            })));
        }
        return result2;
    }

    public MarkdownWrappingFormattingBlock(@NotNull CodeStyleSettings settings, @NotNull SpacingBuilder spacing, @NotNull ASTNode node, @Nullable Alignment alignment, @Nullable Wrap wrap) {
        super(node, settings, spacing, alignment, wrap);
    }

    public /* synthetic */ MarkdownWrappingFormattingBlock(CodeStyleSettings codeStyleSettings, SpacingBuilder spacingBuilder, ASTNode aSTNode, Alignment alignment, Wrap wrap, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            alignment = null;
        }
        if ((n & 0x10) != 0) {
            wrap = null;
        }
        this(codeStyleSettings, spacingBuilder, aSTNode, alignment, wrap);
    }
}

