/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.formatter;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.formatter.BlockQuotePostFormatProcessor$processText$;
import org.intellij.plugins.markdown.lang.formatter.settings.MarkdownCustomCodeStyleSettings;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElementFactory;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownBlockQuote;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownParagraph;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.intellij.plugins.markdown.util.MarkdownPsiUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u001b"}, d2={"Lorg/intellij/plugins/markdown/lang/formatter/BlockQuotePostFormatProcessor;", "Lcom/intellij/psi/impl/source/codeStyle/PostFormatProcessor;", "()V", "commit", "", "element", "Lcom/intellij/psi/PsiElement;", "processBlockQuote", "blockQuote", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownBlockQuote;", "level", "", "processElement", "source", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "processParagraph", "paragraph", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownParagraph;", "processText", "Lcom/intellij/openapi/util/TextRange;", "Lcom/intellij/psi/PsiFile;", "rangeToReformat", "shouldProcess", "", "file", "shouldProcessTextElement", "intellij.markdown.core"})
public final class BlockQuotePostFormatProcessor
implements PostFormatProcessor {
    @NotNull
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        if (this.shouldProcess(source.getContainingFile(), settings) && source instanceof MarkdownBlockQuote) {
            this.commit(source);
            BlockQuotePostFormatProcessor.processBlockQuote$default(this, (MarkdownBlockQuote)source, 0, 2, null);
        }
        return source;
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        if (!this.shouldProcess(source, settings)) {
            return rangeToReformat;
        }
        this.commit((PsiElement)source);
        PsiElement psiElement = source.getFirstChild();
        if (psiElement == null || (psiElement = psiElement.getFirstChild()) == null) {
            return rangeToReformat;
        }
        PsiElement firstChild = psiElement;
        Sequence $this$filterIsInstance$iv = PsiTreeUtilKt.siblings((PsiElement)firstChild, (boolean)true, (boolean)true);
        boolean $i$f$filterIsInstance = false;
        Sequence quotes = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)processText$$inlined$filterIsInstance$1.INSTANCE);
        for (MarkdownBlockQuote quote : quotes) {
            if (!rangeToReformat.intersects(rangeToReformat)) continue;
            BlockQuotePostFormatProcessor.processBlockQuote$default(this, quote, 0, 2, null);
        }
        return rangeToReformat;
    }

    private final boolean shouldProcess(PsiFile file, CodeStyleSettings settings) {
        if (Intrinsics.areEqual((Object)file.getLanguage(), (Object)((Object)MarkdownLanguage.INSTANCE)) ^ true || !(file instanceof MarkdownFile)) {
            return false;
        }
        MarkdownCustomCodeStyleSettings custom = (MarkdownCustomCodeStyleSettings)settings.getCustomSettings(MarkdownCustomCodeStyleSettings.class);
        return custom.INSERT_QUOTE_ARROWS_ON_WRAP;
    }

    private final void processParagraph(MarkdownParagraph paragraph, int level) {
        PsiElement psiElement = paragraph.getFirstChild();
        if (psiElement == null) {
            return;
        }
        PsiElement firstChild = psiElement;
        Sequence elements2 = SequencesKt.filter((Sequence)PsiTreeUtilKt.siblings((PsiElement)firstChild, (boolean)true, (boolean)true), (Function1)((Function1)new Function1<PsiElement, Boolean>(this){

            public final boolean invoke(@NotNull PsiElement p1) {
                return BlockQuotePostFormatProcessor.access$shouldProcessTextElement((BlockQuotePostFormatProcessor)this.receiver, p1);
            }
        }));
        for (PsiElement element2 : elements2) {
            int n = 0;
            while (n < level) {
                int it = n++;
                boolean bl = false;
                PsiElement arrow = MarkdownPsiElementFactory.createBlockQuoteArrow(paragraph.getProject());
                paragraph.addBefore(arrow, element2);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldProcessTextElement(PsiElement element2) {
        if (!PsiUtilsKt.hasType(element2, MarkdownTokenTypes.TEXT)) return false;
        PsiElement psiElement = element2.getPrevSibling();
        if (psiElement == null) return false;
        PsiElement psiElement2 = psiElement;
        MarkdownPsiUtil.WhiteSpaces whiteSpaces = MarkdownPsiUtil.WhiteSpaces.INSTANCE;
        PsiElement p1 = psiElement2;
        boolean bl = false;
        if (!MarkdownPsiUtil.WhiteSpaces.isNewLine(p1)) return false;
        return true;
    }

    private final void processBlockQuote(MarkdownBlockQuote blockQuote, int level) {
        PsiElement psiElement = blockQuote.getFirstChild();
        if (psiElement == null) {
            return;
        }
        PsiElement firstChild = psiElement;
        Sequence children2 = PsiTreeUtilKt.siblings((PsiElement)firstChild, (boolean)true, (boolean)true);
        for (PsiElement element2 : children2) {
            PsiElement psiElement2 = element2;
            if (psiElement2 instanceof MarkdownParagraph) {
                this.processParagraph((MarkdownParagraph)element2, level);
                continue;
            }
            if (!(psiElement2 instanceof MarkdownBlockQuote)) continue;
            this.processBlockQuote((MarkdownBlockQuote)element2, level + 1);
        }
    }

    static /* synthetic */ void processBlockQuote$default(BlockQuotePostFormatProcessor blockQuotePostFormatProcessor, MarkdownBlockQuote markdownBlockQuote, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        blockQuotePostFormatProcessor.processBlockQuote(markdownBlockQuote, n);
    }

    private final void commit(PsiElement element2) {
        FileViewProvider viewProvider;
        FileViewProvider fileViewProvider;
        Object object;
        PsiElement psiElement = element2;
        if (psiElement instanceof PsiFile) {
            object = ((PsiFile)element2).getViewProvider();
        } else {
            PsiFile psiFile = element2.getContainingFile();
            object = psiFile != null ? psiFile.getViewProvider() : null;
        }
        if ((fileViewProvider = (viewProvider = object)) == null || (fileViewProvider = fileViewProvider.getDocument()) == null) {
            return;
        }
        FileViewProvider document = fileViewProvider;
        PsiDocumentManager.getInstance((Project)element2.getProject()).commitDocument((Document)document);
    }

    public static final /* synthetic */ boolean access$shouldProcessTextElement(BlockQuotePostFormatProcessor $this, PsiElement element2) {
        return $this.shouldProcessTextElement(element2);
    }
}

