/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.parser.MarkdownParser;
import org.intellij.plugins.markdown.lang.MarkdownElementType;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.intellij.plugins.markdown.lang.lexer.MarkdownMergingLexer;
import org.intellij.plugins.markdown.lang.parser.MarkdownParserManager;
import org.intellij.plugins.markdown.lang.parser.PsiBuilderFillingVisitor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MarkdownLazyElementType
extends ILazyParseableElementType {
    private static final Logger LOG = Logger.getInstance(MarkdownLazyElementType.class);

    public MarkdownLazyElementType(@NotNull @NonNls String debugName) {
        super(debugName, (Language)MarkdownLanguage.INSTANCE);
    }

    protected ASTNode doParseContents(@NotNull ASTNode chameleon, @NotNull PsiElement psi) {
        Project project = psi.getProject();
        MarkdownMergingLexer lexer = new MarkdownMergingLexer();
        CharSequence chars = chameleon.getChars();
        Object flavour = (MarkdownFlavourDescriptor)psi.getContainingFile().getUserData(MarkdownParserManager.FLAVOUR_DESCRIPTION);
        if (flavour == null) {
            LOG.error("Markdown flavour doesn't set for " + psi.getContainingFile());
            flavour = MarkdownParserManager.FLAVOUR;
        }
        org.intellij.markdown.ast.ASTNode node = new MarkdownParser(flavour).parseInline(MarkdownElementType.markdownType(chameleon.getElementType()), chars, 0, chars.length());
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project, chameleon, (Lexer)lexer, this.getLanguage(), chars);
        PsiBuilder.Marker rootMarker = builder.mark();
        new PsiBuilderFillingVisitor(builder).visitNode(node);
        assert (builder.eof());
        rootMarker.done((IElementType)this);
        return builder.getTreeBuilt().getFirstChildNode().getFirstChildNode();
    }
}

