/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.injection.aliases;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lexer.EmbeddedTokenTypesProvider;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.injection.CodeFenceLanguageProvider;
import org.intellij.plugins.markdown.injection.aliases.CodeFenceLanguageAliases;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0003J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/injection/aliases/CodeFenceLanguageGuesser;", "", "()V", "customProviders", "", "Lorg/intellij/plugins/markdown/injection/CodeFenceLanguageProvider;", "getCustomProviders", "()Ljava/util/List;", "guessLanguage", "Lcom/intellij/lang/Language;", "value", "", "guessLanguageForInjection", "intellij.markdown.core"})
@ApiStatus.Internal
public final class CodeFenceLanguageGuesser {
    @NotNull
    public static final CodeFenceLanguageGuesser INSTANCE;

    @NotNull
    public final List<CodeFenceLanguageProvider> getCustomProviders() {
        return CodeFenceLanguageProvider.EP_NAME.getExtensionList();
    }

    @JvmStatic
    @Nullable
    public static final Language guessLanguageForInjection(@NotNull String value) {
        Object object;
        Language language = CodeFenceLanguageGuesser.guessLanguage(value);
        if (language != null) {
            Language language2;
            Language it = language2 = language;
            boolean bl = false;
            object = LanguageUtil.isInjectableLanguage((Language)it) ? language2 : null;
        } else {
            object = null;
        }
        return object;
    }

    @JvmStatic
    private static final Language guessLanguage(String value) {
        String name = CodeFenceLanguageAliases.INSTANCE.findId(value);
        for (CodeFenceLanguageProvider provider : INSTANCE.getCustomProviders()) {
            Language lang = provider.getLanguageByInfoString(name);
            if (lang == null) continue;
            return lang;
        }
        String lower = StringUtil.toLowerCase((String)name);
        Language candidate = Language.findLanguageByID((String)lower);
        if (candidate != null) {
            return candidate;
        }
        for (Language language : Language.getRegisteredLanguages()) {
            if (!Intrinsics.areEqual((Object)StringUtil.toLowerCase((String)language.getID()), (Object)lower)) continue;
            return language;
        }
        for (EmbeddedTokenTypesProvider provider : EmbeddedTokenTypesProvider.getProviders()) {
            if (!StringsKt.equals((String)provider.getName(), (String)name, (boolean)true)) continue;
            return provider.getElementType().getLanguage();
        }
        return null;
    }

    private CodeFenceLanguageGuesser() {
    }

    static {
        CodeFenceLanguageGuesser codeFenceLanguageGuesser;
        INSTANCE = codeFenceLanguageGuesser = new CodeFenceLanguageGuesser();
    }
}

