/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.highlighting;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.highlighting.MarkdownHighlighterColors;
import org.intellij.plugins.markdown.highlighting.MarkdownSyntaxHighlighter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownColorSettingsPage
implements ColorSettingsPage {
    private static final AttributesDescriptor[] ATTRIBUTE_DESCRIPTORS = AttributeDescriptorsHolder.INSTANCE.get();

    @NotNull
    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        HashMap<String, TextAttributesKey> result2 = new HashMap<String, TextAttributesKey>();
        result2.put("hh1", MarkdownHighlighterColors.HEADER_LEVEL_1_ATTR_KEY);
        result2.put("hh2", MarkdownHighlighterColors.HEADER_LEVEL_2_ATTR_KEY);
        result2.put("hh3", MarkdownHighlighterColors.HEADER_LEVEL_3_ATTR_KEY);
        result2.put("hh4", MarkdownHighlighterColors.HEADER_LEVEL_4_ATTR_KEY);
        result2.put("hh5", MarkdownHighlighterColors.HEADER_LEVEL_5_ATTR_KEY);
        result2.put("hh6", MarkdownHighlighterColors.HEADER_LEVEL_6_ATTR_KEY);
        result2.put("bold", MarkdownHighlighterColors.BOLD_ATTR_KEY);
        result2.put("boldm", MarkdownHighlighterColors.BOLD_MARKER_ATTR_KEY);
        result2.put("italic", MarkdownHighlighterColors.ITALIC_ATTR_KEY);
        result2.put("italicm", MarkdownHighlighterColors.ITALIC_MARKER_ATTR_KEY);
        result2.put("strike", MarkdownHighlighterColors.STRIKE_THROUGH_ATTR_KEY);
        result2.put("alink", MarkdownHighlighterColors.AUTO_LINK_ATTR_KEY);
        result2.put("link_def", MarkdownHighlighterColors.LINK_DEFINITION_ATTR_KEY);
        result2.put("link_text", MarkdownHighlighterColors.LINK_TEXT_ATTR_KEY);
        result2.put("link_label", MarkdownHighlighterColors.LINK_LABEL_ATTR_KEY);
        result2.put("link_dest", MarkdownHighlighterColors.LINK_DESTINATION_ATTR_KEY);
        result2.put("link_img", MarkdownHighlighterColors.IMAGE_ATTR_KEY);
        result2.put("link_title", MarkdownHighlighterColors.LINK_TITLE_ATTR_KEY);
        result2.put("code_span", MarkdownHighlighterColors.CODE_SPAN_ATTR_KEY);
        result2.put("code_block", MarkdownHighlighterColors.CODE_BLOCK_ATTR_KEY);
        result2.put("code_fence", MarkdownHighlighterColors.CODE_FENCE_ATTR_KEY);
        result2.put("quote", MarkdownHighlighterColors.BLOCK_QUOTE_ATTR_KEY);
        result2.put("ul", MarkdownHighlighterColors.UNORDERED_LIST_ATTR_KEY);
        result2.put("ol", MarkdownHighlighterColors.ORDERED_LIST_ATTR_KEY);
        result2.put("dl", MarkdownHighlighterColors.DEFINITION_LIST_ATTR_KEY);
        result2.put("dd", MarkdownHighlighterColors.DEFINITION_ATTR_KEY);
        result2.put("dt", MarkdownHighlighterColors.TERM_ATTR_KEY);
        result2.put("dm", MarkdownHighlighterColors.DEFINITION_LIST_MARKER_ATTR_KEY);
        return result2;
    }

    public AttributesDescriptor @NotNull [] getAttributeDescriptors() {
        return ATTRIBUTE_DESCRIPTORS;
    }

    public ColorDescriptor @NotNull [] getColorDescriptors() {
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NonNls
    @NotNull
    public String getDemoText() {
        String string;
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("SampleDocument.md"), StandardCharsets.UTF_8);
        try {
            String result2 = StreamUtil.readText((Reader)reader);
            string = StringUtil.convertLineSeparators((String)result2);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return "*error loading text*";
            }
        }
        ((Reader)reader).close();
        return string;
    }

    @NotNull
    public String getDisplayName() {
        return MarkdownBundle.message("markdown.plugin.name", new Object[0]);
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        return new MarkdownSyntaxHighlighter();
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    private static enum AttributeDescriptorsHolder {
        INSTANCE;

        private final Map<String, TextAttributesKey> myMap = new HashMap<String, TextAttributesKey>();

        private AttributeDescriptorsHolder() {
            this.put("markdown.editor.colors.text", MarkdownHighlighterColors.TEXT_ATTR_KEY);
            this.put("markdown.editor.colors.bold", MarkdownHighlighterColors.BOLD_ATTR_KEY);
            this.put("markdown.editor.colors.bold_marker", MarkdownHighlighterColors.BOLD_MARKER_ATTR_KEY);
            this.put("markdown.editor.colors.italic", MarkdownHighlighterColors.ITALIC_ATTR_KEY);
            this.put("markdown.editor.colors.italic_marker", MarkdownHighlighterColors.ITALIC_MARKER_ATTR_KEY);
            this.put("markdown.editor.colors.strikethrough", MarkdownHighlighterColors.STRIKE_THROUGH_ATTR_KEY);
            this.put("markdown.editor.colors.header_level_1", MarkdownHighlighterColors.HEADER_LEVEL_1_ATTR_KEY);
            this.put("markdown.editor.colors.header_level_2", MarkdownHighlighterColors.HEADER_LEVEL_2_ATTR_KEY);
            this.put("markdown.editor.colors.header_level_3", MarkdownHighlighterColors.HEADER_LEVEL_3_ATTR_KEY);
            this.put("markdown.editor.colors.header_level_4", MarkdownHighlighterColors.HEADER_LEVEL_4_ATTR_KEY);
            this.put("markdown.editor.colors.header_level_5", MarkdownHighlighterColors.HEADER_LEVEL_5_ATTR_KEY);
            this.put("markdown.editor.colors.header_level_6", MarkdownHighlighterColors.HEADER_LEVEL_6_ATTR_KEY);
            this.put("markdown.editor.colors.blockquote", MarkdownHighlighterColors.BLOCK_QUOTE_ATTR_KEY);
            this.put("markdown.editor.colors.code_span", MarkdownHighlighterColors.CODE_SPAN_ATTR_KEY);
            this.put("markdown.editor.colors.code_span_marker", MarkdownHighlighterColors.CODE_SPAN_MARKER_ATTR_KEY);
            this.put("markdown.editor.colors.code_block", MarkdownHighlighterColors.CODE_BLOCK_ATTR_KEY);
            this.put("markdown.editor.colors.code_fence", MarkdownHighlighterColors.CODE_FENCE_ATTR_KEY);
            this.put("markdown.editor.colors.hrule", MarkdownHighlighterColors.HRULE_ATTR_KEY);
            this.put("markdown.editor.colors.table_separator", MarkdownHighlighterColors.TABLE_SEPARATOR_ATTR_KEY);
            this.put("markdown.editor.colors.blockquote_marker", MarkdownHighlighterColors.BLOCK_QUOTE_MARKER_ATTR_KEY);
            this.put("markdown.editor.colors.list_marker", MarkdownHighlighterColors.LIST_MARKER_ATTR_KEY);
            this.put("markdown.editor.colors.header_marker", MarkdownHighlighterColors.HEADER_MARKER_ATTR_KEY);
            this.put("markdown.editor.colors.auto_link", MarkdownHighlighterColors.AUTO_LINK_ATTR_KEY);
            this.put("markdown.editor.colors.explicit_link", MarkdownHighlighterColors.EXPLICIT_LINK_ATTR_KEY);
            this.put("markdown.editor.colors.reference_link", MarkdownHighlighterColors.REFERENCE_LINK_ATTR_KEY);
            this.put("markdown.editor.colors.image", MarkdownHighlighterColors.IMAGE_ATTR_KEY);
            this.put("markdown.editor.colors.link_definition", MarkdownHighlighterColors.LINK_DEFINITION_ATTR_KEY);
            this.put("markdown.editor.colors.link_text", MarkdownHighlighterColors.LINK_TEXT_ATTR_KEY);
            this.put("markdown.editor.colors.link_label", MarkdownHighlighterColors.LINK_LABEL_ATTR_KEY);
            this.put("markdown.editor.colors.link_destination", MarkdownHighlighterColors.LINK_DESTINATION_ATTR_KEY);
            this.put("markdown.editor.colors.link_title", MarkdownHighlighterColors.LINK_TITLE_ATTR_KEY);
            this.put("markdown.editor.colors.unordered_list", MarkdownHighlighterColors.UNORDERED_LIST_ATTR_KEY);
            this.put("markdown.editor.colors.ordered_list", MarkdownHighlighterColors.ORDERED_LIST_ATTR_KEY);
            this.put("markdown.editor.colors.list_item", MarkdownHighlighterColors.LIST_ITEM_ATTR_KEY);
            this.put("markdown.editor.colors.html_block", MarkdownHighlighterColors.HTML_BLOCK_ATTR_KEY);
            this.put("markdown.editor.colors.inline_html", MarkdownHighlighterColors.INLINE_HTML_ATTR_KEY);
            this.put("markdown.editor.colors.definition_list", MarkdownHighlighterColors.DEFINITION_LIST_ATTR_KEY);
            this.put("markdown.editor.colors.definition_list_marker", MarkdownHighlighterColors.DEFINITION_LIST_MARKER_ATTR_KEY);
            this.put("markdown.editor.colors.definition", MarkdownHighlighterColors.DEFINITION_ATTR_KEY);
            this.put("markdown.editor.colors.term", MarkdownHighlighterColors.TERM_ATTR_KEY);
        }

        public AttributesDescriptor @NotNull [] get() {
            AttributesDescriptor[] result2 = new AttributesDescriptor[this.myMap.size()];
            int i = 0;
            for (Map.Entry<String, TextAttributesKey> entry : this.myMap.entrySet()) {
                result2[i++] = new AttributesDescriptor(MarkdownBundle.message(entry.getKey(), new Object[0]), entry.getValue());
            }
            return result2;
        }

        private void put(@NotNull String bundleKey, @NotNull TextAttributesKey attributes) {
            if (this.myMap.put(bundleKey, attributes) != null) {
                throw new IllegalArgumentException("Duplicated key: " + bundleKey);
            }
        }
    }
}

