/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.google.authorization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.intellij.collaboration.auth.services.OAuthCredentialsAcquirer;
import com.intellij.collaboration.auth.services.OAuthCredentialsAcquirerHttp;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.net.http.HttpHeaders;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang.time.DateUtils;
import org.intellij.plugins.markdown.google.authorization.GoogleCredentials;
import org.intellij.plugins.markdown.google.authorization.GoogleOAuthService;
import org.intellij.plugins.markdown.google.utils.GoogleAccountsUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0012\u0013B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0018\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/intellij/plugins/markdown/google/authorization/GoogleOAuthCredentialsAcquirer;", "Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer;", "Lorg/intellij/plugins/markdown/google/authorization/GoogleCredentials;", "googleAppCred", "Lorg/intellij/plugins/markdown/google/utils/GoogleAccountsUtils$GoogleAppCredentials;", "authorizationCodeUrl", "Lcom/intellij/util/Url;", "codeVerifier", "", "(Lorg/intellij/plugins/markdown/google/utils/GoogleAccountsUtils$GoogleAppCredentials;Lcom/intellij/util/Url;Ljava/lang/String;)V", "acquireCredentials", "Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer$AcquireCredentialsResult;", "code", "getCredentials", "responseBody", "responseHeaders", "Ljava/net/http/HttpHeaders;", "getTokenUrlWithParameters", "AuthorizationResponseData", "Companion", "intellij.markdown.core"})
public final class GoogleOAuthCredentialsAcquirer
implements OAuthCredentialsAcquirer<GoogleCredentials> {
    private final GoogleAccountsUtils.GoogleAppCredentials googleAppCred;
    private final Url authorizationCodeUrl;
    private final String codeVerifier;
    private static final String authGrantType = "authorization_code";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public OAuthCredentialsAcquirer.AcquireCredentialsResult<GoogleCredentials> acquireCredentials(@NotNull String code) {
        return OAuthCredentialsAcquirerHttp.INSTANCE.requestToken(this.getTokenUrlWithParameters(code), (Function2)new Function2<String, HttpHeaders, GoogleCredentials>(this){
            final /* synthetic */ GoogleOAuthCredentialsAcquirer this$0;

            @NotNull
            public final GoogleCredentials invoke(@NotNull String body, @NotNull HttpHeaders headers) {
                return GoogleOAuthCredentialsAcquirer.access$getCredentials(this.this$0, body, headers);
            }
            {
                this.this$0 = googleOAuthCredentialsAcquirer;
                super(2);
            }
        });
    }

    private final Url getTokenUrlWithParameters(String code) {
        return GoogleOAuthCredentialsAcquirer.Companion.getTOKEN_URI().addParameters(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"client_id", (Object)this.googleAppCred.getClientId()), TuplesKt.to((Object)"client_secret", (Object)this.googleAppCred.getClientSecret()), TuplesKt.to((Object)"code", (Object)code), TuplesKt.to((Object)"code_verifier", (Object)this.codeVerifier), TuplesKt.to((Object)"grant_type", (Object)authGrantType), TuplesKt.to((Object)"redirect_uri", (Object)this.authorizationCodeUrl.toExternalForm())}));
    }

    private final GoogleCredentials getCredentials(String responseBody, HttpHeaders responseHeaders) {
        ObjectMapper objectMapper;
        Date responseDateTime = GoogleOAuthService.Companion.getLocalDateTime(responseHeaders.firstValue("date").get());
        ObjectMapper $this$with = objectMapper = GoogleOAuthService.Companion.getJacksonMapper();
        boolean bl = false;
        $this$with.setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategies.SnakeCaseStrategy());
        AuthorizationResponseData responseData = (AuthorizationResponseData)$this$with.readValue(responseBody, AuthorizationResponseData.class);
        return new GoogleCredentials(responseData.getAccessToken(), responseData.getRefreshToken(), responseData.getExpiresIn(), responseData.getTokenType(), responseData.getScope(), DateUtils.addSeconds((Date)responseDateTime, (int)((int)responseData.getExpiresIn())));
    }

    public GoogleOAuthCredentialsAcquirer(@NotNull GoogleAccountsUtils.GoogleAppCredentials googleAppCred, @NotNull Url authorizationCodeUrl, @NotNull String codeVerifier) {
        this.googleAppCred = googleAppCred;
        this.authorizationCodeUrl = authorizationCodeUrl;
        this.codeVerifier = codeVerifier;
    }

    public static final /* synthetic */ GoogleCredentials access$getCredentials(GoogleOAuthCredentialsAcquirer $this, String responseBody, HttpHeaders responseHeaders) {
        return $this.getCredentials(responseBody, responseHeaders);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003JE\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006 "}, d2={"Lorg/intellij/plugins/markdown/google/authorization/GoogleOAuthCredentialsAcquirer$AuthorizationResponseData;", "", "accessToken", "", "refreshToken", "expiresIn", "", "tokenType", "scope", "idToken", "(Ljava/lang/String;Ljava/lang/String;JLjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAccessToken", "()Ljava/lang/String;", "getExpiresIn", "()J", "getIdToken", "getRefreshToken", "getScope", "getTokenType", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.markdown.core"})
    private static final class AuthorizationResponseData {
        @NotNull
        private final String accessToken;
        @NotNull
        private final String refreshToken;
        private final long expiresIn;
        @NotNull
        private final String tokenType;
        @NotNull
        private final String scope;
        @NotNull
        private final String idToken;

        @NotNull
        public final String getAccessToken() {
            return this.accessToken;
        }

        @NotNull
        public final String getRefreshToken() {
            return this.refreshToken;
        }

        public final long getExpiresIn() {
            return this.expiresIn;
        }

        @NotNull
        public final String getTokenType() {
            return this.tokenType;
        }

        @NotNull
        public final String getScope() {
            return this.scope;
        }

        @NotNull
        public final String getIdToken() {
            return this.idToken;
        }

        public AuthorizationResponseData(@NotNull String accessToken, @NotNull String refreshToken, long expiresIn, @NotNull String tokenType, @NotNull String scope2, @NotNull String idToken) {
            this.accessToken = accessToken;
            this.refreshToken = refreshToken;
            this.expiresIn = expiresIn;
            this.tokenType = tokenType;
            this.scope = scope2;
            this.idToken = idToken;
        }

        @NotNull
        public final String component1() {
            return this.accessToken;
        }

        @NotNull
        public final String component2() {
            return this.refreshToken;
        }

        public final long component3() {
            return this.expiresIn;
        }

        @NotNull
        public final String component4() {
            return this.tokenType;
        }

        @NotNull
        public final String component5() {
            return this.scope;
        }

        @NotNull
        public final String component6() {
            return this.idToken;
        }

        @NotNull
        public final AuthorizationResponseData copy(@NotNull String accessToken, @NotNull String refreshToken, long expiresIn, @NotNull String tokenType, @NotNull String scope2, @NotNull String idToken) {
            return new AuthorizationResponseData(accessToken, refreshToken, expiresIn, tokenType, scope2, idToken);
        }

        public static /* synthetic */ AuthorizationResponseData copy$default(AuthorizationResponseData authorizationResponseData, String string, String string2, long l, String string3, String string4, String string5, int n, Object object) {
            if ((n & 1) != 0) {
                string = authorizationResponseData.accessToken;
            }
            if ((n & 2) != 0) {
                string2 = authorizationResponseData.refreshToken;
            }
            if ((n & 4) != 0) {
                l = authorizationResponseData.expiresIn;
            }
            if ((n & 8) != 0) {
                string3 = authorizationResponseData.tokenType;
            }
            if ((n & 0x10) != 0) {
                string4 = authorizationResponseData.scope;
            }
            if ((n & 0x20) != 0) {
                string5 = authorizationResponseData.idToken;
            }
            return authorizationResponseData.copy(string, string2, l, string3, string4, string5);
        }

        @NotNull
        public String toString() {
            return "AuthorizationResponseData(accessToken=" + this.accessToken + ", refreshToken=" + this.refreshToken + ", expiresIn=" + this.expiresIn + ", tokenType=" + this.tokenType + ", scope=" + this.scope + ", idToken=" + this.idToken + ")";
        }

        public int hashCode() {
            String string = this.accessToken;
            String string2 = this.refreshToken;
            String string3 = this.tokenType;
            String string4 = this.scope;
            String string5 = this.idToken;
            return (((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + Long.hashCode(this.expiresIn)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (string5 != null ? string5.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof AuthorizationResponseData)) break block3;
                    AuthorizationResponseData authorizationResponseData = (AuthorizationResponseData)object;
                    if (!Intrinsics.areEqual((Object)this.accessToken, (Object)authorizationResponseData.accessToken) || !Intrinsics.areEqual((Object)this.refreshToken, (Object)authorizationResponseData.refreshToken) || this.expiresIn != authorizationResponseData.expiresIn || !Intrinsics.areEqual((Object)this.tokenType, (Object)authorizationResponseData.tokenType) || !Intrinsics.areEqual((Object)this.scope, (Object)authorizationResponseData.scope) || !Intrinsics.areEqual((Object)this.idToken, (Object)authorizationResponseData.idToken)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/intellij/plugins/markdown/google/authorization/GoogleOAuthCredentialsAcquirer$Companion;", "", "()V", "TOKEN_URI", "Lcom/intellij/util/Url;", "getTOKEN_URI", "()Lcom/intellij/util/Url;", "authGrantType", "", "intellij.markdown.core"})
    public static final class Companion {
        private final Url getTOKEN_URI() {
            return Urls.newFromEncoded((String)"https://oauth2.googleapis.com/token");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

