/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Consumer;
import com.intellij.util.NullableConsumer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.folding.MarkdownFoldingBuilder;
import org.intellij.plugins.markdown.folding.MarkdownFoldingBuilder$HeaderRegionsBuildingVisitor$headersHierarchy$1$invokeSuspend$;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.MarkdownElementVisitor;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElement;
import org.intellij.plugins.markdown.lang.psi.MarkdownRecursiveElementVisitor;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownBlockQuote;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCompositePsiElementBase;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownList;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownParagraph;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.util.MarkdownPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0002\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014\u00a8\u0006\u0018"}, d2={"Lorg/intellij/plugins/markdown/folding/MarkdownFoldingBuilder;", "Lcom/intellij/lang/folding/CustomFoldingBuilder;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "buildLanguageFoldRegions", "", "descriptors", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "root", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "quick", "", "getLanguagePlaceholderText", "", "node", "Lcom/intellij/lang/ASTNode;", "range", "Lcom/intellij/openapi/util/TextRange;", "isRegionCollapsedByDefault", "Companion", "HeaderRegionsBuildingVisitor", "intellij.markdown.core"})
public final class MarkdownFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    private static final HashMap<IElementType, String> foldedElementsPresentations;
    @NotNull
    public static final Companion Companion;

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (root.getLanguage() != root.getContainingFile().getViewProvider().getBaseLanguage()) {
            return;
        }
        root.accept((PsiElementVisitor)new MarkdownElementVisitor(descriptors, document){
            final /* synthetic */ List $descriptors;
            final /* synthetic */ Document $document;

            public void visitElement(@NotNull PsiElement element2) {
                super.visitElement(element2);
                element2.acceptChildren((PsiElementVisitor)this);
            }

            public void visitList(@NotNull MarkdownList list2) {
                PsiElement parent = list2.getParent();
                this.addDescriptors(parent instanceof MarkdownListItem ? (MarkdownCompositePsiElementBase)parent : (MarkdownCompositePsiElementBase)list2);
                super.visitList(list2);
            }

            public void visitParagraph(@NotNull MarkdownParagraph paragraph) {
                PsiElement parent = paragraph.getParent();
                if (parent instanceof MarkdownBlockQuote) {
                    PsiElement $this$childrenOfType$iv = parent;
                    boolean $i$f$childrenOfType = false;
                    if (PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, MarkdownParagraph.class).size() <= 1) {
                        return;
                    }
                }
                this.addDescriptors(paragraph);
                super.visitParagraph(paragraph);
            }

            public void visitTable(@NotNull MarkdownTable table) {
                this.addDescriptors(table);
                super.visitTable(table);
            }

            public void visitBlockQuote(@NotNull MarkdownBlockQuote blockQuote) {
                this.addDescriptors(blockQuote);
                super.visitBlockQuote(blockQuote);
            }

            public void visitCodeFence(@NotNull MarkdownCodeFence codeFence) {
                this.addDescriptors(codeFence);
                super.visitCodeFence(codeFence);
            }

            private final void addDescriptors(MarkdownPsiElement element2) {
                org.intellij.plugins.markdown.folding.MarkdownFoldingBuilder$Companion.access$addDescriptors(MarkdownFoldingBuilder.Companion, element2, element2.getTextRange(), this.$descriptors, this.$document);
            }
            {
                this.$descriptors = $captured_local_variable$0;
                this.$document = $captured_local_variable$1;
            }
        });
        HeaderRegionsBuildingVisitor headerVisitor2 = new HeaderRegionsBuildingVisitor((Function2<? super MarkdownPsiElement, ? super TextRange, Unit>)((Function2)new Function2<MarkdownPsiElement, TextRange, Unit>(descriptors, document){
            final /* synthetic */ List $descriptors;
            final /* synthetic */ Document $document;

            public final void invoke(@NotNull MarkdownPsiElement header, @NotNull TextRange range) {
                org.intellij.plugins.markdown.folding.MarkdownFoldingBuilder$Companion.access$addDescriptors(MarkdownFoldingBuilder.Companion, header, range, this.$descriptors, this.$document);
            }
            {
                this.$descriptors = list2;
                this.$document = document;
                super(2);
            }
        }));
        root.accept((PsiElementVisitor)headerVisitor2);
        headerVisitor2.processLastHeaderIfNeeded();
    }

    @NotNull
    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        Object object;
        block3: {
            String elementText;
            block2: {
                String string;
                IElementType elementType = PsiUtilCore.getElementType((ASTNode)node);
                String explicitName = foldedElementsPresentations.get(elementType);
                elementText = StringUtil.shortenTextWithEllipsis((String)node.getText(), (int)30, (int)5);
                object = explicitName;
                if (object == null) break block2;
                String it = string = object;
                boolean bl = false;
                object = it + ": " + elementText;
                if (object != null) break block3;
            }
            object = elementText;
        }
        return object;
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        return false;
    }

    static {
        Companion = new Companion(null);
        foldedElementsPresentations = MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)MarkdownElementTypes.ATX_1, (Object)MarkdownBundle.message("markdown.folding.atx.1.name", new Object[0])), TuplesKt.to((Object)MarkdownElementTypes.ATX_2, (Object)MarkdownBundle.message("markdown.folding.atx.2.name", new Object[0])), TuplesKt.to((Object)MarkdownElementTypes.ATX_3, (Object)MarkdownBundle.message("markdown.folding.atx.3.name", new Object[0])), TuplesKt.to((Object)MarkdownElementTypes.ATX_4, (Object)MarkdownBundle.message("markdown.folding.atx.4.name", new Object[0])), TuplesKt.to((Object)MarkdownElementTypes.ATX_5, (Object)MarkdownBundle.message("markdown.folding.atx.5.name", new Object[0])), TuplesKt.to((Object)MarkdownElementTypes.ATX_6, (Object)MarkdownBundle.message("markdown.folding.atx.6.name", new Object[0])), TuplesKt.to((Object)MarkdownElementTypes.ORDERED_LIST, (Object)MarkdownBundle.message("markdown.folding.ordered.list.name", new Object[0])), TuplesKt.to((Object)MarkdownElementTypes.UNORDERED_LIST, (Object)MarkdownBundle.message("markdown.folding.unordered.list.name", new Object[0])), TuplesKt.to((Object)MarkdownElementTypes.BLOCK_QUOTE, (Object)MarkdownBundle.message("markdown.folding.block.quote.name", new Object[0])), TuplesKt.to((Object)MarkdownElementTypes.TABLE, (Object)MarkdownBundle.message("markdown.folding.table.name", new Object[0])), TuplesKt.to((Object)MarkdownElementTypes.CODE_FENCE, (Object)MarkdownBundle.message("markdown.folding.code.fence.name", new Object[0]))});
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0006\u0010\u000e\u001a\u00020\u0006J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0012\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012*\u00020\rH\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/intellij/plugins/markdown/folding/MarkdownFoldingBuilder$HeaderRegionsBuildingVisitor;", "Lorg/intellij/plugins/markdown/lang/psi/MarkdownRecursiveElementVisitor;", "regionConsumer", "Lkotlin/Function2;", "Lorg/intellij/plugins/markdown/lang/psi/MarkdownPsiElement;", "Lcom/intellij/openapi/util/TextRange;", "", "(Lkotlin/jvm/functions/Function2;)V", "lastProcessedHeader", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeader;", "createRegionIfNeeded", "currentHeader", "regionEnd", "Lcom/intellij/psi/PsiElement;", "processLastHeaderIfNeeded", "visitHeader", "header", "headersHierarchy", "Lkotlin/sequences/Sequence;", "intellij.markdown.core"})
    private static final class HeaderRegionsBuildingVisitor
    extends MarkdownRecursiveElementVisitor {
        private MarkdownHeader lastProcessedHeader;
        private final Function2<MarkdownPsiElement, TextRange, Unit> regionConsumer;

        @Override
        public void visitHeader(@NotNull MarkdownHeader header) {
            MarkdownPsiUtil.processContainer((PsiElement)header, (Consumer<? super PsiElement>)((Consumer)visitHeader.1.INSTANCE), (NullableConsumer<? super PsiElement>)new NullableConsumer(this, header){
                final /* synthetic */ HeaderRegionsBuildingVisitor this$0;
                final /* synthetic */ MarkdownHeader $header;

                public final void consume(@Nullable PsiElement nextHeader) {
                    PsiElement regionEnd = org.intellij.plugins.markdown.folding.MarkdownFoldingBuilder$Companion.access$skipNewLinesBackward(MarkdownFoldingBuilder.Companion, nextHeader);
                    HeaderRegionsBuildingVisitor.access$createRegionIfNeeded(this.this$0, this.$header, regionEnd);
                }
                {
                    this.this$0 = headerRegionsBuildingVisitor;
                    this.$header = markdownHeader;
                }
            });
            this.lastProcessedHeader = header;
            super.visitHeader(header);
        }

        public final void processLastHeaderIfNeeded() {
            MarkdownHeader lastHeader = this.lastProcessedHeader;
            if (lastHeader != null) {
                PsiElement lastFileChild = lastHeader.getContainingFile().getLastChild().getLastChild();
                IElementType iElementType = PsiUtilCore.getElementType((PsiElement)lastFileChild);
                PsiElement regionEnd = Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EOL) ? Companion.skipNewLinesBackward(lastFileChild) : lastFileChild;
                Sequence<MarkdownHeader> headers = this.headersHierarchy((PsiElement)lastHeader);
                for (MarkdownHeader header : headers) {
                    this.createRegionIfNeeded(header, regionEnd);
                }
            }
        }

        private final Sequence<MarkdownHeader> headersHierarchy(PsiElement $this$headersHierarchy) {
            return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super MarkdownHeader>, Continuation<? super Unit>, Object>($this$headersHierarchy, null){
                private /* synthetic */ Object L$0;
                Object L$1;
                int I$0;
                int label;
                final /* synthetic */ PsiElement $this_headersHierarchy;

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2;
                    Iterator iterator;
                    int nextMaxLevel;
                    SequenceScope $this$sequence;
                    Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            $this$sequence = (SequenceScope)this.L$0;
                            Sequence $this$filterIsInstance$iv = PsiTreeUtilKt.siblings((PsiElement)this.$this_headersHierarchy, (boolean)false, (boolean)true);
                            boolean $i$f$filterIsInstance = false;
                            Sequence headers = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)HeaderRegionsBuildingVisitor$headersHierarchy$1$invokeSuspend$$inlined$filterIsInstance$1.INSTANCE);
                            nextMaxLevel = Integer.MAX_VALUE;
                            iterator = headers.iterator();
                            break;
                        }
                        case 1: {
                            void $result;
                            nextMaxLevel = this.I$0;
                            iterator = (Iterator)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }
                    }
                    while (iterator.hasNext()) {
                        MarkdownHeader header = (MarkdownHeader)iterator.next();
                        if (nextMaxLevel <= 1) {
                            return Unit.INSTANCE;
                        }
                        int level = header.getLevel();
                        if (level >= nextMaxLevel) continue;
                        nextMaxLevel = level;
                        this.L$0 = $this$sequence;
                        this.L$1 = iterator;
                        this.I$0 = nextMaxLevel;
                        this.label = 1;
                        object2 = $this$sequence.yield((Object)header, (Continuation)this);
                        if (object2 == object3) return object3;
                    }
                    return Unit.INSTANCE;
                }
                {
                    this.$this_headersHierarchy = psiElement;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    Object object = var3_3.L$0 = value;
                    return var3_3;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        private final void createRegionIfNeeded(MarkdownHeader currentHeader, PsiElement regionEnd) {
            if (regionEnd != null) {
                TextRange range = TextRange.create((int)currentHeader.getTextRange().getStartOffset(), (int)regionEnd.getTextRange().getEndOffset());
                this.regionConsumer.invoke((Object)currentHeader, (Object)range);
            }
        }

        public HeaderRegionsBuildingVisitor(@NotNull Function2<? super MarkdownPsiElement, ? super TextRange, Unit> regionConsumer) {
            this.regionConsumer = regionConsumer;
        }

        public static final /* synthetic */ void access$createRegionIfNeeded(HeaderRegionsBuildingVisitor $this, MarkdownHeader currentHeader, PsiElement regionEnd) {
            $this.createRegionIfNeeded(currentHeader, regionEnd);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\r\u001a\u0004\u0018\u00010\u0017H\u0002RN\u0010\u0003\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u000e\u0012\f0\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\t0\u0004j \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u000e\u0012\f0\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/intellij/plugins/markdown/folding/MarkdownFoldingBuilder$Companion;", "", "()V", "foldedElementsPresentations", "Ljava/util/HashMap;", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "Lkotlin/collections/HashMap;", "addDescriptors", "", "element", "Lorg/intellij/plugins/markdown/lang/psi/MarkdownPsiElement;", "range", "Lcom/intellij/openapi/util/TextRange;", "descriptors", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "document", "Lcom/intellij/openapi/editor/Document;", "skipNewLinesBackward", "Lcom/intellij/psi/PsiElement;", "intellij.markdown.core"})
    public static final class Companion {
        private final void addDescriptors(MarkdownPsiElement element2, TextRange range, List<? super FoldingDescriptor> descriptors, Document document) {
            if (document.getLineNumber(range.getStartOffset()) != document.getLineNumber(range.getEndOffset() - 1)) {
                descriptors.add((FoldingDescriptor)new FoldingDescriptor((PsiElement)element2, range));
            }
        }

        private final PsiElement skipNewLinesBackward(PsiElement element2) {
            PsiElement psiElement;
            PsiElement psiElement2 = element2;
            if (psiElement2 != null && (psiElement2 = PsiTreeUtilKt.siblings((PsiElement)psiElement2, (boolean)false, (boolean)false)) != null) {
                Object v1;
                block3: {
                    PsiElement $this$firstOrNull$iv = psiElement2;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl = false;
                        if (!(!MarkdownPsiUtil.WhiteSpaces.isNewLine(it))) continue;
                        v1 = element$iv;
                        break block3;
                    }
                    v1 = null;
                }
                psiElement = v1;
            } else {
                psiElement = null;
            }
            return psiElement;
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$addDescriptors(Companion $this, MarkdownPsiElement element2, TextRange range, List descriptors, Document document) {
            $this.addDescriptors(element2, range, descriptors, document);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

