/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions.utils;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import org.intellij.plugins.markdown.ui.preview.MarkdownEditorWithPreview;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.MarkdownPreviewFileEditor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J?\u0010\u0003\u001a\u0004\u0018\u0001H\u0004\"\b\b\u0000\u0010\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u0001H\u00040\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0007J\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u0005H\u0007J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\u0014"}, d2={"Lorg/intellij/plugins/markdown/fileActions/utils/MarkdownFileEditorUtils;", "", "()V", "findEditor", "T", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "predicate", "Lkotlin/Function1;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/jvm/functions/Function1;)Lcom/intellij/openapi/fileEditor/FileEditor;", "findMarkdownPreviewEditor", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor;", "editor", "requireOpenedPreview", "", "findMarkdownSplitEditor", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownEditorWithPreview;", "intellij.markdown.core"})
@ApiStatus.Experimental
public final class MarkdownFileEditorUtils {
    @NotNull
    public static final MarkdownFileEditorUtils INSTANCE;

    @JvmStatic
    @Nullable
    public static final MarkdownPreviewFileEditor findMarkdownPreviewEditor(@NotNull FileEditor editor2) {
        MarkdownPreviewFileEditor markdownPreviewFileEditor;
        FileEditor fileEditor = editor2;
        if (fileEditor instanceof MarkdownEditorWithPreview) {
            FileEditor fileEditor2 = ((MarkdownEditorWithPreview)editor2).getPreviewEditor();
            if (!(fileEditor2 instanceof MarkdownPreviewFileEditor)) {
                fileEditor2 = null;
            }
            markdownPreviewFileEditor = (MarkdownPreviewFileEditor)fileEditor2;
        } else if (fileEditor instanceof MarkdownPreviewFileEditor) {
            markdownPreviewFileEditor = (MarkdownPreviewFileEditor)editor2;
        } else {
            MarkdownEditorWithPreview markdownEditorWithPreview = (MarkdownEditorWithPreview)((Object)editor2.getUserData(MarkdownEditorWithPreview.PARENT_SPLIT_EDITOR_KEY));
            Object object = markdownEditorWithPreview != null ? markdownEditorWithPreview.getPreviewEditor() : null;
            if (!(object instanceof MarkdownPreviewFileEditor)) {
                object = null;
            }
            markdownPreviewFileEditor = (MarkdownPreviewFileEditor)((Object)object);
        }
        return markdownPreviewFileEditor;
    }

    @JvmStatic
    @Nullable
    public static final MarkdownPreviewFileEditor findMarkdownPreviewEditor(@NotNull Project project, @NotNull VirtualFile file, boolean requireOpenedPreview) {
        MarkdownPreviewFileEditor editor2 = (MarkdownPreviewFileEditor)((Object)INSTANCE.findEditor(project, file, (Function1)new Function1<FileEditor, MarkdownPreviewFileEditor>(INSTANCE){

            @Nullable
            public final MarkdownPreviewFileEditor invoke(@NotNull FileEditor p1) {
                MarkdownFileEditorUtils cfr_ignored_0 = (MarkdownFileEditorUtils)this.receiver;
                return MarkdownFileEditorUtils.findMarkdownPreviewEditor(p1);
            }
        }));
        if (requireOpenedPreview) {
            MarkdownPreviewFileEditor markdownPreviewFileEditor = editor2;
            if ((markdownPreviewFileEditor != null ? (MarkdownHtmlPanel)markdownPreviewFileEditor.getUserData(MarkdownPreviewFileEditor.PREVIEW_BROWSER) : null) == null) {
                return null;
            }
        }
        return editor2;
    }

    @JvmStatic
    @Nullable
    public static final MarkdownEditorWithPreview findMarkdownSplitEditor(@NotNull FileEditor editor2) {
        FileEditor fileEditor = editor2;
        return fileEditor instanceof MarkdownEditorWithPreview ? (MarkdownEditorWithPreview)editor2 : (MarkdownEditorWithPreview)((Object)editor2.getUserData(MarkdownEditorWithPreview.PARENT_SPLIT_EDITOR_KEY));
    }

    @JvmStatic
    @Nullable
    public static final MarkdownEditorWithPreview findMarkdownSplitEditor(@NotNull Project project, @NotNull VirtualFile file) {
        return (MarkdownEditorWithPreview)((Object)INSTANCE.findEditor(project, file, (Function1)new Function1<FileEditor, MarkdownEditorWithPreview>(INSTANCE){

            @Nullable
            public final MarkdownEditorWithPreview invoke(@NotNull FileEditor p1) {
                MarkdownFileEditorUtils cfr_ignored_0 = (MarkdownFileEditorUtils)this.receiver;
                return MarkdownFileEditorUtils.findMarkdownSplitEditor(p1);
            }
        }));
    }

    private final <T extends FileEditor> T findEditor(Project project, VirtualFile file, Function1<? super FileEditor, ? extends T> predicate) {
        FileEditor[] editors;
        FileEditor selectedEditor;
        FileEditor fileEditor;
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        FileEditor fileEditor2 = editorManager.getSelectedEditor(file);
        if (fileEditor2 != null) {
            FileEditor fileEditor3 = fileEditor2;
            fileEditor = (FileEditor)predicate.invoke((Object)fileEditor3);
        } else {
            fileEditor = selectedEditor = null;
        }
        if (selectedEditor != null) {
            return (T)selectedEditor;
        }
        for (FileEditor editor2 : editors = editorManager.getEditors(file)) {
            FileEditor previewEditor = (FileEditor)predicate.invoke((Object)editor2);
            if (previewEditor == null) continue;
            return (T)previewEditor;
        }
        return null;
    }

    private MarkdownFileEditorUtils() {
    }

    static {
        MarkdownFileEditorUtils markdownFileEditorUtils;
        INSTANCE = markdownFileEditorUtils = new MarkdownFileEditorUtils();
    }
}

