/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions.utils;

import com.google.api.client.auth.oauth2.Credential;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.fileActions.importFrom.docx.MarkdownImportDocxDialog;
import org.intellij.plugins.markdown.fileActions.importFrom.googleDocs.GoogleDocsFileLoader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bJ*\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\b\b\u0002\u0010\u0013\u001a\u00020\bH\u0007J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\bR\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/intellij/plugins/markdown/fileActions/utils/GoogleDocsImportUtils;", "", "()V", "docsRegEx", "Lkotlin/text/Regex;", "getDocsRegEx", "()Lkotlin/text/Regex;", "docsUrlPrefix", "", "docsUrlSuffix", "extractDocsId", "link", "importGoogleDoc", "", "project", "Lcom/intellij/openapi/project/Project;", "credential", "Lcom/google/api/client/auth/oauth2/Credential;", "docsId", "suggestedFilePath", "isLinkToDocumentCorrect", "", "intellij.markdown.core"})
public final class GoogleDocsImportUtils {
    private static final String docsUrlPrefix = "https://docs.google.com/document/d/";
    private static final String docsUrlSuffix = "/edit";
    @NotNull
    public static final GoogleDocsImportUtils INSTANCE;

    private final Regex getDocsRegEx() {
        String string = "https://docs.google.com/document/d/(\\S{32,})(/edit)?";
        return new Regex(string);
    }

    public final boolean isLinkToDocumentCorrect(@NotNull String link) {
        return this.getDocsRegEx().containsMatchIn((CharSequence)link);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String extractDocsId(@NotNull String link) {
        String string;
        block1: {
            void var2_2;
            String $this$takeWhile$iv = link;
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (it != '#') continue;
                String string2 = $this$takeWhile$iv;
                int n2 = 0;
                String string3 = string2.substring(n2, index$iv);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                break block1;
            }
            string = var2_2;
        }
        return StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string, (CharSequence)docsUrlPrefix), (CharSequence)docsUrlSuffix);
    }

    @RequiresEdt
    public final void importGoogleDoc(@NotNull Project project, @NotNull Credential credential, @NotNull String docsId, @NotNull String suggestedFilePath) {
        boolean $i$f$service = false;
        Class<GoogleDocsFileLoader> serviceClass$iv = GoogleDocsFileLoader.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        VirtualFile virtualFile = ((GoogleDocsFileLoader)object).loadFileFromGoogleDisk(project, credential, docsId);
        if (virtualFile == null) {
            return;
        }
        VirtualFile loadedFile = virtualFile;
        String importTaskTitle = MarkdownBundle.message("markdown.google.docs.import.task.title", new Object[0]);
        String importDialogTitle = MarkdownBundle.message("markdown.google.docs.import.dialog.title", new Object[0]);
        String fullFilePath = new File(suggestedFilePath, loadedFile.getName()).getPath();
        new MarkdownImportDocxDialog(loadedFile, importTaskTitle, importDialogTitle, project, fullFilePath).show();
    }

    public static /* synthetic */ void importGoogleDoc$default(GoogleDocsImportUtils googleDocsImportUtils, Project project, Credential credential, String string, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            String string3 = project.getBasePath();
            Intrinsics.checkNotNull((Object)string3);
            string2 = string3;
        }
        googleDocsImportUtils.importGoogleDoc(project, credential, string, string2);
    }

    private GoogleDocsImportUtils() {
    }

    static {
        GoogleDocsImportUtils googleDocsImportUtils;
        INSTANCE = googleDocsImportUtils = new GoogleDocsImportUtils();
    }
}

