/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions.export;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.function.BiConsumer;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.cef.callback.CefPdfPrintCallback;
import org.cef.misc.CefPdfPrintSettings;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.fileActions.MarkdownFileActionFormat;
import org.intellij.plugins.markdown.fileActions.export.MarkdownExportProvider;
import org.intellij.plugins.markdown.fileActions.utils.MarkdownFileEditorUtils;
import org.intellij.plugins.markdown.fileActions.utils.MarkdownImportExportUtils;
import org.intellij.plugins.markdown.ui.MarkdownNotifications;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.MarkdownPreviewFileEditor;
import org.intellij.plugins.markdown.ui.preview.jcef.MarkdownJCEFHtmlPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\fH\u0016J0\u0010\u0011\u001a\u00020\b*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00160\u0015H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lorg/intellij/plugins/markdown/fileActions/export/MarkdownPdfExportProvider;", "Lorg/intellij/plugins/markdown/fileActions/export/MarkdownExportProvider;", "()V", "formatDescription", "Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionFormat;", "getFormatDescription", "()Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionFormat;", "exportFile", "", "project", "Lcom/intellij/openapi/project/Project;", "mdFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "outputFile", "", "validate", "file", "savePdf", "Lorg/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel;", "path", "resultCallback", "Ljava/util/function/BiConsumer;", "", "Companion", "intellij.markdown.core"})
public final class MarkdownPdfExportProvider
implements MarkdownExportProvider {
    @NotNull
    private static final MarkdownFileActionFormat format;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public MarkdownFileActionFormat getFormatDescription() {
        return format;
    }

    @Override
    public void exportFile(@NotNull Project project, @NotNull VirtualFile mdFile, @NotNull String outputFile) {
        MarkdownPreviewFileEditor markdownPreviewFileEditor = MarkdownFileEditorUtils.findMarkdownPreviewEditor(project, mdFile, true);
        if (markdownPreviewFileEditor == null) {
            return;
        }
        MarkdownPreviewFileEditor preview = markdownPreviewFileEditor;
        MarkdownHtmlPanel markdownHtmlPanel = (MarkdownHtmlPanel)preview.getUserData(MarkdownPreviewFileEditor.PREVIEW_BROWSER);
        if (markdownHtmlPanel == null) {
            return;
        }
        MarkdownHtmlPanel htmlPanel = markdownHtmlPanel;
        if (htmlPanel instanceof MarkdownJCEFHtmlPanel) {
            this.savePdf((MarkdownJCEFHtmlPanel)htmlPanel, outputFile, project, new BiConsumer(project){
                final /* synthetic */ Project $project;

                public final void accept(@NotNull String path, @NotNull Boolean ok) {
                    if (ok.booleanValue()) {
                        MarkdownImportExportUtils.INSTANCE.notifyAndRefreshIfExportSuccess(new File(path), this.$project);
                    } else {
                        MarkdownNotifications.showError$default(MarkdownNotifications.INSTANCE, this.$project, "markdown.export.failed", null, MarkdownBundle.message("markdown.export.failure.msg", new File(path).getName()), 4, null);
                    }
                }
                {
                    this.$project = project;
                }
            });
        }
    }

    @Override
    @Nullable
    public String validate(@NotNull Project project, @NotNull VirtualFile file) {
        MarkdownPreviewFileEditor preview = MarkdownFileEditorUtils.findMarkdownPreviewEditor(project, file, true);
        if (preview == null || !MarkdownImportExportUtils.INSTANCE.isJCEFPanelOpen(preview)) {
            return MarkdownBundle.message("markdown.export.validation.failure.msg", this.getFormatDescription().getFormatName());
        }
        return null;
    }

    private final void savePdf(MarkdownJCEFHtmlPanel $this$savePdf, String path, Project project, BiConsumer<String, Boolean> resultCallback) {
        $this$savePdf.getCefBrowser().printToPDF(path, new CefPdfPrintSettings(), new CefPdfPrintCallback(path, project, resultCallback){
            final /* synthetic */ String $path;
            final /* synthetic */ Project $project;
            final /* synthetic */ BiConsumer $resultCallback;

            public final void onPdfPrintFinished(String $noName_0, boolean ok) {
                String dirToExport = new File(this.$path).getParent();
                MarkdownImportExportUtils.INSTANCE.refreshProjectDirectory(this.$project, dirToExport);
                this.$resultCallback.accept(this.$path, ok);
            }
            {
                this.$path = string;
                this.$project = project;
                this.$resultCallback = biConsumer;
            }
        });
    }

    static {
        Companion = new Companion(null);
        format = new MarkdownFileActionFormat("PDF", "pdf");
    }

    @Override
    @Nullable
    public JComponent createSettingsComponent(@NotNull Project project, @NotNull File suggestedTargetFile) {
        return MarkdownExportProvider.DefaultImpls.createSettingsComponent(this, project, suggestedTargetFile);
    }

    @NotNull
    public static final MarkdownFileActionFormat getFormat() {
        Companion companion = Companion;
        return format;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/intellij/plugins/markdown/fileActions/export/MarkdownPdfExportProvider$Companion;", "", "()V", "format", "Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionFormat;", "getFormat$annotations", "getFormat", "()Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionFormat;", "intellij.markdown.core"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getFormat$annotations() {
        }

        @NotNull
        public final MarkdownFileActionFormat getFormat() {
            return format;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

