/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.common;

import com.intellij.openapi.project.Project;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.intellij.plugins.markdown.extensions.MarkdownBrowserPreviewExtension;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0002\u0019\u001aB\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u000fH\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/InlineStylesExtension;", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "priority", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension$Priority;", "getPriority", "()Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension$Priority;", "resourceProvider", "getResourceProvider", "()Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "styles", "", "", "getStyles", "()Ljava/util/List;", "canProvide", "", "resourceName", "dispose", "", "loadResource", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider$Resource;", "Companion", "Provider", "intellij.markdown.core"})
public final class InlineStylesExtension
implements MarkdownBrowserPreviewExtension,
ResourceProvider {
    @NotNull
    private final List<String> styles;
    @NotNull
    private final ResourceProvider resourceProvider;
    private final Project project;
    private static final byte[] emptyStylesheet;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public MarkdownBrowserPreviewExtension.Priority getPriority() {
        return MarkdownBrowserPreviewExtension.Priority.AFTER_ALL;
    }

    @Override
    @NotNull
    public List<String> getStyles() {
        return this.styles;
    }

    @Override
    @NotNull
    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    @Override
    public boolean canProvide(@NotNull String resourceName) {
        return this.getStyles().contains(resourceName);
    }

    @Override
    @NotNull
    public ResourceProvider.Resource loadResource(@NotNull String resourceName) {
        ResourceProvider.Resource resource;
        Object text;
        MarkdownSettings settings;
        MarkdownSettings markdownSettings;
        Object object;
        Project project = this.project;
        if (project != null) {
            Project project2 = project;
            object = MarkdownSettings.Companion;
            Project p1 = project2;
            boolean bl = false;
            markdownSettings = ((MarkdownSettings.Companion)object).getInstance(p1);
        } else {
            markdownSettings = null;
        }
        MarkdownSettings markdownSettings2 = settings = markdownSettings;
        Object it = object = markdownSettings2 != null ? markdownSettings2.getCustomStylesheetText() : null;
        boolean bl = false;
        MarkdownSettings markdownSettings3 = settings;
        Object object2 = text = markdownSettings3 != null && markdownSettings3.getUseCustomStylesheetText() ? object : null;
        if (text == null) {
            resource = new ResourceProvider.Resource(emptyStylesheet, null, 2, null);
        } else {
            object = text;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = ((String)object).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            resource = new ResourceProvider.Resource(byArray, null, 2, null);
        }
        return resource;
    }

    public void dispose() {
    }

    public InlineStylesExtension(@Nullable Project project) {
        this.project = project;
        this.styles = CollectionsKt.listOf((Object)"inlineStyles/inline.css");
        this.resourceProvider = this;
    }

    static {
        Companion = new Companion(null);
        String string = "";
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        emptyStylesheet = byArray;
    }

    @Override
    @NotNull
    public List<String> getScripts() {
        return MarkdownBrowserPreviewExtension.DefaultImpls.getScripts(this);
    }

    @Override
    public int compareTo(@NotNull MarkdownBrowserPreviewExtension other) {
        return MarkdownBrowserPreviewExtension.DefaultImpls.compareTo(this, other);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/InlineStylesExtension$Provider;", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension$Provider;", "()V", "createBrowserExtension", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "panel", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "intellij.markdown.core"})
    public static final class Provider
    implements MarkdownBrowserPreviewExtension.Provider {
        @Override
        @NotNull
        public MarkdownBrowserPreviewExtension createBrowserExtension(@NotNull MarkdownHtmlPanel panel2) {
            return new InlineStylesExtension(panel2.getProject());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/InlineStylesExtension$Companion;", "", "()V", "emptyStylesheet", "", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

