/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.ui.presentation;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hints.InlayHintsUtilsKt;
import com.intellij.codeInsight.hints.presentation.BasePresentation;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.ui.LightweightHint;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.editor.tables.TableFormattingUtils;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils;
import org.intellij.plugins.markdown.editor.tables.actions.TableActionKeys;
import org.intellij.plugins.markdown.editor.tables.ui.presentation.GraphicsUtils;
import org.intellij.plugins.markdown.editor.tables.ui.presentation.HorizontalBarPresentation;
import org.intellij.plugins.markdown.editor.tables.ui.presentation.HorizontalBarPresentation$handleMouseLeftDoubleClick$;
import org.intellij.plugins.markdown.editor.tables.ui.presentation.PresentationWithCustomCursor;
import org.intellij.plugins.markdown.editor.tables.ui.presentation.TableInlayProperties;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u0000 K2\u00020\u0001:\u0002JKB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J(\u0010%\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0&0\b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000f0\bH\u0002J\u0010\u0010(\u001a\u00020\r2\u0006\u0010#\u001a\u00020$H\u0002J&\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010*\u001a\u00020+2\u0006\u0010#\u001a\u00020$2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010,\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u000fH\u0002J\u0017\u00101\u001a\u0004\u0018\u00010\u000f2\u0006\u00102\u001a\u00020.H\u0002\u00a2\u0006\u0002\u00103J\u0018\u00104\u001a\u00020\u001a2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020.H\u0002J\u0018\u00108\u001a\u00020\u001a2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020.H\u0002J\u0018\u00109\u001a\u00020\u001a2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020.H\u0016J\b\u0010:\u001a\u00020\u001aH\u0016J\u0018\u0010;\u001a\u00020\u001a2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020.H\u0016J\u0018\u0010<\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J@\u0010@\u001a\u00020\u001a2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\u0017\u001a\u00020\u000f2\u001e\u0010B\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001a0CH\u0002J\u0010\u0010D\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u000fH\u0002J\b\u0010E\u001a\u00020FH\u0016J\u0017\u0010G\u001a\u00020\u001a2\b\u0010H\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010IR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0011\u00a8\u0006L"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/ui/presentation/HorizontalBarPresentation;", "Lcom/intellij/codeInsight/hints/presentation/BasePresentation;", "editor", "Lcom/intellij/openapi/editor/Editor;", "table", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "(Lcom/intellij/openapi/editor/Editor;Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;)V", "barsModel", "", "Ljava/awt/Rectangle;", "getBarsModel", "()Ljava/util/List;", "boundsState", "Lorg/intellij/plugins/markdown/editor/tables/ui/presentation/HorizontalBarPresentation$BoundsState;", "height", "", "getHeight", "()I", "isInvalid", "", "()Z", "lastSelectedIndex", "Ljava/lang/Integer;", "width", "getWidth", "actuallyPaintBars", "", "graphics", "Ljava/awt/Graphics2D;", "rect", "hover", "accent", "buildBarsModel", "fontMetrics", "Ljava/awt/FontMetrics;", "document", "Lcom/intellij/openapi/editor/Document;", "buildSectors", "Lkotlin/Pair;", "positions", "calculateCurrentBoundsState", "calculatePositions", "header", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableRow;", "calculateRowWidth", "calculateToolbarPosition", "Ljava/awt/Point;", "componentHeight", "columnIndex", "determineColumnIndex", "point", "(Ljava/awt/Point;)Ljava/lang/Integer;", "handleMouseLeftClick", "event", "Ljava/awt/event/MouseEvent;", "translated", "handleMouseLeftDoubleClick", "mouseClicked", "mouseExited", "mouseMoved", "paint", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "paintBars", "paintCircles", "rects", "block", "Lkotlin/Function3;", "showToolbar", "toString", "", "updateSelectedIndexIfNeeded", "index", "(Ljava/lang/Integer;)V", "BoundsState", "Companion", "intellij.markdown.core"})
public final class HorizontalBarPresentation
extends BasePresentation {
    private Integer lastSelectedIndex;
    private BoundsState boundsState;
    private final Editor editor;
    private final MarkdownTable table;
    private static final BoundsState emptyBoundsState;
    public static final int barHeight = 6;
    public static final int leftPadding = 10;
    @NotNull
    public static final Companion Companion;

    private final List<Rectangle> getBarsModel() {
        return this.boundsState.getBarsModel();
    }

    private final boolean isInvalid() {
        return !this.table.isValid() || this.editor.isDisposed();
    }

    public int getWidth() {
        return this.boundsState.getWidth();
    }

    public int getHeight() {
        return this.boundsState.getHeight();
    }

    public void paint(@NotNull Graphics2D graphics, @NotNull TextAttributes attributes) {
        if (this.isInvalid()) {
            return;
        }
        GraphicsUtil.setupAntialiasing((Graphics)graphics);
        GraphicsUtil.setupRoundedBorderAntialiasing((Graphics)graphics);
        this.paintBars(graphics);
    }

    @NotNull
    public String toString() {
        return "HorizontalBarPresentation";
    }

    public void mouseClicked(@NotNull MouseEvent event, @NotNull Point translated) {
        block1: {
            block0: {
                int n;
                int n2;
                int n3;
                if (!SwingUtilities.isLeftMouseButton(event) || (n3 = (n2 = event.getClickCount()) % (n = 2)) + (n & ((n3 ^ n) & (n3 | -n3)) >> 31) != 0) break block0;
                this.handleMouseLeftDoubleClick(event, translated);
                break block1;
            }
            if (!SwingUtilities.isLeftMouseButton(event)) break block1;
            this.handleMouseLeftClick(event, translated);
        }
    }

    public void mouseMoved(@NotNull MouseEvent event, @NotNull Point translated) {
        Integer index = this.determineColumnIndex(translated);
        this.updateSelectedIndexIfNeeded(index);
    }

    public void mouseExited() {
        this.updateSelectedIndexIfNeeded(null);
    }

    private final BoundsState calculateCurrentBoundsState(Document document) {
        if (this.isInvalid()) {
            return emptyBoundsState;
        }
        FontMetrics fontsMetrics = HorizontalBarPresentation.Companion.obtainFontMetrics(this.editor);
        int width = this.calculateRowWidth(fontsMetrics, document);
        List<Rectangle> barsModel = this.buildBarsModel(fontsMetrics, document);
        return new BoundsState(width, 6, barsModel);
    }

    private final int calculateRowWidth(FontMetrics fontMetrics, Document document) {
        if (this.isInvalid()) {
            return 0;
        }
        MarkdownTableRow markdownTableRow = this.table.getHeaderRow();
        if (markdownTableRow == null) {
            return 0;
        }
        MarkdownTableRow header = markdownTableRow;
        return fontMetrics.stringWidth(document.getText(header.getTextRange()));
    }

    private final void updateSelectedIndexIfNeeded(Integer index) {
        if (Intrinsics.areEqual((Object)this.lastSelectedIndex, (Object)index) ^ true) {
            this.lastSelectedIndex = index;
            InlayHintsUtilsKt.fireUpdateEvent((InlayPresentation)this, (Dimension)new Dimension(0, 0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Rectangle> buildBarsModel(FontMetrics fontMetrics, Document document) {
        void $this$mapTo$iv$iv;
        MarkdownTableRow markdownTableRow;
        MarkdownTableRow markdownTableRow2 = markdownTableRow = this.table.getHeaderRow();
        if (markdownTableRow2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        MarkdownTableRow header = markdownTableRow2;
        List<Integer> positions = this.calculatePositions(header, document, fontMetrics);
        List<Pair<Integer, Integer>> sectors = this.buildSectors(positions);
        Iterable $this$map$iv = sectors;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void offset;
            void $dstr$offset$width;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int n = ((Number)$dstr$offset$width.component1()).intValue();
            int width = ((Number)$dstr$offset$width.component2()).intValue();
            Rectangle rectangle = new Rectangle((int)(offset - 3), 0, width + 6, 6);
            collection.add(rectangle);
        }
        return (List)destination$iv$iv;
    }

    private final List<Integer> calculatePositions(MarkdownTableRow header, Document document, FontMetrics fontMetrics) {
        boolean bl = true;
        Sequence separators2 = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)PsiTreeUtilKt.siblings((PsiElement)header.getFirstChild(), (boolean)true, (boolean)true), (Function1)calculatePositions.separators.1.INSTANCE), (Function1)calculatePositions.separators.2.INSTANCE);
        int separatorWidth = fontMetrics.charWidth('|');
        Integer n = (Integer)SequencesKt.firstOrNull((Sequence)separators2);
        if (n == null) {
            return CollectionsKt.emptyList();
        }
        int firstOffset = n;
        ArrayList<Integer> result2 = new ArrayList<Integer>();
        int position = this.editor.offsetToXY((int)firstOffset).x + separatorWidth / 2;
        int lastOffset = firstOffset;
        result2.add(position);
        Iterator iterator = SequencesKt.drop((Sequence)separators2, (int)1).iterator();
        while (iterator.hasNext()) {
            int offset = ((Number)iterator.next()).intValue();
            int length = fontMetrics.stringWidth(document.getText(new TextRange(lastOffset, offset)));
            result2.add(position += length);
            lastOffset = offset;
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Integer, Integer>> buildSectors(List<Integer> positions) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.windowed$default((Iterable)positions, (int)2, (int)0, (boolean)false, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void left;
            void $dstr$left$right;
            List list2 = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var11_11 = $dstr$left$right;
            int n = ((Number)var11_11.get(0)).intValue();
            var11_11 = $dstr$left$right;
            int right = ((Number)var11_11.get(1)).intValue();
            Pair pair = TuplesKt.to((Object)((int)left), (Object)(right - left));
            collection.add(pair);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private final Integer determineColumnIndex(Point point) {
        int n;
        block2: {
            List<Rectangle> $this$indexOfFirst$iv = this.getBarsModel();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<Rectangle> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                Rectangle item$iv;
                Rectangle it = item$iv = iterator.next();
                boolean bl = false;
                if (it.contains(point)) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        Integer n2 = n;
        int it = ((Number)n2).intValue();
        boolean bl = false;
        return !(it < 0) ? n2 : null;
    }

    private final Point calculateToolbarPosition(int componentHeight, int columnIndex) {
        Point position = this.editor.offsetToXY(UtilsKt.getStartOffset((PsiElement)((PsiElement)this.table)));
        Point editorParent = this.editor.getContentComponent().getTopLevelAncestor().getLocationOnScreen();
        Point editorPosition = this.editor.getContentComponent().getLocationOnScreen();
        position.translate(editorPosition.x - editorParent.x, editorPosition.y - editorParent.y);
        position.translate(10, -this.editor.getLineHeight());
        position.translate(0, -componentHeight);
        Rectangle rect = this.getBarsModel().get(columnIndex);
        int bottomPadding = 2;
        position.translate(rect.x, -rect.y - 12 - bottomPadding);
        return position;
    }

    private final void showToolbar(int columnIndex) {
        ActionToolbar actionToolbar2 = TableActionKeys.INSTANCE.createActionToolbar(HorizontalBarPresentation.Companion.getColumnActionGroup(), true, this.editor, HorizontalBarPresentation.Companion.createDataProvider(this.table, columnIndex));
        LightweightHint hint = new LightweightHint(actionToolbar2.getComponent());
        hint.setForceShowAsPopup(true);
        Point targetPoint = this.calculateToolbarPosition(hint.getComponent().getPreferredSize().height, columnIndex);
        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        hintManager.hideAllHints();
        int flags = 1066;
        hintManager.showEditorHint(hint, this.editor, targetPoint, flags, 0, false);
    }

    private final void handleMouseLeftDoubleClick(MouseEvent event, Point translated) {
        Integer n = this.determineColumnIndex(translated);
        if (n == null) {
            return;
        }
        int columnIndex = n;
        ModalityState modalityState$iv = null;
        boolean $i$f$invokeLater = false;
        ApplicationManager.getApplication().invokeLater(new Runnable(this, columnIndex){
            final /* synthetic */ HorizontalBarPresentation this$0;
            final /* synthetic */ int $columnIndex$inlined;
            {
                this.this$0 = horizontalBarPresentation;
                this.$columnIndex$inlined = n;
            }

            public final void run() {
                boolean bl = false;
                Project project$iv = null;
                String name$iv = null;
                String groupId$iv = null;
                boolean $i$f$executeCommand = false;
                CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(this){
                    final /* synthetic */ handleMouseLeftDoubleClick$$inlined$invokeLater$1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void run() {
                        boolean bl = false;
                        TableModificationUtils.INSTANCE.selectColumn(HorizontalBarPresentation.access$getTable$p(this.this$0.this$0), HorizontalBarPresentation.access$getEditor$p(this.this$0.this$0), this.this$0.$columnIndex$inlined, true, true, true);
                    }
                }, name$iv, (Object)groupId$iv);
            }
        }, ModalityState.defaultModalityState());
    }

    private final void handleMouseLeftClick(MouseEvent event, Point translated) {
        Integer n = this.determineColumnIndex(translated);
        if (n == null) {
            return;
        }
        int columnIndex = n;
        this.showToolbar(columnIndex);
    }

    private final void actuallyPaintBars(Graphics2D graphics, Rectangle rect, boolean hover, boolean accent) {
        int paintCount = accent ? 2 : 1;
        for (int i = 0; i < paintCount; ++i) {
            int it = i;
            boolean bl = false;
            graphics.setColor(hover ? TableInlayProperties.INSTANCE.getBarHoverColor() : TableInlayProperties.INSTANCE.getBarColor());
            graphics.fillRoundRect(rect.x, 0, rect.width, 6, 6, 6);
            GraphicsUtils.INSTANCE.clearOvalOverEditor(graphics, rect.x, 0, 6, 6);
            GraphicsUtils.INSTANCE.clearOvalOverEditor(graphics, rect.x + rect.width - 6, 0, 6, 6);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void paintBars(Graphics2D graphics) {
        List<Rectangle> currentBarsModel = this.getBarsModel();
        int n = 0;
        for (Rectangle rect : (Iterable)currentBarsModel) {
            void index;
            Integer n2 = this.lastSelectedIndex;
            boolean mouseIsOver = n2 != null && n2.intValue() == index;
            this.actuallyPaintBars(graphics, rect, mouseIsOver, false);
            ++index;
        }
        n = 2;
        int n3 = 0;
        while (n3 < n) {
            int it = n3++;
            boolean bl = false;
            HorizontalBarPresentation.paintCircles$default(this, currentBarsModel, 0, (Function3)new Function3<Integer, Rectangle, Integer, Unit>(this, currentBarsModel, graphics){
                final /* synthetic */ HorizontalBarPresentation this$0;
                final /* synthetic */ List $currentBarsModel$inlined;
                final /* synthetic */ Graphics2D $graphics$inlined;
                {
                    this.this$0 = horizontalBarPresentation;
                    this.$currentBarsModel$inlined = list2;
                    this.$graphics$inlined = graphics2D;
                    super(3);
                }

                public final void invoke(int x, @NotNull Rectangle $noName_1, int $noName_2) {
                    this.$graphics$inlined.setColor(TableInlayProperties.INSTANCE.getBarColor());
                    this.$graphics$inlined.fillOval(x, 0, 6, 6);
                }
            }, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void paintCircles(List<? extends Rectangle> rects, int width, Function3<? super Integer, ? super Rectangle, ? super Integer, Unit> block) {
        Collection collection = rects;
        if (!collection.isEmpty()) {
            boolean bl = false;
            for (Rectangle rect : (Iterable)rects) {
                void index;
                block.invoke((Object)rect.x, (Object)rect, (Object)((int)index));
                ++index;
            }
            Object object = CollectionsKt.last(rects);
            Rectangle it = (Rectangle)object;
            boolean bl2 = false;
            block.invoke((Object)(it.x + it.width - width), (Object)it, (Object)-1);
        }
    }

    static /* synthetic */ void paintCircles$default(HorizontalBarPresentation horizontalBarPresentation, List list2, int n, Function3 function3, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 6;
        }
        horizontalBarPresentation.paintCircles(list2, n, (Function3<? super Integer, ? super Rectangle, ? super Integer, Unit>)function3);
    }

    public HorizontalBarPresentation(@NotNull Editor editor2, @NotNull MarkdownTable table) {
        this.editor = editor2;
        this.table = table;
        this.boundsState = emptyBoundsState;
        final Document document = this.editor.getDocument();
        PsiDocumentManager.getInstance((Project)this.table.getProject()).performForCommittedDocument(document, new Runnable(){

            @Override
            public final void run() {
                ModalityState modalityState$iv = ModalityState.stateForComponent((Component)editor.getContentComponent());
                boolean $i$f$invokeLater = false;
                Application application = ApplicationManager.getApplication();
                Runnable runnable = new Runnable(this){
                    final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void run() {
                        boolean bl = false;
                        if (!HorizontalBarPresentation.access$isInvalid$p(this.this$0.this) && !TableFormattingUtils.INSTANCE.isSoftWrapping(HorizontalBarPresentation.access$getTable$p(this.this$0.this), HorizontalBarPresentation.access$getEditor$p(this.this$0.this))) {
                            BoundsState calculated = HorizontalBarPresentation.access$calculateCurrentBoundsState(this.this$0.this, this.this$0.document);
                            HorizontalBarPresentation.access$setBoundsState$p(this.this$0.this, calculated);
                            this.this$0.this.fireSizeChanged(new Dimension(0, 0), new Dimension(calculated.getWidth(), calculated.getHeight()));
                        }
                    }
                };
                ModalityState modalityState = modalityState$iv;
                if (modalityState == null) {
                    modalityState = ModalityState.defaultModalityState();
                }
                application.invokeLater(runnable, modalityState);
            }
        });
    }

    static {
        Companion = new Companion(null);
        emptyBoundsState = new BoundsState(0, 0, CollectionsKt.emptyList());
    }

    public static final /* synthetic */ MarkdownTable access$getTable$p(HorizontalBarPresentation $this) {
        return $this.table;
    }

    public static final /* synthetic */ boolean access$isInvalid$p(HorizontalBarPresentation $this) {
        return $this.isInvalid();
    }

    public static final /* synthetic */ BoundsState access$calculateCurrentBoundsState(HorizontalBarPresentation $this, Document document) {
        return $this.calculateCurrentBoundsState(document);
    }

    public static final /* synthetic */ BoundsState access$getBoundsState$p(HorizontalBarPresentation $this) {
        return $this.boundsState;
    }

    public static final /* synthetic */ void access$setBoundsState$p(HorizontalBarPresentation $this, BoundsState boundsState) {
        $this.boundsState = boundsState;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J-\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/ui/presentation/HorizontalBarPresentation$BoundsState;", "", "width", "", "height", "barsModel", "", "Ljava/awt/Rectangle;", "(IILjava/util/List;)V", "getBarsModel", "()Ljava/util/List;", "getHeight", "()I", "getWidth", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.markdown.core"})
    private static final class BoundsState {
        private final int width;
        private final int height;
        @NotNull
        private final List<Rectangle> barsModel;

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        @NotNull
        public final List<Rectangle> getBarsModel() {
            return this.barsModel;
        }

        public BoundsState(int width, int height, @NotNull List<? extends Rectangle> barsModel) {
            this.width = width;
            this.height = height;
            this.barsModel = barsModel;
        }

        public final int component1() {
            return this.width;
        }

        public final int component2() {
            return this.height;
        }

        @NotNull
        public final List<Rectangle> component3() {
            return this.barsModel;
        }

        @NotNull
        public final BoundsState copy(int width, int height, @NotNull List<? extends Rectangle> barsModel) {
            return new BoundsState(width, height, barsModel);
        }

        public static /* synthetic */ BoundsState copy$default(BoundsState boundsState, int n, int n2, List list2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = boundsState.width;
            }
            if ((n3 & 2) != 0) {
                n2 = boundsState.height;
            }
            if ((n3 & 4) != 0) {
                list2 = boundsState.barsModel;
            }
            return boundsState.copy(n, n2, list2);
        }

        @NotNull
        public String toString() {
            return "BoundsState(width=" + this.width + ", height=" + this.height + ", barsModel=" + this.barsModel + ")";
        }

        public int hashCode() {
            List<Rectangle> list2 = this.barsModel;
            return (Integer.hashCode(this.width) * 31 + Integer.hashCode(this.height)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BoundsState)) break block3;
                    BoundsState boundsState = (BoundsState)object;
                    if (this.width != boundsState.width || this.height != boundsState.height || !Intrinsics.areEqual(this.barsModel, boundsState.barsModel)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/ui/presentation/HorizontalBarPresentation$Companion;", "", "()V", "barHeight", "", "columnActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getColumnActionGroup", "()Lcom/intellij/openapi/actionSystem/ActionGroup;", "emptyBoundsState", "Lorg/intellij/plugins/markdown/editor/tables/ui/presentation/HorizontalBarPresentation$BoundsState;", "leftPadding", "create", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "factory", "Lcom/intellij/codeInsight/hints/presentation/PresentationFactory;", "editor", "Lcom/intellij/openapi/editor/Editor;", "table", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "createDataProvider", "Lcom/intellij/openapi/actionSystem/DataProvider;", "columnIndex", "obtainFontMetrics", "Ljava/awt/FontMetrics;", "wrapPresentation", "presentation", "intellij.markdown.core"})
    public static final class Companion {
        private final ActionGroup getColumnActionGroup() {
            AnAction anAction = ActionManager.getInstance().getAction("Markdown.TableColumnActions");
            if (anAction == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
            }
            return (ActionGroup)anAction;
        }

        private final InlayPresentation wrapPresentation(PresentationFactory factory, Editor editor2, InlayPresentation presentation) {
            return (InlayPresentation)PresentationFactory.inset$default((PresentationFactory)factory, (InlayPresentation)((InlayPresentation)new PresentationWithCustomCursor(editor2, presentation)), (int)10, (int)0, (int)2, (int)2, (int)4, null);
        }

        @NotNull
        public final InlayPresentation create(@NotNull PresentationFactory factory, @NotNull Editor editor2, @NotNull MarkdownTable table) {
            return this.wrapPresentation(factory, editor2, (InlayPresentation)new HorizontalBarPresentation(editor2, table));
        }

        private final FontMetrics obtainFontMetrics(Editor editor2) {
            Font font = editor2.getColorsScheme().getFont(EditorFontType.PLAIN);
            return editor2.getContentComponent().getFontMetrics(font);
        }

        private final DataProvider createDataProvider(MarkdownTable table, int columnIndex) {
            WeakReference<MarkdownTable> tableReference = new WeakReference<MarkdownTable>(table);
            return new DataProvider(columnIndex, tableReference){
                final /* synthetic */ int $columnIndex;
                final /* synthetic */ WeakReference $tableReference;

                @Nullable
                public final Object getData(@NotNull String it) {
                    return TableActionKeys.INSTANCE.getCOLUMN_INDEX().is(it) ? Integer.valueOf(this.$columnIndex) : (TableActionKeys.INSTANCE.getELEMENT().is(it) ? this.$tableReference : null);
                }
                {
                    this.$columnIndex = n;
                    this.$tableReference = weakReference;
                }
            };
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

