/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.handlers;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.suggested.UtilsKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.editor.tables.handlers.MarkdownTableTabHandler$findNextCell$;
import org.intellij.plugins.markdown.editor.tables.handlers.MarkdownTableTabHandler$findSiblingCell$;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRow;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\"\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\"\u0010\u0017\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/handlers/MarkdownTableTabHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorWriteActionHandler;", "baseHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "forward", "", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;Z)V", "actuallyExecute", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "executeWriteAction", "", "findNextCell", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableCell;", "currentCell", "findSiblingCell", "element", "Lcom/intellij/psi/PsiElement;", "withSelf", "isEnabledForCaret", "ShiftTab", "Tab", "intellij.markdown.core"})
public abstract class MarkdownTableTabHandler
extends EditorWriteActionHandler {
    private final EditorActionHandler baseHandler;
    private final boolean forward;

    protected boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, @Nullable DataContext dataContext) {
        EditorActionHandler editorActionHandler = this.baseHandler;
        return editorActionHandler != null && editorActionHandler.isEnabled(editor2, caret, dataContext);
    }

    public void executeWriteAction(@NotNull Editor editor2, @Nullable Caret caret, @Nullable DataContext dataContext) {
        block1: {
            if (this.actuallyExecute(editor2, caret, dataContext)) break block1;
            EditorActionHandler editorActionHandler = this.baseHandler;
            if (editorActionHandler != null) {
                editorActionHandler.execute(editor2, caret, dataContext);
            }
        }
    }

    private final boolean actuallyExecute(Editor editor2, Caret caret, DataContext dataContext) {
        Project project = editor2.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        if (!Registry.is((String)"markdown.tables.editing.support.enable") || !MarkdownSettings.Companion.getInstance(project2).isEnhancedEditingEnabled()) {
            return false;
        }
        Document document = editor2.getDocument();
        Caret caret2 = caret;
        if (caret2 == null) {
            return false;
        }
        int caretOffset = caret2.getOffset();
        if (!TableUtils.isProbablyInsideTableCell(document, caretOffset) || editor2.getCaretModel().getCaretCount() != 1) {
            return false;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        PsiFile psiFile = documentManager.getPsiFile(document);
        if (psiFile == null) {
            return false;
        }
        PsiFile file = psiFile;
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
        MarkdownTableCell markdownTableCell = TableUtils.findCell(file, caretOffset);
        if (markdownTableCell == null) {
            return false;
        }
        MarkdownTableCell cell = markdownTableCell;
        MarkdownTableCell nextCell = this.findNextCell(cell, this.forward);
        if (nextCell != null) {
            int offset = this.forward ? TableUtils.INSTANCE.getFirstNonWhitespaceOffset(nextCell) : TableUtils.INSTANCE.getLastNonWhitespaceOffset(nextCell) + 1;
            caret.moveToOffset(offset);
            return true;
        }
        if (this.forward) {
            MarkdownTableRow markdownTableRow = cell.getParentRow();
            if (markdownTableRow != null) {
                int n;
                int it = n = UtilsKt.getEndOffset((PsiElement)((PsiElement)markdownTableRow));
                boolean bl = false;
                caret.moveToOffset(it);
            }
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final MarkdownTableCell findNextCell(MarkdownTableCell currentCell, boolean forward) {
        nextCellInCurrentRow = this.findSiblingCell((PsiElement)currentCell, forward, false);
        if (nextCellInCurrentRow != null) {
            return nextCellInCurrentRow;
        }
        v0 = currentCell.getParentRow();
        if (v0 == null || (v0 = PsiTreeUtilKt.siblings((PsiElement)((PsiElement)v0), (boolean)forward, (boolean)false)) == null) ** GOTO lbl-1000
        $this$filterIsInstance$iv = v0;
        $i$f$filterIsInstance = false;
        v0 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)findNextCell$$inlined$filterIsInstance$1.INSTANCE);
        if (v0 != null) {
            v1 = (MarkdownTableRow)SequencesKt.firstOrNull((Sequence)v0);
        } else lbl-1000:
        // 2 sources

        {
            v1 = null;
        }
        nextRow = v1;
        if (forward) {
            v2 = nextRow;
            v3 /* !! */  = v2 != null ? v2.getFirstChild() : null;
        } else {
            v4 = nextRow;
            v3 /* !! */  = v4 != null ? v4.getLastChild() : null;
        }
        v5 = startElement = v3 /* !! */ ;
        if (v5 != null) {
            it = var6_6 = v5;
            $i$a$-let-MarkdownTableTabHandler$findNextCell$1 = false;
            v6 = this.findSiblingCell(it, forward, true);
        } else {
            v6 = null;
        }
        return v6;
    }

    private final MarkdownTableCell findSiblingCell(PsiElement element2, boolean forward, boolean withSelf) {
        Sequence $this$filterIsInstance$iv = PsiTreeUtilKt.siblings((PsiElement)element2, (boolean)forward, (boolean)withSelf);
        boolean $i$f$filterIsInstance = false;
        return (MarkdownTableCell)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)findSiblingCell$$inlined$filterIsInstance$1.INSTANCE));
    }

    public MarkdownTableTabHandler(@Nullable EditorActionHandler baseHandler, boolean forward) {
        this.baseHandler = baseHandler;
        this.forward = forward;
    }

    public /* synthetic */ MarkdownTableTabHandler(EditorActionHandler editorActionHandler, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(editorActionHandler, bl);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/handlers/MarkdownTableTabHandler$Tab;", "Lorg/intellij/plugins/markdown/editor/tables/handlers/MarkdownTableTabHandler;", "baseHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "intellij.markdown.core"})
    public static final class Tab
    extends MarkdownTableTabHandler {
        public Tab(@Nullable EditorActionHandler baseHandler) {
            super(baseHandler, true);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/handlers/MarkdownTableTabHandler$ShiftTab;", "Lorg/intellij/plugins/markdown/editor/tables/handlers/MarkdownTableTabHandler;", "baseHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "intellij.markdown.core"})
    public static final class ShiftTab
    extends MarkdownTableTabHandler {
        public ShiftTab(@Nullable EditorActionHandler baseHandler) {
            super(baseHandler, false);
        }
    }
}

