/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.handlers;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilCore;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.editor.tables.handlers.MarkdownTableShiftEnterHandler$actuallyFindRow$;
import org.intellij.plugins.markdown.editor.tables.handlers.MarkdownTableShiftEnterHandler$findElement$;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRow;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J$\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J \u0010\u0015\u001a\u0004\u0018\u0001H\u0016\"\u0006\b\u0000\u0010\u0016\u0018\u00012\u0006\u0010\u0017\u001a\u00020\u000eH\u0082\b\u00a2\u0006\u0002\u0010\u0018J\"\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J\u0018\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/handlers/MarkdownTableShiftEnterHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorWriteActionHandler;", "baseHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "actuallyExecute", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "actuallyFindRow", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "caretOffset", "", "executeWriteAction", "", "findElement", "T", "element", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Object;", "findRow", "document", "Lcom/intellij/openapi/editor/Document;", "isEnabledForCaret", "isProbablyAtTheEndOfTableRow", "intellij.markdown.core"})
public final class MarkdownTableShiftEnterHandler
extends EditorWriteActionHandler {
    private final EditorActionHandler baseHandler;

    protected boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, @Nullable DataContext dataContext) {
        EditorActionHandler editorActionHandler = this.baseHandler;
        return editorActionHandler != null && editorActionHandler.isEnabled(editor2, caret, dataContext);
    }

    public void executeWriteAction(@NotNull Editor editor2, @Nullable Caret caret, @Nullable DataContext dataContext) {
        block1: {
            if (this.actuallyExecute(editor2, caret, dataContext)) break block1;
            EditorActionHandler editorActionHandler = this.baseHandler;
            if (editorActionHandler != null) {
                editorActionHandler.execute(editor2, caret, dataContext);
            }
        }
    }

    private final boolean actuallyExecute(Editor editor2, Caret caret, DataContext dataContext) {
        Project project = editor2.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        if (!Registry.is((String)"markdown.tables.editing.support.enable") || !MarkdownSettings.Companion.getInstance(project2).isEnhancedEditingEnabled()) {
            return false;
        }
        Document document = editor2.getDocument();
        Caret caret2 = caret;
        if (caret2 == null) {
            caret2 = editor2.getCaretModel().getCurrentCaret();
        }
        Caret currentCaret = caret2;
        int caretOffset = currentCaret.getOffset();
        if (!TableUtils.isProbablyInsideTableCell(document, caretOffset) && !this.isProbablyAtTheEndOfTableRow(document, caretOffset) || editor2.getCaretModel().getCaretCount() != 1) {
            return false;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        PsiFile psiFile = documentManager.getPsiFile(document);
        if (psiFile == null) {
            return false;
        }
        PsiFile file = psiFile;
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
        PsiElement psiElement = this.findRow(file, document, caretOffset);
        if (psiElement == null) {
            return false;
        }
        PsiElement row = psiElement;
        MarkdownTable markdownTable = TableUtils.findTable(row);
        if (markdownTable == null) {
            return false;
        }
        MarkdownTable table = markdownTable;
        String emptyRow = TableModificationUtils.buildEmptyRow$default(TableModificationUtils.INSTANCE, table, null, 1, null).toString();
        Project project$iv = table.getProject();
        String name$iv = null;
        String groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(emptyRow, document, caretOffset, currentCaret){
            final /* synthetic */ String $emptyRow$inlined;
            final /* synthetic */ Document $document$inlined;
            final /* synthetic */ int $caretOffset$inlined;
            final /* synthetic */ Caret $currentCaret$inlined;
            {
                this.$emptyRow$inlined = string;
                this.$document$inlined = document;
                this.$caretOffset$inlined = n;
                this.$currentCaret$inlined = caret;
            }

            public final void run() {
                boolean bl = false;
                String content2 = "\n" + this.$emptyRow$inlined;
                int line = this.$document$inlined.getLineNumber(this.$caretOffset$inlined);
                int lineEndOffset = this.$document$inlined.getLineEndOffset(line);
                this.$document$inlined.insertString(lineEndOffset, (CharSequence)content2);
                this.$currentCaret$inlined.moveToOffset(this.$document$inlined.getLineEndOffset(line + 1));
            }
        }, name$iv, (Object)groupId$iv);
        return true;
    }

    private final PsiElement findRow(PsiFile file, Document document, int caretOffset) {
        PsiElement actual = this.actuallyFindRow(file, caretOffset);
        if (actual != null) {
            return actual;
        }
        if (caretOffset == 0 || document.getLineNumber(caretOffset) != document.getLineNumber(caretOffset - 1)) {
            return null;
        }
        return this.actuallyFindRow(file, caretOffset - 1);
    }

    private final /* synthetic */ <T> T findElement(PsiElement element2) {
        int $i$f$findElement = 0;
        Sequence $this$filterIsInstance$iv = PsiTreeUtilKt.siblings((PsiElement)element2, (boolean)false, (boolean)true);
        boolean $i$f$filterIsInstance = false;
        Intrinsics.needClassReification();
        Object sibling = SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)findElement$$inlined$filterIsInstance$1.INSTANCE));
        Object object = sibling;
        if (object == null) {
            $this$filterIsInstance$iv = PsiTreeUtilKt.parents((PsiElement)element2, (boolean)true);
            $i$f$filterIsInstance = false;
            Intrinsics.needClassReification();
            object = SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)findElement$$inlined$filterIsInstance$2.INSTANCE));
        }
        return (T)object;
    }

    private final PsiElement actuallyFindRow(PsiFile file, int caretOffset) {
        PsiElement psiElement;
        Object primary;
        Object object;
        PsiElement element2 = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)caretOffset);
        Object this_$iv = this;
        boolean $i$f$findElement = false;
        Sequence $this$filterIsInstance$iv$iv = PsiTreeUtilKt.siblings((PsiElement)element2, (boolean)false, (boolean)true);
        boolean $i$f$filterIsInstance = false;
        Object sibling$iv = SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv, (Function1)actuallyFindRow$$inlined$findElement$1.INSTANCE));
        Object object2 = sibling$iv;
        if (object2 == null) {
            $this$filterIsInstance$iv$iv = PsiTreeUtilKt.parents((PsiElement)element2, (boolean)true);
            $i$f$filterIsInstance = false;
            object2 = SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv, (Function1)actuallyFindRow$$inlined$findElement$2.INSTANCE));
        }
        MarkdownTableRow markdownTableRow = (MarkdownTableRow)object2;
        if (markdownTableRow != null) {
            Object it = this_$iv = markdownTableRow;
            boolean bl = false;
            object = !TableUtils.INSTANCE.isHeaderRow((MarkdownTableRow)it) ? this_$iv : null;
        } else {
            object = null;
        }
        Object object3 = primary = object;
        if (object3 != null) {
            psiElement = (PsiElement)object3;
        } else {
            this_$iv = this;
            $i$f$findElement = false;
            $this$filterIsInstance$iv$iv = PsiTreeUtilKt.siblings((PsiElement)element2, (boolean)false, (boolean)true);
            $i$f$filterIsInstance = false;
            sibling$iv = SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv, (Function1)actuallyFindRow$$inlined$findElement$3.INSTANCE));
            Object object4 = sibling$iv;
            if (object4 == null) {
                $this$filterIsInstance$iv$iv = PsiTreeUtilKt.parents((PsiElement)element2, (boolean)true);
                $i$f$filterIsInstance = false;
                object4 = SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv, (Function1)actuallyFindRow$$inlined$findElement$4.INSTANCE));
            }
            psiElement = (PsiElement)object4;
        }
        return psiElement;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isProbablyAtTheEndOfTableRow(Document document, int caretOffset) {
        CharSequence text = document.getCharsSequence();
        int line = document.getLineNumber(caretOffset);
        int lineEndOffset = document.getLineEndOffset(line);
        int n = caretOffset;
        int n2 = lineEndOffset;
        while (n < n2) {
            void offset;
            switch (text.charAt((int)offset)) {
                case '\t': 
                case ' ': {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++offset;
        }
        return true;
    }

    public MarkdownTableShiftEnterHandler(@Nullable EditorActionHandler baseHandler) {
        this.baseHandler = baseHandler;
    }
}

