/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.actions.column;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.editor.tables.actions.TableActionKeys;
import org.intellij.plugins.markdown.editor.tables.actions.column.ColumnBasedTableAction;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b \u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J'\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0014\u00a2\u0006\u0002\u0010\u000eJ\"\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0014J8\u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\bH$J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J)\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\bH\u0014\u00a2\u0006\u0002\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/ColumnBasedTableAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "findColumnIndex", "", "file", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Document;I)Ljava/lang/Integer;", "findTable", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "findTableAndIndex", "Lkotlin/Pair;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "performAction", "editor", "Lcom/intellij/openapi/editor/Editor;", "table", "columnIndex", "update", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;Ljava/lang/Integer;)V", "Companion", "intellij.markdown.core"})
public abstract class ColumnBasedTableAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent event) {
        void table;
        Editor editor2 = (Editor)event.getRequiredData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)event.getRequiredData(CommonDataKeys.PSI_FILE);
        int offset = ((Caret)event.getRequiredData(CommonDataKeys.CARET)).getOffset();
        Document document = editor2.getDocument();
        Object object = this.findTableAndIndex(event, file, document, offset);
        MarkdownTable markdownTable = (MarkdownTable)object.component1();
        Integer columnIndex = (Integer)object.component2();
        if (table == null) {
            object = "Required value was null.";
            throw new IllegalArgumentException(object.toString());
        }
        if (columnIndex == null) {
            object = "Required value was null.";
            throw new IllegalArgumentException(object.toString());
        }
        this.performAction(editor2, (MarkdownTable)table, columnIndex);
    }

    /*
     * WARNING - void declaration
     */
    public void update(@NotNull AnActionEvent event) {
        void table;
        Integer offset;
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        Caret caret = (Caret)event.getData(CommonDataKeys.CARET);
        Integer n = offset = caret != null ? Integer.valueOf(caret.getOffset()) : null;
        if (project == null || editor2 == null || file == null || offset == null) {
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Document document = editor2.getDocument();
        Pair<MarkdownTable, Integer> pair = this.findTableAndIndex(event, file, document, offset);
        MarkdownTable markdownTable = (MarkdownTable)pair.component1();
        Integer columnIndex = (Integer)pair.component2();
        event.getPresentation().setEnabledAndVisible(table != null && columnIndex != null);
        this.update(event, (MarkdownTable)table, columnIndex);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    protected abstract void performAction(@NotNull Editor var1, @NotNull MarkdownTable var2, int var3);

    protected void update(@NotNull AnActionEvent event, @Nullable MarkdownTable table, @Nullable Integer columnIndex) {
    }

    private final Pair<MarkdownTable, Integer> findTableAndIndex(AnActionEvent event, PsiFile file, Document document, int offset) {
        return Companion.findTableAndIndex(event, file, document, offset, (Function3<? super PsiFile, ? super Document, ? super Integer, ? extends MarkdownTable>)((Function3)new Function3<PsiFile, Document, Integer, MarkdownTable>(this){

            @Nullable
            public final MarkdownTable invoke(@NotNull PsiFile p1, @NotNull Document p2, int p3) {
                return ((ColumnBasedTableAction)((Object)this.receiver)).findTable(p1, p2, p3);
            }
        }), (Function3<? super PsiFile, ? super Document, ? super Integer, Integer>)((Function3)new Function3<PsiFile, Document, Integer, Integer>(this){

            @Nullable
            public final Integer invoke(@NotNull PsiFile p1, @NotNull Document p2, int p3) {
                return ((ColumnBasedTableAction)((Object)this.receiver)).findColumnIndex(p1, p2, p3);
            }
        }));
    }

    @Nullable
    protected MarkdownTable findTable(@NotNull PsiFile file, @NotNull Document document, int offset) {
        return TableUtils.findTable(file, offset);
    }

    @Nullable
    protected Integer findColumnIndex(@NotNull PsiFile file, @NotNull Document document, int offset) {
        return TableUtils.findCellIndex(file, offset);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006Jz\u0010\u0003\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062 \u0010\u000e\u001a\u001c\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000f2 \u0010\u0010\u001a\u001c\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u000f\u00a8\u0006\u0011"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/ColumnBasedTableAction$Companion;", "", "()V", "findTableAndIndex", "Lkotlin/Pair;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "file", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "tableGetter", "Lkotlin/Function3;", "columnIndexGetter", "intellij.markdown.core"})
    public static final class Companion {
        @NotNull
        public final Pair<MarkdownTable, Integer> findTableAndIndex(@NotNull AnActionEvent event, @NotNull PsiFile file, @NotNull Document document, int offset, @NotNull Function3<? super PsiFile, ? super Document, ? super Integer, ? extends MarkdownTable> tableGetter, @NotNull Function3<? super PsiFile, ? super Document, ? super Integer, Integer> columnIndexGetter) {
            MarkdownTable markdownTable;
            WeakReference weakReference = (WeakReference)event.getData(TableActionKeys.INSTANCE.getELEMENT());
            Object object = weakReference != null ? (PsiElement)weakReference.get() : null;
            if (!(object instanceof MarkdownTable)) {
                object = null;
            }
            MarkdownTable tableFromEvent = (MarkdownTable)object;
            Integer indexFromEvent = (Integer)event.getData(TableActionKeys.INSTANCE.getCOLUMN_INDEX());
            if (tableFromEvent != null && indexFromEvent != null) {
                return TuplesKt.to((Object)tableFromEvent, (Object)indexFromEvent);
            }
            MarkdownTable markdownTable2 = (MarkdownTable)tableGetter.invoke((Object)file, (Object)document, (Object)offset);
            if (markdownTable2 != null) {
                MarkdownTable markdownTable3;
                MarkdownTable it = markdownTable3 = markdownTable2;
                boolean bl = false;
                markdownTable = it.isValid() ? markdownTable3 : null;
            } else {
                markdownTable = null;
            }
            MarkdownTable table = markdownTable;
            Integer index = (Integer)columnIndexGetter.invoke((Object)file, (Object)document, (Object)offset);
            return TuplesKt.to((Object)table, (Object)index);
        }

        @NotNull
        public final Pair<MarkdownTable, Integer> findTableAndIndex(@NotNull AnActionEvent event, @NotNull PsiFile file, @NotNull Document document, int offset) {
            return this.findTableAndIndex(event, file, document, offset, (Function3<? super PsiFile, ? super Document, ? super Integer, ? extends MarkdownTable>)((Function3)findTableAndIndex.1.INSTANCE), (Function3<? super PsiFile, ? super Document, ? super Integer, Integer>)((Function3)findTableAndIndex.2.INSTANCE));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

