/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang.StringUtils;
import org.intellij.plugins.markdown.editor.tables.TableFormattingUtils;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001.B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J6\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J#\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u001aJ8\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0014H\u0002J0\u0010#\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u0014H\u0002J*\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\"\u001a\u00020\u0014J\"\u0010\u0003\u001a\u00020\u0004*\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0012\u0010*\u001a\u00020\u0014*\u00020)2\u0006\u0010+\u001a\u00020,J:\u0010-\u001a\u00020\u001c*\u00020)2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010&\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\"\u001a\u00020\u0014\u00a8\u0006/"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/TableFormattingUtils;", "", "()V", "buildCellState", "Lorg/intellij/plugins/markdown/editor/tables/TableFormattingUtils$CellContentState;", "range", "Lcom/intellij/openapi/util/TextRange;", "document", "Lcom/intellij/openapi/editor/Document;", "carets", "", "Lcom/intellij/openapi/editor/Caret;", "calculateContentsMaxWidth", "", "cells", "", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableCell;", "cellsContentsWithCarets", "separatorCellRange", "trimToMaxContent", "", "calculateNewCaretsPositions", "", "content", "", "cellRange", "(Ljava/lang/String;Lcom/intellij/openapi/util/TextRange;)[Ljava/lang/Integer;", "processCell", "", "cell", "state", "maxCellWidth", "alignment", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow$CellAlignment;", "preventExpand", "processSeparator", "separatorRow", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow;", "columnIndex", "reformatAllColumns", "table", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "isSoftWrapping", "editor", "Lcom/intellij/openapi/editor/Editor;", "reformatColumnOnChange", "CellContentState", "intellij.markdown.core"})
@ApiStatus.Internal
public final class TableFormattingUtils {
    @NotNull
    public static final TableFormattingUtils INSTANCE;

    /*
     * WARNING - void declaration
     */
    private final CellContentState buildCellState(TextRange range, Document document, Iterable<? extends Caret> carets) {
        StringBuilder stringBuilder;
        boolean $this$all$iv2;
        List caretsOffsets;
        String content2;
        Caret[] caretsInside;
        block9: {
            boolean bl;
            Iterator $this$mapTo$iv$iv;
            void $this$toTypedArray$iv;
            Collection $this$sortedBy$iv;
            int n;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = carets;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv22 = new ArrayList();
            boolean $i$f$filterTo22 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Caret it = (Caret)element$iv$iv;
                n = 0;
                if (!range.containsOffset(it.getOffset())) continue;
                destination$iv$iv22.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv22;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Caret it = (Caret)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getOffset());
                    it = (Caret)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    Integer n = it.getOffset();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            });
            boolean $i$f$toTypedArray22 = false;
            void thisCollection$iv22 = $this$toTypedArray$iv;
            Caret[] caretArray = thisCollection$iv22.toArray(new Caret[0]);
            if (caretArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            caretsInside = caretArray;
            Caret[] $i$f$toTypedArray22 = document.getCharsSequence();
            int thisCollection$iv22 = range.getStartOffset();
            int destination$iv$iv22 = range.getEndOffset();
            content2 = ((Object)$i$f$toTypedArray22.subSequence(thisCollection$iv22, destination$iv$iv22)).toString();
            $i$f$toTypedArray22 = caretsInside;
            if ($i$f$toTypedArray22.length == 0) {
                return new CellContentState(content2, null, 2, null);
            }
            Caret[] $this$map$iv = caretsInside;
            boolean $i$f$map = false;
            Caret[] $i$f$filterTo22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            n = ((void)$this$mapTo$iv$iv).length;
            for (int it = 0; it < n; ++it) {
                void it2;
                void item$iv$iv;
                void var15_30 = item$iv$iv = $this$mapTo$iv$iv[it];
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Integer n2 = it2.getOffset() - range.getStartOffset();
                collection.add(n2);
            }
            caretsOffsets = (List)destination$iv$iv;
            Iterable $this$all$iv2 = caretsOffsets;
            boolean $i$f$all = false;
            if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv2) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl3 = false;
                    if (it <= content2.length()) continue;
                    bl = false;
                    break block9;
                }
                bl = $this$all$iv2 = true;
            }
        }
        if (!$this$all$iv2) {
            boolean bl = false;
            String string = "Content indices: " + StringsKt.getIndices((CharSequence)content2) + "; Carets offsets: " + caretsOffsets;
            throw new IllegalStateException(string.toString());
        }
        StringBuilder $this$buildString = stringBuilder = new StringBuilder();
        boolean bl = false;
        int previousOffset = 0;
        Iterator iterator = caretsOffsets.iterator();
        while (iterator.hasNext()) {
            int caretOffset = ((Number)iterator.next()).intValue();
            String string = content2;
            String string2 = string.substring(previousOffset, caretOffset);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            $this$buildString.append(string2);
            $this$buildString.append('\n');
            previousOffset = caretOffset;
        }
        String string = content2;
        int n = content2.length();
        String string3 = string.substring(previousOffset, n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        $this$buildString.append(string3);
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
        String contentWithReplacements = string4;
        return new CellContentState(contentWithReplacements, caretsInside);
    }

    private final CellContentState buildCellState(MarkdownTableCell $this$buildCellState, Document document, Iterable<? extends Caret> carets) {
        return this.buildCellState($this$buildCellState.getTextRange(), document, carets);
    }

    private final int calculateContentsMaxWidth(Collection<? extends MarkdownTableCell> cells, Iterable<CellContentState> cellsContentsWithCarets, TextRange separatorCellRange, boolean trimToMaxContent) {
        Integer contentCellsWidth2;
        Integer n;
        Object it;
        Iterator iterator;
        Object object;
        if (trimToMaxContent) {
            Object object2;
            object = SequencesKt.map((Sequence)CollectionsKt.asSequence(cellsContentsWithCarets), (Function1)calculateContentsMaxWidth.contentCellsWidth.1.INSTANCE);
            iterator = object.iterator();
            if (!iterator.hasNext()) {
                object2 = null;
            } else {
                it = (String)iterator.next();
                boolean bl = false;
                it = ((String)it).length() + 2;
                while (iterator.hasNext()) {
                    Object it2 = (String)iterator.next();
                    $i$a$-maxOfOrNull-TableFormattingUtils$calculateContentsMaxWidth$contentCellsWidth$2 = false;
                    if (it.compareTo(it2 = (Comparable)Integer.valueOf(((String)it2).length() + 2)) >= 0) continue;
                    it = it2;
                }
                object2 = it;
            }
            n = (Integer)object2;
        } else {
            Comparable comparable;
            object = cells;
            iterator = object.iterator();
            if (!iterator.hasNext()) {
                comparable = null;
            } else {
                it = (MarkdownTableCell)iterator.next();
                boolean bl = false;
                Comparable comparable2 = Integer.valueOf(it.getTextRange().getLength());
                while (iterator.hasNext()) {
                    MarkdownTableCell it3 = (MarkdownTableCell)iterator.next();
                    $i$a$-maxOfOrNull-TableFormattingUtils$calculateContentsMaxWidth$contentCellsWidth$3 = false;
                    Comparable comparable3 = Integer.valueOf(it3.getTextRange().getLength());
                    if (comparable2.compareTo(comparable3) >= 0) continue;
                    comparable2 = comparable3;
                }
                comparable = comparable2;
            }
            n = (Integer)comparable;
        }
        if ((contentCellsWidth2 = n) == null) {
            object = "Required value was null.";
            throw new IllegalStateException(object.toString());
        }
        TextRange textRange = separatorCellRange;
        return Integer.max(Integer.max(contentCellsWidth2, textRange != null ? textRange.getLength() : -1), 5);
    }

    /*
     * WARNING - void declaration
     */
    private final Integer[] calculateNewCaretsPositions(String content2, TextRange cellRange) {
        void $this$toTypedArray$iv22;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        int it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = (Iterable)StringsKt.getIndices((CharSequence)content2);
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(content2.charAt(it) == '\n')) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = it + cellRange.getStartOffset();
            collection.add(n);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv22;
        Integer[] integerArray = thisCollection$iv.toArray(new Integer[0]);
        if (integerArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        Integer[] positions = integerArray;
        int $this$toTypedArray$iv22 = 0;
        int n = positions.length;
        while ($this$toTypedArray$iv22 < n) {
            void index;
            void v1 = index;
            positions[v1] = positions[v1] - index;
            ++index;
        }
        return positions;
    }

    /*
     * WARNING - void declaration
     */
    private final void processCell(Document document, MarkdownTableCell cell, CellContentState state, int maxCellWidth, MarkdownTableSeparatorRow.CellAlignment alignment, boolean preventExpand) {
        String expectedContent = TableModificationUtils.INSTANCE.buildRealignedCellContent(state.getTrimmedContentWithCarets(), maxCellWidth + state.getCaretsInside().length, alignment);
        TextRange range = cell.getTextRange();
        CharSequence charSequence = document.getCharsSequence();
        int n = range.getStartOffset();
        int n2 = range.getEndOffset();
        String cellContent = ((Object)charSequence.subSequence(n, n2)).toString();
        if (preventExpand && cellContent.length() < maxCellWidth) {
            return;
        }
        String expectedContentWithoutCarets = StringsKt.replace$default((String)expectedContent, (String)String.valueOf('\n'), (String)"", (boolean)false, (int)4, null);
        if (Intrinsics.areEqual((Object)cellContent, (Object)expectedContentWithoutCarets) ^ true) {
            document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)expectedContentWithoutCarets);
            Object[] caretsPositions = this.calculateNewCaretsPositions(expectedContent, range);
            int n3 = n2 = caretsPositions.length == state.getCaretsInside().length ? 1 : 0;
            if (n2 == 0) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            for (Pair pair : SequencesKt.zip((Sequence)ArraysKt.asSequence((Object[])state.getCaretsInside()), (Sequence)ArraysKt.asSequence((Object[])caretsPositions))) {
                void caret;
                Caret caret2 = (Caret)pair.component1();
                int position = ((Number)pair.component2()).intValue();
                caret.moveToOffset(position);
            }
        }
    }

    private final void processSeparator(Document document, MarkdownTableSeparatorRow separatorRow, int columnIndex, int maxCellWidth, boolean preventExpand) {
        TextRange textRange = MarkdownTableSeparatorRow.getCellRange$default(separatorRow, columnIndex, false, 2, null);
        Intrinsics.checkNotNull((Object)textRange);
        TextRange range = textRange;
        CharSequence charSequence = document.getCharsSequence();
        int n = range.getStartOffset();
        int n2 = range.getEndOffset();
        String content2 = ((Object)charSequence.subSequence(n, n2)).toString();
        if (preventExpand && content2.length() < maxCellWidth) {
            return;
        }
        MarkdownTableSeparatorRow.CellAlignment alignment = separatorRow.getCellAlignment(columnIndex);
        String expectedContent = TableModificationUtils.INSTANCE.buildSeparatorCellContent(alignment, maxCellWidth);
        if (Intrinsics.areEqual((Object)content2, (Object)expectedContent) ^ true) {
            document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)expectedContent);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void reformatColumnOnChange(@NotNull MarkdownTable $this$reformatColumnOnChange, @NotNull Document document, @NotNull Iterable<? extends Caret> carets, int columnIndex, boolean trimToMaxContent, boolean preventExpand) {
        boolean bl;
        Iterable iterable;
        MarkdownTableSeparatorRow separatorRow;
        List cellsStates;
        Object object;
        Object object2;
        Collection destination$iv$iv;
        List cells;
        block6: {
            String $this$mapTo$iv$iv;
            cells = CollectionsKt.asReversed(TableUtils.INSTANCE.getColumnCells($this$reformatColumnOnChange, columnIndex, true));
            Iterable $this$map$iv = cells;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv = iterator.next();
                MarkdownTableCell markdownTableCell = (MarkdownTableCell)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl2 = false;
                object = INSTANCE.buildCellState((MarkdownTableCell)it, document, carets);
                object2.add(object);
            }
            cellsStates = (List)destination$iv$iv;
            MarkdownTableSeparatorRow markdownTableSeparatorRow = $i$f$map = TableUtils.INSTANCE.getSeparatorRow($this$reformatColumnOnChange);
            if (markdownTableSeparatorRow == null) {
                $this$mapTo$iv$iv = "Required value was null.";
                throw new IllegalStateException($this$mapTo$iv$iv.toString());
            }
            separatorRow = markdownTableSeparatorRow;
            TextRange textRange = MarkdownTableSeparatorRow.getCellRange$default(separatorRow, columnIndex, false, 2, null);
            Intrinsics.checkNotNull((Object)textRange);
            TextRange separatorCellRange = textRange;
            Collection $i$f$mapTo22 = destination$iv$iv = separatorCellRange;
            iterable = cellsStates;
            object = cells;
            object2 = this;
            boolean bl3 = false;
            Iterable<? extends Caret> $this$any$iv = carets;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator<? extends Caret> bl2 = $this$any$iv.iterator();
                while (bl2.hasNext()) {
                    Caret element$iv;
                    Caret it = element$iv = bl2.next();
                    boolean bl4 = false;
                    if (!separatorCellRange.containsOffset(it.getOffset())) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        boolean bl5 = bl;
        int maxCellWidth = super.calculateContentsMaxWidth((Collection<? extends MarkdownTableCell>)object, iterable, (TextRange)(bl5 ? destination$iv$iv : null), trimToMaxContent);
        MarkdownTableSeparatorRow.CellAlignment alignment = TableUtils.INSTANCE.getColumnAlignment($this$reformatColumnOnChange, columnIndex);
        Sequence contentCells2 = SequencesKt.takeWhile((Sequence)SequencesKt.zip((Sequence)CollectionsKt.asSequence((Iterable)cells), (Sequence)CollectionsKt.asSequence((Iterable)cellsStates)), (Function1)reformatColumnOnChange.contentCells.1.INSTANCE);
        for (Pair pair : contentCells2) {
            void cell;
            MarkdownTableCell $i$f$any = (MarkdownTableCell)pair.component1();
            CellContentState state = (CellContentState)pair.component2();
            this.processCell(document, (MarkdownTableCell)cell, state, maxCellWidth, alignment, preventExpand);
        }
        this.processSeparator(document, separatorRow, columnIndex, maxCellWidth, preventExpand);
        this.processCell(document, (MarkdownTableCell)CollectionsKt.last((List)cells), (CellContentState)CollectionsKt.last((List)cellsStates), maxCellWidth, alignment, preventExpand);
    }

    public static /* synthetic */ void reformatColumnOnChange$default(TableFormattingUtils tableFormattingUtils, MarkdownTable markdownTable, Document document, Iterable iterable, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            bl2 = false;
        }
        tableFormattingUtils.reformatColumnOnChange(markdownTable, document, iterable, n, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    public final void reformatAllColumns(@NotNull MarkdownTable table, @NotNull Document document, boolean trimToMaxContent, boolean preventExpand) {
        int n;
        IntRange columnsIndices = TableUtils.INSTANCE.getColumnsIndices(table);
        int tableOffset = UtilsKt.getStartOffset((PsiElement)((PsiElement)table));
        IntRange intRange = columnsIndices;
        int n2 = intRange.getFirst();
        if (n2 <= (n = intRange.getLast())) {
            while (true) {
                void columnIndex;
                MarkdownTable currentTable;
                PsiDocumentManager.getInstance((Project)table.getProject()).commitDocument(document);
                if (TableUtils.findTable(table.getContainingFile(), tableOffset) == null) {
                    break;
                }
                if (!TableUtils.INSTANCE.getColumnsIndices(currentTable).contains((int)columnIndex)) break;
                this.reformatColumnOnChange(currentTable, document, CollectionsKt.emptyList(), (int)columnIndex, trimToMaxContent, preventExpand);
                if (columnIndex == n) break;
                ++columnIndex;
            }
        }
    }

    public static /* synthetic */ void reformatAllColumns$default(TableFormattingUtils tableFormattingUtils, MarkdownTable markdownTable, Document document, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        tableFormattingUtils.reformatAllColumns(markdownTable, document, bl, bl2);
    }

    public final boolean isSoftWrapping(@NotNull MarkdownTable $this$isSoftWrapping, @NotNull Editor editor2) {
        TextRange range = $this$isSoftWrapping.getTextRange();
        Collection collection = editor2.getSoftWrapModel().getSoftWrapsForRange(range.getStartOffset(), range.getEndOffset());
        return !collection.isEmpty();
    }

    private TableFormattingUtils() {
    }

    static {
        TableFormattingUtils tableFormattingUtils;
        INSTANCE = tableFormattingUtils = new TableFormattingUtils();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000e\u0010\fR\u001b\u0010\u0011\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/TableFormattingUtils$CellContentState;", "", "contentWithCarets", "", "caretsInside", "", "Lcom/intellij/openapi/editor/Caret;", "(Ljava/lang/String;[Lcom/intellij/openapi/editor/Caret;)V", "getCaretsInside", "()[Lcom/intellij/openapi/editor/Caret;", "[Lcom/intellij/openapi/editor/Caret;", "getContentWithCarets", "()Ljava/lang/String;", "trimmedContentWithCarets", "getTrimmedContentWithCarets", "trimmedContentWithCarets$delegate", "Lkotlin/Lazy;", "trimmedContentWithoutCarets", "getTrimmedContentWithoutCarets", "trimmedContentWithoutCarets$delegate", "intellij.markdown.core"})
    private static final class CellContentState {
        @NotNull
        private final Lazy trimmedContentWithCarets$delegate;
        @NotNull
        private final Lazy trimmedContentWithoutCarets$delegate;
        @NotNull
        private final String contentWithCarets;
        @NotNull
        private final Caret[] caretsInside;

        @NotNull
        public final String getTrimmedContentWithCarets() {
            Lazy lazy = this.trimmedContentWithCarets$delegate;
            CellContentState cellContentState = this;
            Object var3_3 = null;
            return (String)lazy.getValue();
        }

        @NotNull
        public final String getTrimmedContentWithoutCarets() {
            Lazy lazy = this.trimmedContentWithoutCarets$delegate;
            CellContentState cellContentState = this;
            Object var3_3 = null;
            return (String)lazy.getValue();
        }

        @NotNull
        public final String getContentWithCarets() {
            return this.contentWithCarets;
        }

        @NotNull
        public final Caret[] getCaretsInside() {
            return this.caretsInside;
        }

        public CellContentState(@NotNull String contentWithCarets, @NotNull Caret[] caretsInside) {
            this.contentWithCarets = contentWithCarets;
            this.caretsInside = caretsInside;
            this.trimmedContentWithCarets$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ CellContentState this$0;

                @NotNull
                public final String invoke() {
                    return StringsKt.trim((String)this.this$0.getContentWithCarets(), (char[])new char[]{' '});
                }
                {
                    this.this$0 = cellContentState;
                    super(0);
                }
            }));
            this.trimmedContentWithoutCarets$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ CellContentState this$0;

                public final String invoke() {
                    return StringUtils.remove((String)this.this$0.getTrimmedContentWithCarets(), (char)'\n');
                }
                {
                    this.this$0 = cellContentState;
                    super(0);
                }
            }));
        }

        public /* synthetic */ CellContentState(String string, Caret[] caretArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                caretArray = new Caret[]{};
            }
            this(string, caretArray);
        }
    }
}

