/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.lists.ListRenumberUtils;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.psi.MarkdownElementVisitor;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownList;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/inspections/IncorrectListNumberingInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "ListNumberingFix", "intellij.markdown.core"})
@ApiStatus.Internal
public final class IncorrectListNumberingInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new MarkdownElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;

            /*
             * WARNING - void declaration
             */
            public void visitList(@NotNull MarkdownList list2) {
                super.visitList(list2);
                if (!PsiUtilsKt.hasType((PsiElement)list2, MarkdownElementTypes.ORDERED_LIST)) {
                    return;
                }
                Object var3_2 = null;
                Lazy quickFix2 = LazyKt.lazy((Function0)((Function0)new Function0<ListNumberingFix>(list2){
                    final /* synthetic */ MarkdownList $list;

                    @NotNull
                    public final ListNumberingFix invoke() {
                        return new ListNumberingFix(this.$list);
                    }
                    {
                        this.$list = markdownList;
                        super(0);
                    }
                }));
                boolean bl = false;
                for (MarkdownListItem item : (Iterable)ListUtils.INSTANCE.getItems(list2)) {
                    void index;
                    Integer n = ListRenumberUtils.INSTANCE.obtainMarkerNumber(item);
                    if (n == null) {
                    } else {
                        int actualNumber = n;
                        void expectedNumber = index + true;
                        if (expectedNumber != actualNumber) {
                            PsiElement markerElement;
                            Intrinsics.checkNotNull((Object)item.getMarkerElement());
                            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
                            Lazy lazy = quickFix2;
                            Object var11_11 = null;
                            localQuickFixArray[0] = (LocalQuickFix)((ListNumberingFix)((Object)lazy.getValue()));
                            this.$holder.registerProblem(markerElement, MarkdownBundle.message("markdown.incorrectly.numbered.list.item.inspection.text", (int)expectedNumber, actualNumber), ProblemHighlightType.WEAK_WARNING, localQuickFixArray);
                        }
                    }
                    ++index;
                }
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J)\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0096\u0002\u00a8\u0006\u0011"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/inspections/IncorrectListNumberingInspection$ListNumberingFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "list", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownList;", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownList;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.markdown.core"})
    private static final class ListNumberingFix
    extends LocalQuickFixOnPsiElement {
        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        @NotNull
        public String getText() {
            return MarkdownBundle.message("markdown.fix.list.items.numbering,quick.fix.text", new Object[0]);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            boolean bl = startElement instanceof MarkdownList;
            if (!bl) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            if (document == null) {
                return;
            }
            Document document2 = document;
            ListRenumberUtils.INSTANCE.renumberInBulk((MarkdownList)startElement, document2, false, true);
        }

        public ListNumberingFix(@NotNull MarkdownList list2) {
            super((PsiElement)list2);
        }
    }
}

