/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.editor.lists.ListItemIndentUnindentHandlerBase;
import org.intellij.plugins.markdown.editor.lists.ListItemInfo;
import org.intellij.plugins.markdown.editor.lists.ListRenumberUtils;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.editor.lists.MarkdownListItemTabHandler$doIndentUnindent$;
import org.intellij.plugins.markdown.editor.lists.Replacement;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownList;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/MarkdownListItemTabHandler;", "Lorg/intellij/plugins/markdown/editor/lists/ListItemIndentUnindentHandlerBase;", "baseHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "doIndentUnindent", "", "item", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;", "file", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownFile;", "document", "Lcom/intellij/openapi/editor/Document;", "updateNumbering", "", "intellij.markdown.core"})
public final class MarkdownListItemTabHandler
extends ListItemIndentUnindentHandlerBase {
    @Override
    protected boolean doIndentUnindent(@NotNull MarkdownListItem item, @NotNull MarkdownFile file, @NotNull Document document) {
        ListItemInfo itemInfo = new ListItemInfo(item, document);
        PsiElement psiElement = item.getParent();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.intellij.plugins.markdown.lang.psi.impl.MarkdownList");
        }
        MarkdownList list2 = (MarkdownList)psiElement;
        Sequence $this$filterIsInstance$iv = PsiTreeUtilKt.siblings((PsiElement)((PsiElement)list2), (boolean)false, (boolean)false);
        boolean $i$f$filterIsInstance = false;
        MarkdownList prevList = (MarkdownList)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)doIndentUnindent$$inlined$filterIsInstance$1.INSTANCE));
        Object object = prevList;
        if (object == null || (object = ListUtils.INSTANCE.getItems((MarkdownList)object)) == null) {
            object = CollectionsKt.emptyList();
        }
        List siblings2 = CollectionsKt.plus((Collection)((Collection)object), (Iterable)ListUtils.INSTANCE.getItems(list2));
        MarkdownListItem markdownListItem = (MarkdownListItem)CollectionsKt.getOrNull((List)siblings2, (int)(siblings2.indexOf(item) - 1));
        if (markdownListItem == null) {
            return false;
        }
        MarkdownListItem prevItem = markdownListItem;
        ListItemInfo prevInfo = new ListItemInfo(prevItem, document);
        if (itemInfo.getLines().getFirst() - prevInfo.getLines().getLast() > 2) {
            return false;
        }
        Replacement.Companion.replaceSafelyIn$intellij_markdown_core(itemInfo.changeIndent(prevInfo.getIndentInfo().subItemIndent()), document);
        return true;
    }

    @Override
    protected void updateNumbering(@NotNull MarkdownListItem item, @NotNull MarkdownFile file, @NotNull Document document) {
        block1: {
            PsiElement psiElement = item.getParent();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.intellij.plugins.markdown.lang.psi.impl.MarkdownList");
            }
            MarkdownList list2 = (MarkdownList)psiElement;
            ListRenumberUtils.INSTANCE.renumberInBulk(list2, document, false, Intrinsics.areEqual((Object)((MarkdownListItem)CollectionsKt.first(ListUtils.INSTANCE.getItems(list2))), (Object)item));
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
            PsiElement $this$parentOfType$iv = (PsiElement)list2;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            MarkdownList markdownList = (MarkdownList)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, MarkdownList.class, (boolean)true);
            if (markdownList == null) break block1;
            ListRenumberUtils.INSTANCE.renumberInBulk(markdownList, document, false, false);
        }
    }

    public MarkdownListItemTabHandler(@Nullable EditorActionHandler baseHandler) {
        super(baseHandler);
    }
}

