/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownList;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00152\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0012\u0010\u001b\u001a\u00020\u001c*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0015J \u0010\u001d\u001a\u0004\u0018\u00010\u000e*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00152\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u0005*\u00020\u001f2\u0006\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0016J\u001c\u0010\"\u001a\u0004\u0018\u00010\u0005*\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0016J\u001c\u0010#\u001a\u0004\u0018\u00010\u0005*\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0016R \u0010\u0003\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00060\u0004*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0015\u0010\n\u001a\u00020\u0007*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\r\u001a\u00020\u000e*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\r\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\u00060\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006$"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/ListUtils;", "", "()V", "items", "", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;", "Lkotlin/internal/NoInfer;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownList;", "getItems", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownList;)Ljava/util/List;", "list", "getList", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;)Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownList;", "normalizedMarker", "", "getNormalizedMarker", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;)Ljava/lang/String;", "sublists", "getSublists", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;)Ljava/util/List;", "getLineIndentInnerSpacesLength", "", "Lcom/intellij/openapi/editor/Document;", "lineNumber", "file", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/openapi/editor/Document;ILcom/intellij/psi/PsiFile;)Ljava/lang/Integer;", "getLineIndentRange", "Lcom/intellij/openapi/util/TextRange;", "getLineIndentSpaces", "getListItemAt", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownFile;", "offset", "document", "getListItemAtLine", "getListItemAtLineSafely", "intellij.markdown.core"})
public final class ListUtils {
    @NotNull
    public static final ListUtils INSTANCE;

    @Nullable
    public final MarkdownListItem getListItemAt(@NotNull MarkdownFile $this$getListItemAt, int offset, @NotNull Document document) {
        return this.getListItemAtLine($this$getListItemAt, document.getLineNumber(offset), document);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MarkdownListItem getListItemAtLine(@NotNull MarkdownFile $this$getListItemAtLine, int lineNumber, @NotNull Document document) {
        void $this$parentOfType$iv;
        PsiElement elementAtOffset;
        int lineStart = document.getLineStartOffset(lineNumber);
        int lineEnd = document.getLineEndOffset(lineNumber);
        int searchingOffset = CharArrayUtil.shiftBackward((CharSequence)document.getCharsSequence(), (int)lineStart, (int)(lineEnd - 1), (String)" \t\n");
        if (searchingOffset < lineStart) {
            return null;
        }
        PsiElement psiElement = elementAtOffset = PsiUtilCore.getElementAtOffset((PsiFile)((PsiFile)$this$getListItemAtLine), (int)searchingOffset);
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        return (MarkdownListItem)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, MarkdownListItem.class, (boolean)false);
    }

    @Nullable
    public final MarkdownListItem getListItemAtLineSafely(@NotNull MarkdownFile $this$getListItemAtLineSafely, int lineNumber, @NotNull Document document) {
        int n = lineNumber;
        return 0 <= n && document.getLineCount() > n ? this.getListItemAtLine($this$getListItemAtLineSafely, lineNumber, document) : null;
    }

    @NotNull
    public final TextRange getLineIndentRange(@NotNull Document $this$getLineIndentRange, int lineNumber) {
        int lineStart = $this$getLineIndentRange.getLineStartOffset(lineNumber);
        int nonWsStart = CharArrayUtil.shiftForward((CharSequence)$this$getLineIndentRange.getCharsSequence(), (int)lineStart, (String)" \t>");
        return TextRange.create((int)lineStart, (int)nonWsStart);
    }

    @Nullable
    public final String getLineIndentSpaces(@NotNull Document $this$getLineIndentSpaces, int lineNumber, @Nullable PsiFile file) {
        PsiFile psiFile = file;
        if (psiFile == null) {
            Document document;
            Document $this$run = document = $this$getLineIndentSpaces;
            boolean bl = false;
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile($this$run);
            if (virtualFile == null) {
                return null;
            }
            VirtualFile virtualFile2 = virtualFile;
            Project project = ProjectUtil.guessProjectForFile((VirtualFile)virtualFile2);
            if (project == null) {
                return null;
            }
            Project project2 = project;
            psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile($this$run);
            if (psiFile == null) {
                return null;
            }
        }
        PsiFile psiFile2 = psiFile;
        int tabSize = CodeStyle.getFacade((PsiFile)psiFile2).getTabSize();
        String indentStr = $this$getLineIndentSpaces.getText(this.getLineIndentRange($this$getLineIndentSpaces, lineNumber));
        return StringsKt.replace$default((String)indentStr, (String)"\t", (String)StringsKt.repeat((CharSequence)" ", (int)tabSize), (boolean)false, (int)4, null);
    }

    public static /* synthetic */ String getLineIndentSpaces$default(ListUtils listUtils, Document document, int n, PsiFile psiFile, int n2, Object object) {
        if ((n2 & 2) != 0) {
            psiFile = null;
        }
        return listUtils.getLineIndentSpaces(document, n, psiFile);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final Integer getLineIndentInnerSpacesLength(@NotNull Document $this$getLineIndentInnerSpacesLength, int lineNumber, @Nullable PsiFile file) {
        String string;
        String string2;
        block1: {
            String string3 = this.getLineIndentSpaces($this$getLineIndentInnerSpacesLength, lineNumber, file);
            string2 = string3;
            if (string3 == null) return null;
            String $this$takeLastWhile$iv = string2;
            boolean $i$f$takeLastWhile = false;
            for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$takeLastWhile$iv); -1 < index$iv; --index$iv) {
                char it = $this$takeLastWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (it == ' ') continue;
                String string4 = $this$takeLastWhile$iv;
                int n = index$iv + 1;
                String string5 = string4.substring(n);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
                break block1;
            }
            string = $this$takeLastWhile$iv;
        }
        string2 = string;
        if (string == null) return null;
        Integer n = string2.length();
        return n;
    }

    public static /* synthetic */ Integer getLineIndentInnerSpacesLength$default(ListUtils listUtils, Document document, int n, PsiFile psiFile, int n2, Object object) {
        if ((n2 & 2) != 0) {
            psiFile = null;
        }
        return listUtils.getLineIndentInnerSpacesLength(document, n, psiFile);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MarkdownListItem> getItems(@NotNull MarkdownList $this$items) {
        void $this$filterIsInstanceTo$iv$iv;
        PsiElement[] $this$filterIsInstance$iv = $this$items.getChildren();
        boolean $i$f$filterIsInstance = false;
        PsiElement[] psiElementArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof MarkdownListItem)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MarkdownList> getSublists(@NotNull MarkdownListItem $this$sublists) {
        void $this$filterIsInstanceTo$iv$iv;
        PsiElement[] $this$filterIsInstance$iv = $this$sublists.getChildren();
        boolean $i$f$filterIsInstance = false;
        PsiElement[] psiElementArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof MarkdownList)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final MarkdownList getList(@NotNull MarkdownListItem $this$list) {
        PsiElement psiElement = $this$list.getParent();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.intellij.plugins.markdown.lang.psi.impl.MarkdownList");
        }
        return (MarkdownList)psiElement;
    }

    @NotNull
    public final String getNormalizedMarker(@NotNull MarkdownListItem $this$normalizedMarker) {
        PsiElement psiElement = $this$normalizedMarker.getMarkerElement();
        Intrinsics.checkNotNull((Object)psiElement);
        String string = psiElement.getText();
        String it = string = ((Object)StringsKt.trim((CharSequence)string)).toString();
        boolean bl = false;
        return it + " ";
    }

    private ListUtils() {
    }

    static {
        ListUtils listUtils;
        INSTANCE = listUtils = new ListUtils();
    }
}

